/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.olap.Input;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.CustomizedInput;
import kd.bos.algo.RowMeta;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.olap.metadata.IMetadataBuilder;
import kd.bos.olap.metadata.StringMetadataBuilder;
import kd.macc.faf.datasync.olap.dao.ConnectionManager;
import kd.macc.faf.datasync.olap.dao.OlapDataReader;
import kd.macc.faf.enums.OlapFromServiceEnum;

public class CubeInput
implements CustomizedInput {
    private RowMeta cubeRowMeta;
    private OlapDataReader reader;
    private String cubeCatelog;
    private OlapFromServiceEnum dataSourceTypeEnum;
    private String[] selectDims;
    private Map<String, Set<String>> dimFilters;

    public CubeInput(RowMeta cubeRowMeta, OlapDataReader reader) {
        this.cubeRowMeta = cubeRowMeta;
        this.reader = reader;
    }

    public CubeInput(RowMeta cubeRowMeta, String cubeCatelog, OlapFromServiceEnum dataSourceTypeEnum, String[] selectDims, Map<String, Set<String>> dimFilters) {
        this.cubeRowMeta = cubeRowMeta;
        this.cubeCatelog = cubeCatelog;
        this.dataSourceTypeEnum = dataSourceTypeEnum;
        this.selectDims = selectDims;
        this.dimFilters = dimFilters;
    }

    public Iterator<Object[]> createIterator() {
        OlapConnection conn = ConnectionManager.getInstance().openConnection(this.cubeCatelog, this.dataSourceTypeEnum);
        this.reader = new OlapDataReader(conn, new OlapCommand(conn, (CommandInfo)this.buildSelectCommandInfo()).executeReader((IMetadataBuilder)StringMetadataBuilder.INSTANCE));
        return this.reader;
    }

    public void close() {
        this.reader.close();
    }

    public RowMeta getRowMeta() {
        return this.cubeRowMeta;
    }

    private SelectCommandInfo buildSelectCommandInfo() {
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        queryInfo.addDims(this.selectDims);
        queryInfo.addMeasures(new String[]{"FMONEY"});
        for (Map.Entry<String, Set<String>> en : this.dimFilters.entrySet()) {
            queryInfo.addFilter(en.getKey(), en.getValue().toArray(new String[0]));
        }
        return queryInfo;
    }
}

