/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.Grouper;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.algox.FAFSQLBuilder;
import kd.macc.faf.algox.XDbOutput;
import kd.macc.faf.datasync.func.FAFOlapDataProcessFunction;
import kd.macc.faf.datasync.olap.Input.CubeInput;
import kd.macc.faf.datasync.util.FAFDataSyncUtil;
import kd.macc.faf.dto.OlapDataExtractingDTO;
import kd.macc.faf.engine.model.FAFOlapDataStatisticsInfo;
import kd.macc.faf.enums.FAFOlapSelectTypeEnum;
import kd.macc.faf.enums.OlapFromServiceEnum;
import kd.macc.faf.olap.KdOlapServerHelper;
import kd.macc.faf.olap.OlapMultipleSplitSQLBuilder;
import kd.macc.faf.olap.OlapSQLBuilder;

public class FAFOlapDataProcessTask {
    public static FAFOlapDataProcessTask getInstance() {
        return InnerClass.instance;
    }

    private FAFOlapDataProcessTask() {
    }

    public Input createCubeInput(OlapDataExtractingDTO dto, OlapSQLBuilder sqlBuilder) {
        return new CubeInput(dto.buildOlapRowMeta(), dto.getCubeCatelog(), dto.getDataSourceTypeEnum(), sqlBuilder.getSelectDims(), sqlBuilder.getDimFilters());
    }

    public JobSession execute(OlapDataExtractingDTO dto, Long modelId, OlapSQLBuilder sqlBuilder, Map<String, Map<String, Long>> entityNumberTransIdMap) {
        RowMeta newRowMeta = FAFDataSyncUtil.getDetailModelRowMeta(modelId);
        JobSession session = AlgoX.createSession((String)("pa_sync_data_" + dto.getDataSourceTypeEnum().toString()), (String)ResManager.loadKDString((String)"\u76c8\u5229\u80fd\u529b\u5206\u6790\u6570\u636e\u540c\u6b65", (String)"FAFOlapDataProcessTask_0", (String)"macc-faf-business", (Object[])new Object[0]));
        Input cubeInput = this.createCubeInput(dto, sqlBuilder);
        DataSetX dataSetX = session.fromInput(cubeInput);
        Grouper groupBy = dataSetX.groupBy(sqlBuilder.getGroupByFields());
        DataSetX dataSetXResult = groupBy.reduceGroup((GroupReduceFunction)new FAFOlapDataProcessFunction(newRowMeta, dataSetX.getRowMeta(), dto, entityNumberTransIdMap));
        Date date = new Date();
        if (dto.isHaveTime()) {
            dataSetXResult = dataSetXResult.addFields(new Field[]{new Field("createtime", (DataType)DataType.TimestampType)}, new Object[]{date});
        }
        if (dto.isCreateStamp()) {
            dataSetXResult = dataSetXResult.addFields(new Field[]{new Field("createstamp", (DataType)DataType.LongType)}, new Object[]{date.getTime()});
        }
        XDbOutput insertOutput = new XDbOutput("fias", this.getInsertSQL(dataSetXResult.getRowMeta(), dto.getAnalysisModelDyObj(), "'" + dto.getDataSourceTypeEnum().getCode() + "'"), dataSetXResult.getRowMeta());
        dataSetXResult.output((Output)insertOutput);
        return session;
    }

    public String getInsertSQL(RowMeta rowMeta, String tableNumber, String formId) {
        FAFSQLBuilder builder = new FAFSQLBuilder("t_" + tableNumber);
        for (String fieldName : rowMeta.getFieldNames()) {
            builder.insert("f" + fieldName);
        }
        return builder.insert("fcollectstatus", "0").insert("foperationstatus", "0").insert("fdatastatus", "0").insert("fdel", "0").insert("fsituationtype", "0").insert("foffstatus", "0").insert("fsourceformid", formId).toInsertSQL();
    }

    public Map<String, Map<String, Long>> getEntityNumberTransIdMap(OlapDataExtractingDTO olapDataExtDTO, OlapMultipleSplitSQLBuilder sqlBuilder) {
        HashMap<String, Map<String, Long>> dimEntityNumberTransIdMap = new HashMap<String, Map<String, Long>>(10);
        Map dimEntityMapping = olapDataExtDTO.getDimEntityMapping();
        Long moduleId = olapDataExtDTO.getModuleId();
        Map selectDimensions = olapDataExtDTO.getSelectDimensionMap();
        List transDimsList = (List)selectDimensions.get(FAFOlapSelectTypeEnum.TRANS_TYPE.getIntCode());
        Map dimFilters = sqlBuilder.getDimFilters();
        for (Map.Entry dimEntry : dimFilters.entrySet()) {
            if (transDimsList.contains(dimEntry.getKey())) continue;
            QFilter qFilter = new QFilter("number", "in", dimEntry.getValue());
            qFilter.and(new QFilter("model", "=", (Object)moduleId));
            String entity = (String)dimEntityMapping.get(dimEntry.getKey());
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.faf.engine.task.impl.FAFOlapDataSyncTaskBuilder.build", (String)entity, (String)"number, id", (QFilter[])qFilter.toArray(), null);
            Throwable throwable = null;
            try {
                HashMap<String, Long> numberIdMap = new HashMap<String, Long>(((Set)dimEntry.getValue()).size());
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    numberIdMap.put(next.getString("number"), next.getLong("id"));
                }
                dimEntityNumberTransIdMap.put((String)dimEntry.getKey(), (Map<String, Long>)numberIdMap);
            }
            catch (Throwable numberIdMap) {
                throwable = numberIdMap;
                throw numberIdMap;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable numberIdMap) {
                        throwable.addSuppressed(numberIdMap);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        Map usedDimMemberMap = sqlBuilder.getUsedDimMemberMap();
        for (Map.Entry memberEntry : usedDimMemberMap.entrySet()) {
            String changeDimension = (String)memberEntry.getKey();
            if (dimEntityNumberTransIdMap.get(changeDimension) != null) continue;
            Set olapDimMember = (Set)memberEntry.getValue();
            String entity = (String)dimEntityMapping.get(changeDimension);
            QFilter qFilter = new QFilter("number", "in", (Object)olapDimMember);
            qFilter.and(new QFilter("model", "=", (Object)moduleId));
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.faf.engine.task.impl.FAFOlapDataSyncTaskBuilder.build", (String)entity, (String)"number, id", (QFilter[])qFilter.toArray(), null);
            Throwable throwable = null;
            try {
                HashMap<String, Long> numberIdMap = new HashMap<String, Long>(olapDimMember.size());
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    numberIdMap.put(next.getString("number"), next.getLong("id"));
                }
                dimEntityNumberTransIdMap.put(changeDimension, numberIdMap);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        return dimEntityNumberTransIdMap;
    }

    public OlapMultipleSplitSQLBuilder validateDimMembersAndGetSQlBuilder(OlapDataExtractingDTO olapDataExtDTO) {
        String cubeNumber = olapDataExtDTO.getCubeCatelog();
        Map dimensionFilters = olapDataExtDTO.getDimFilters();
        OlapFromServiceEnum dataSourceTypeEnum = olapDataExtDTO.getDataSourceTypeEnum();
        List measureDimensions = (List)olapDataExtDTO.getSelectDimensionMap().get(FAFOlapSelectTypeEnum.TRANS_TYPE.getIntCode());
        HashSet changeRowKeys = new HashSet((Collection)olapDataExtDTO.getSelectDimensionMap().get(FAFOlapSelectTypeEnum.CHANGE_ROWKEY_TYPE.getIntCode()));
        Map validateDimFilterMap = KdOlapServerHelper.validateDimMemTasks((Map)dimensionFilters, null, (String)cubeNumber, (OlapFromServiceEnum)dataSourceTypeEnum);
        Map usedDimMemberMap = KdOlapServerHelper.acquireUsedDimMemTasks(changeRowKeys, (Map)validateDimFilterMap, (String)cubeNumber, (OlapFromServiceEnum)dataSourceTypeEnum);
        LinkedList<String> splitDimNames = new LinkedList<String>();
        ArrayList sortBufList = new ArrayList(usedDimMemberMap.entrySet());
        Collections.sort(sortBufList, (src, target) -> ((Set)target.getValue()).size() - ((Set)src.getValue()).size());
        if (changeRowKeys.contains("Entity")) {
            splitDimNames.add("Entity");
        }
        if (changeRowKeys.contains("Account")) {
            splitDimNames.add("Account");
        }
        for (Map.Entry entry : sortBufList) {
            if (splitDimNames.contains(entry.getKey())) continue;
            splitDimNames.add((String)entry.getKey());
        }
        for (Map.Entry entry : dimensionFilters.entrySet()) {
            if (measureDimensions.contains(entry.getKey()) || splitDimNames.contains(entry.getKey())) continue;
            splitDimNames.add((String)entry.getKey());
        }
        boolean ignoreMeasureNull = false;
        FAFOlapDataStatisticsInfo fAFOlapDataStatisticsInfo = KdOlapServerHelper.queryDimMemComboStatistics((String)cubeNumber, (String)((String)splitDimNames.getFirst()), null, (Map)validateDimFilterMap, (boolean)ignoreMeasureNull, (OlapFromServiceEnum)dataSourceTypeEnum);
        OlapMultipleSplitSQLBuilder multipleSplitSQLBuilder = new OlapMultipleSplitSQLBuilder(cubeNumber, validateDimFilterMap, ignoreMeasureNull, fAFOlapDataStatisticsInfo, 100000, splitDimNames, dataSourceTypeEnum);
        multipleSplitSQLBuilder.batchAddSelectDimensions(olapDataExtDTO.getSelectDimensionMap());
        multipleSplitSQLBuilder.startSplitTask();
        multipleSplitSQLBuilder.setUsedDimMemberMap(usedDimMemberMap);
        return multipleSplitSQLBuilder;
    }

    private static class InnerClass {
        private static final FAFOlapDataProcessTask instance = new FAFOlapDataProcessTask();

        private InnerClass() {
        }
    }
}

