/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.Grouper;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.JoinFunction;
import kd.bos.algox.MapFunction;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.algox.FAFJoinLinkFunction;
import kd.macc.faf.algox.FAFJoinLinkInfo;
import kd.macc.faf.algox.XDbOutput;
import kd.macc.faf.datasync.FAFDataSyncDTO;
import kd.macc.faf.datasync.FAFDataSyncPOJO;
import kd.macc.faf.datasync.exec.data.DataSyncSchema;
import kd.macc.faf.datasync.exec.data.DataSyncTransfer;
import kd.macc.faf.datasync.func.FAFBizVoucherReduceMulitGroupFunction;
import kd.macc.faf.datasync.func.FAFConditionDataFunction;
import kd.macc.faf.datasync.func.FAFGlassistMapFunction;
import kd.macc.faf.datasync.func.FAFGlassistReduceGroupFunction;
import kd.macc.faf.datasync.func.FAFMultiClassDataFunction;
import kd.macc.faf.datasync.func.FAFReplaceDataFunction;
import kd.macc.faf.datasync.func.FAFSimpleDataSyncFunction;
import kd.macc.faf.datasync.func.FAFSimpleReduceGroupFunction;
import kd.macc.faf.datasync.model.MultiClassDimensionInfo;
import kd.macc.faf.enums.DataSourceTypeEnum;

public class FAFStandardEntityProcessTask {
    private static final Log logger = LogFactory.getLog(FAFStandardEntityProcessTask.class);

    private FAFStandardEntityProcessTask() {
    }

    /*
     * WARNING - void declaration
     */
    public static JobSession createSession(DataSourceTypeEnum dataSourceTypeEnum, FAFDataSyncDTO dto, DataSyncSchema<?> dataSyncSchema) {
        void var16_22;
        DataSetX dsXResult;
        Grouper group;
        List<DataSyncTransfer> dataTransfers = dataSyncSchema.getDataTransfers();
        dto.appendSelectFields(dataTransfers);
        RowMeta newRowMeta = dto.buildNewRowMeta();
        JobSession session = AlgoX.createSession((String)("pa_sync_data_" + dataSourceTypeEnum.toString() + "_" + dto.getTableNumber()), (String)ResManager.loadKDString((String)"\u76c8\u5229\u80fd\u529b\u5206\u6790\u6570\u636e\u540c\u6b65", (String)"FAFStandardEntityProcessTask_0", (String)"macc-faf-business", (Object[])new Object[0]));
        FAFDataSyncPOJO pojo = dto.buildPaDataSyncPOJO();
        OrmInput ormInput = new OrmInput("kd.macc.faf.datasync.task.FAFStandardEntityProcessTask", dto.getDataSourceNumber(), dto.getSelectFields(), dto.buildQFilter(false));
        DataSetX dataSetX = session.fromInput((Input)ormInput);
        logger.info(String.format("[MACC-FAF] ProcessTask SelectFields : %1$s, dataSourceNumber : %2$s", dto.getSelectFields(), dto.getDataSourceNumber()));
        Set<String> flexFields = dto.getFlexFields();
        if (!flexFields.isEmpty()) {
            for (String flexField : flexFields) {
                for (Map.Entry<String, OrmInput> entry : dataSyncSchema.getFlexFieldOrmInput(flexField).entrySet()) {
                    DataSetX flexFieldDsx = session.fromInput((Input)entry.getValue());
                    JoinDataSetX joinDsX = dataSetX.leftJoin(flexFieldDsx).on(flexField, "hg");
                    FAFJoinLinkInfo fAFJoinLinkInfo = dto.buildGLAssistJoinLinkInfo(flexField, entry.getKey());
                    dataSetX = joinDsX.withFunc((JoinFunction)new FAFJoinLinkFunction(dataSetX.getRowMeta(), fAFJoinLinkInfo));
                    if (pojo.getEntryNumber() != null) {
                        Grouper group2 = dataSetX.groupBy(new String[]{pojo.getEntryNumber()});
                        dataSetX = group2.reduceGroup((GroupReduceFunction)new FAFGlassistReduceGroupFunction(dataSetX.getRowMeta(), newRowMeta, pojo, flexField, entry.getKey()));
                        continue;
                    }
                    dataSetX = dataSetX.map((MapFunction)new FAFGlassistMapFunction(dataSetX.getRowMeta(), newRowMeta, pojo, flexField, entry.getKey()));
                }
            }
        }
        if (!pojo.getSubEntryFlexSet().isEmpty()) {
            logger.info("[MACC-FAF] SubEntryFlexSet : " + pojo.getSubEntryFlexSet());
            OrmInput subEntryInput = new OrmInput("kd.fi.pa.datasync.PADataSyncHelper.subEntry", "ai_bizvoucher", "entryentity.id as entryid, entryentity.subentryentity.flexfield as flexfield, entryentity.subentryentity.value as value", dto.buildQFilter(true), dto.buildSubEntryRowMeta());
            DataSetX subEntryDataSetX = session.fromInput((Input)subEntryInput);
            FAFJoinLinkInfo joinLinkInfo = dto.buildSubEntryJoinLinkInfo(pojo.getEntryNumber());
            JoinDataSetX joinDsX = dataSetX.leftJoin(subEntryDataSetX).on(joinLinkInfo.getLeftField(), joinLinkInfo.getRightField());
            dataSetX = joinDsX.withFunc((JoinFunction)new FAFJoinLinkFunction(dataSetX.getRowMeta(), joinLinkInfo));
        }
        if (DataSourceTypeEnum.BIZVOUCHER == dataSourceTypeEnum) {
            group = dataSetX.groupBy(new String[]{"id"});
            dsXResult = group.reduceGroup((GroupReduceFunction)new FAFBizVoucherReduceMulitGroupFunction(dataSetX.getRowMeta(), newRowMeta, pojo));
        } else if (pojo.isMultiLevelMeasure()) {
            group = dataSetX.groupBy(new String[]{"id"});
            dsXResult = group.reduceGroup((GroupReduceFunction)new FAFSimpleReduceGroupFunction(dataSetX.getRowMeta(), newRowMeta, pojo, flexFields));
        } else {
            dsXResult = dataSetX.map((MapFunction)new FAFSimpleDataSyncFunction(dataSetX.getRowMeta(), newRowMeta, pojo, flexFields));
        }
        ArrayList<Object> needRemoveFiled = new ArrayList<Object>(10);
        Map<String, Map<String, String>> transFormMap = dto.getTransFormMap();
        List<MultiClassDimensionInfo> multiClassDimensionInfoList = dto.getMultiClassDimensionInfoList();
        Map<String, List<MultiClassDimensionInfo>> multiClassMap = multiClassDimensionInfoList.stream().collect(Collectors.groupingBy(MultiClassDimensionInfo::getSourceEntity));
        for (Map.Entry entry : transFormMap.entrySet()) {
            String key = (String)entry.getKey();
            List<MultiClassDimensionInfo> multiClassDimensionInfo = multiClassMap.get(key);
            String aliasId = key + "joinid";
            Map value = (Map)entry.getValue();
            HashSet valueSet = new HashSet(value.values());
            if (multiClassDimensionInfo != null) {
                valueSet.addAll(multiClassDimensionInfo.stream().map(MultiClassDimensionInfo::getSelectTypeField).collect(Collectors.toSet()));
            }
            String selectFields = String.join((CharSequence)",", valueSet);
            OrmInput keyInput = new OrmInput("kd.fi.pa.datasync.transProperty.key", key, selectFields + ", id as " + aliasId, null);
            DataSetX keyDs = session.fromInput((Input)keyInput);
            Map multiClassDimensionInfoMap = multiClassDimensionInfo == null ? Collections.emptyMap() : multiClassDimensionInfo.stream().collect(Collectors.toMap(MultiClassDimensionInfo::getTargetField, x -> x));
            for (Map.Entry entry2 : value.entrySet()) {
                ArrayList<Object> selectFieldList;
                if (((String)entry2.getKey()).contains("$")) {
                    String useField = ((String)entry2.getValue()).contains(" as ") ? ((String)entry2.getValue()).split(" as ")[1].trim() : (String)entry2.getValue();
                    selectFieldList = new ArrayList<String>(Arrays.asList(useField, aliasId));
                    Object multiClassInfo = null;
                    if (multiClassDimensionInfoMap.get(entry2.getKey()) != null) {
                        multiClassInfo = (MultiClassDimensionInfo)multiClassDimensionInfoMap.get(entry2.getKey());
                        selectFieldList.add(((MultiClassDimensionInfo)multiClassInfo).getItemClassTypeAlias());
                    }
                    DataSetX ds = keyDs.select(selectFieldList.toArray(new String[0]));
                    ArrayList<Object> removeField = new ArrayList<Object>(selectFieldList);
                    removeField.add(entry2.getKey());
                    JoinDataSetX joinDataSetX = dsXResult.leftJoin(ds).on((String)entry2.getKey(), aliasId);
                    dsXResult = joinDataSetX.map((MapFunction)new FAFReplaceDataFunction(useField, (String)entry2.getKey(), joinDataSetX.getRowMeta(), (MultiClassDimensionInfo)multiClassInfo)).removeFields(removeField.toArray(new String[0]));
                    continue;
                }
                String[] aliasFields = ((String)entry2.getValue()).split(",");
                selectFieldList = new ArrayList(aliasFields.length + 1);
                for (String field : aliasFields) {
                    if (field.contains(" as ")) {
                        selectFieldList.add(field.split(" as ")[1].trim());
                        continue;
                    }
                    selectFieldList.add(field.trim());
                }
                selectFieldList.add(aliasId);
                DataSetX ds = keyDs.select(selectFieldList.toArray(new String[0])).distinct(new String[]{aliasId});
                JoinDataSetX joinDataSetX = dsXResult.leftJoin(ds).on((String)entry2.getKey(), aliasId);
                dsXResult = joinDataSetX.removeFields(new String[]{aliasId});
                selectFieldList.remove(aliasId);
                needRemoveFiled.addAll(selectFieldList);
            }
        }
        if (!multiClassDimensionInfoList.isEmpty()) {
            dsXResult = dsXResult.map((MapFunction)new FAFMultiClassDataFunction(dsXResult.getRowMeta(), multiClassDimensionInfoList));
            String[] removeFields = (String[])multiClassDimensionInfoList.stream().filter(MultiClassDimensionInfo::isIfOriginalField).map(MultiClassDimensionInfo::getItemClassTypeAlias).distinct().toArray(String[]::new);
            dsXResult = dsXResult.removeFields(removeFields);
        }
        if (!dto.getDimConditionDTOS().isEmpty()) {
            dsXResult = dsXResult.map((MapFunction)new FAFConditionDataFunction(dsXResult.getRowMeta(), dto.getDimConditionDTOS()));
        }
        if (!needRemoveFiled.isEmpty()) {
            dsXResult = dsXResult.removeFields(needRemoveFiled.toArray(new String[0]));
        }
        Date date = new Date();
        if (dto.isHaveTime()) {
            dsXResult = dsXResult.addFields(new Field[]{new Field("createtime", (DataType)DataType.TimestampType)}, new Object[]{date});
        }
        if (dto.isCreateStamp()) {
            dsXResult = dsXResult.addFields(new Field[]{new Field("createstamp", (DataType)DataType.LongType)}, new Object[]{date.getTime()});
        }
        String string = "";
        if (DataSourceTypeEnum.TEMPPORARY == dataSourceTypeEnum) {
            String string2 = dto.getDataSourceNumber();
        } else {
            String string3 = dataSourceTypeEnum.getFormId();
        }
        XDbOutput insertOutput = new XDbOutput("fias", dto.getInsertSQL(dsXResult.getRowMeta(), "'" + (String)var16_22 + "'"), dsXResult.getRowMeta());
        dsXResult.output((Output)insertOutput);
        return session;
    }
}

