/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.transformer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.bos.util.CollectionUtils;

public class AlgoXColumnValueWritePosTransformer
implements Serializable {
    private Map<String, Integer> outputRowIndexMap;
    private ArrayList<Integer> srcFieldValueReadIndexs;
    private int fMoneyIndex;

    protected AlgoXColumnValueWritePosTransformer() {
    }

    public static AlgoXColumnValueWritePosTransformer buildMulToSingleFieldTransformer(RowMeta newRowMeta, RowMeta rowMeta, Map<List<String>, String> transforFieldIndexMap, List<String> transTypeFields) {
        if (CollectionUtils.isEmpty(transTypeFields) || transforFieldIndexMap == null || newRowMeta == null || rowMeta == null) {
            return new AlgoXColumnValueWritePosTransformer();
        }
        AlgoXColumnValueWritePosTransformer transformer = new AlgoXColumnValueWritePosTransformer();
        transformer.fMoneyIndex = rowMeta.getFieldIndex("FMONEY");
        if (transforFieldIndexMap != null && !transforFieldIndexMap.isEmpty()) {
            LinkedHashMap<String, Integer> outputDynPropIndexMap = new LinkedHashMap<String, Integer>(transforFieldIndexMap.size());
            transformer.outputRowIndexMap = outputDynPropIndexMap;
            for (Map.Entry<List<String>, String> en : transforFieldIndexMap.entrySet()) {
                List<String> srcKeyList = en.getKey();
                if (srcKeyList == null || srcKeyList.isEmpty()) continue;
                StringBuilder keyBuf = new StringBuilder();
                for (String k : srcKeyList) {
                    keyBuf.append(k).append(';');
                }
                outputDynPropIndexMap.put(keyBuf.toString(), newRowMeta.getFieldIndex(en.getValue()));
            }
        } else {
            transformer.outputRowIndexMap = new LinkedHashMap<String, Integer>(0);
        }
        transformer.srcFieldValueReadIndexs = new ArrayList();
        for (String transTypeField : transTypeFields) {
            transformer.srcFieldValueReadIndexs.add(rowMeta.getFieldIndex(transTypeField));
        }
        return transformer;
    }

    public boolean convert(RowX sourceRow, RowX outputTargetRow) {
        if (CollectionUtils.isEmpty(this.srcFieldValueReadIndexs)) {
            return false;
        }
        StringBuilder mappingSb = new StringBuilder();
        for (Integer readIndex : this.srcFieldValueReadIndexs) {
            mappingSb.append(sourceRow.get(readIndex.intValue())).append(";");
        }
        Integer targetIndex = this.outputRowIndexMap.get(mappingSb.toString());
        if (targetIndex != null) {
            outputTargetRow.set(targetIndex.intValue(), sourceRow.get(this.fMoneyIndex));
        }
        return true;
    }
}

