/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.transformer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.macc.faf.datasync.util.FAFDataSyncUtil;
import kd.macc.faf.dto.MappingRelationShipDTO;

public class AlgoXRelationShipWritePosTransformer
implements Serializable {
    private Map<String, Object>[] outputRelationShipValueIndexMap;
    private ArrayList<Integer>[] srcFieldValueReadIndexs;
    private Integer[] targetIndexArrays;

    private AlgoXRelationShipWritePosTransformer() {
    }

    public static AlgoXRelationShipWritePosTransformer buildTransformer(List<MappingRelationShipDTO> mappingRelationShipDTOs, RowMeta rowMeta) {
        if (CollectionUtils.isEmpty(mappingRelationShipDTOs) || rowMeta == null) {
            return null;
        }
        AlgoXRelationShipWritePosTransformer transformer = new AlgoXRelationShipWritePosTransformer();
        LinkedHashMap[] outputDynPropIndexMap = new LinkedHashMap[mappingRelationShipDTOs.size()];
        Integer[] targetIndexArrays = new Integer[mappingRelationShipDTOs.size()];
        transformer.outputRelationShipValueIndexMap = outputDynPropIndexMap;
        transformer.targetIndexArrays = targetIndexArrays;
        transformer.srcFieldValueReadIndexs = new ArrayList[mappingRelationShipDTOs.size()];
        for (int i = 0; i < mappingRelationShipDTOs.size(); ++i) {
            MappingRelationShipDTO relationShipDTO = mappingRelationShipDTOs.get(i);
            if (relationShipDTO == null) continue;
            Map dimMembersIdMapping = relationShipDTO.getDimMembersIdMapping();
            LinkedHashMap outputPropIndexMap = new LinkedHashMap(dimMembersIdMapping.size());
            targetIndexArrays[i] = rowMeta.getFieldIndex(relationShipDTO.getTargetDimensionNumber());
            for (Map.Entry listObjectEntry : dimMembersIdMapping.entrySet()) {
                StringBuilder keyBuf = new StringBuilder();
                for (Object object : (List)listObjectEntry.getKey()) {
                    keyBuf.append(object).append(";");
                }
                outputPropIndexMap.put(keyBuf.toString(), listObjectEntry.getValue());
            }
            outputDynPropIndexMap[i] = outputPropIndexMap;
            ArrayList<Integer> srcFieldValueReadIndex = new ArrayList<Integer>(relationShipDTO.getSourceDimensionNumbers().size());
            for (String sourceDimensionNumber : relationShipDTO.getSourceDimensionNumbers()) {
                int fieldIndex = rowMeta.getFieldIndex(sourceDimensionNumber);
                if (fieldIndex == -1) continue;
                srcFieldValueReadIndex.add(fieldIndex);
            }
            transformer.srcFieldValueReadIndexs[i] = srcFieldValueReadIndex;
        }
        return transformer;
    }

    public boolean convert(RowX outputTargetRow, RowMeta rowMeta) {
        boolean result = true;
        for (int i = 0; i < this.targetIndexArrays.length; ++i) {
            ArrayList<Integer> readIdxList = this.srcFieldValueReadIndexs[i];
            if (CollectionUtils.isEmpty(readIdxList)) {
                result = false;
            }
            StringBuilder keyBuf = new StringBuilder();
            Iterator iterator = readIdxList.iterator();
            while (iterator.hasNext()) {
                int readIdx = (Integer)iterator.next();
                Field field = rowMeta.getField(readIdx);
                if (outputTargetRow.get(readIdx) == null) {
                    if (field.getDataType().equals((Object)DataType.LongType) || field.getDataType().equals((Object)DataType.IntegerType)) {
                        keyBuf.append("0").append(';');
                        continue;
                    }
                    keyBuf.append(';');
                    continue;
                }
                keyBuf.append(outputTargetRow.get(readIdx)).append(';');
            }
            Object value = this.outputRelationShipValueIndexMap[i].get(keyBuf.toString());
            if (value == null || StringUtils.isEmpty((String)value.toString())) {
                result = false;
            }
            Field field = rowMeta.getField(this.targetIndexArrays[i].intValue());
            FAFDataSyncUtil.setRowXValue(outputTargetRow, field.getName(), value, rowMeta);
        }
        return result;
    }
}

