/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.transformer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.datasync.BusinessDynamicObjectFactory;
import kd.macc.faf.datasync.exec.data.DataSyncDimension;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.datasync.exec.data.DataSyncSchema;
import kd.macc.faf.datasync.util.FAFDataSyncUtil;

public class DateConversionTransFormer
implements Serializable {
    private static final long serialVersionUID = 1L;
    List<Date> startDates = new ArrayList<Date>(10);
    List<Date> endDates = new ArrayList<Date>(10);
    List<Long> periodIds = new ArrayList<Long>(10);
    String sourceField;
    String targetField;

    public DateConversionTransFormer(DynamicObject scheme, Set<Long> periodIdSet) {
        Object entitySyncSchema = BusinessDynamicObjectFactory.createDataSyncSchema(scheme);
        DataSyncModel syncModel = ((DataSyncSchema)entitySyncSchema).getSyncModel();
        DataSyncDimension periodSync = ((DataSyncSchema)entitySyncSchema).getSyncDimensionMap().get(syncModel.getPeriodNumber());
        if (periodSync.getSourceProperty() instanceof DateTimeProp) {
            if ("bd_period".equals(periodSync.getSourceEntityname())) {
                Map periodMap = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)"id, begindate, enddate", (QFilter[])new QFilter[]{new QFilter("id", "in", periodIdSet)});
                for (DynamicObject dyn : periodMap.values()) {
                    this.startDates.add(dyn.getDate("begindate"));
                    this.endDates.add(dyn.getDate("enddate"));
                    this.periodIds.add(dyn.getLong("id"));
                }
                this.targetField = periodSync.getNumber();
                this.sourceField = periodSync.getSourceNumber();
            } else if ("pa_analysisperiod".equals(periodSync.getSourceEntityname())) {
                Map periodMap = BusinessDataServiceHelper.loadFromCache((String)"pa_analysisperiod", (String)"id, startdate, enddate", (QFilter[])new QFilter[]{new QFilter("id", "in", periodIdSet)});
                for (DynamicObject dyn : periodMap.values()) {
                    this.startDates.add(dyn.getDate("startdate"));
                    this.endDates.add(dyn.getDate("enddate"));
                    this.periodIds.add(dyn.getLong("id"));
                }
                this.targetField = periodSync.getNumber();
                this.sourceField = periodSync.getSourceNumber();
            }
        }
    }

    public boolean convert(RowX outputTargetRow, RowMeta newRowMeta, RowX rowX, RowMeta rowMeta) {
        boolean result = true;
        int sourceIndex = rowMeta.getFieldIndex(this.sourceField);
        if (sourceIndex != -1 && rowX.get(sourceIndex) instanceof Date) {
            Date date = rowX.getDate(sourceIndex);
            for (int i = 0; i < this.startDates.size(); ++i) {
                if (date.compareTo(this.startDates.get(i)) < 0 || date.compareTo(this.endDates.get(i)) > 0) continue;
                FAFDataSyncUtil.setRowXValue(outputTargetRow, this.targetField, this.periodIds.get(i), newRowMeta);
            }
        } else {
            result = false;
        }
        return result;
    }

    public String getTargetField() {
        return this.targetField;
    }
}

