/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasync.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.cache.DistributeCache;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.util.AnalysisModelUtil;

public class FAFDataSyncUtil {
    private static final Log logger = LogFactory.getLog(FAFDataSyncUtil.class);
    protected static ThreadLocal<SimpleDateFormat> threadLocal = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd"));

    public static void updateCacheErrorMessage(DistributeCache cache, Long syncTaskId, String message) {
        cache.put("FAF|" + syncTaskId, (Object)("error:" + message));
    }

    public static void updateCacheSuccessMessage(DistributeCache cache, Long syncTaskId, String message, boolean forceCover) {
        String cacheMessage = cache.get("FAF|" + syncTaskId);
        if (!forceCover && cacheMessage != null && cacheMessage.startsWith("error")) {
            return;
        }
        cache.put("FAF|" + syncTaskId, (Object)("success:" + message));
    }

    public static void updateCacheMessage(DistributeCache cache, Long syncTaskId, String message) {
        String cacheMessage = cache.get("FAF|" + syncTaskId);
        if (cacheMessage != null && cacheMessage.startsWith("error")) {
            return;
        }
        cache.put("FAF|" + syncTaskId, (Object)message);
    }

    public static RowMeta getModelRowMeta(String analysisModelEntity, Set<String> fieldSet) {
        String fields = String.join((CharSequence)",", fieldSet);
        return ORM.create().createRowMeta(analysisModelEntity, fields);
    }

    public static RowMeta getDetailModelRowMeta(Long modelId) {
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"pa_analysismodel");
        DynamicObjectCollection dimensionEntry = model.getDynamicObjectCollection("dimension_entry");
        DynamicObjectCollection measureEntry = model.getDynamicObjectCollection("measure_entry");
        HashSet<String> fieldSet = new HashSet<String>(dimensionEntry.size() + measureEntry.size() + 1);
        fieldSet.add("id");
        for (DynamicObject dimEntry : dimensionEntry) {
            DynamicObject dim = dimEntry.getDynamicObject("dimension");
            DimensionTypeEnum dimType = DimensionTypeEnum.getEnum((String)dim.getString("dimensiontype"));
            if (DimensionTypeEnum.NOTHING == dimType) continue;
            fieldSet.add(dim.getString("number"));
        }
        for (DynamicObject meaEntry : measureEntry) {
            DynamicObject measure = meaEntry.getDynamicObject("measure");
            fieldSet.add(measure.getString("number"));
        }
        return FAFDataSyncUtil.getModelRowMeta(AnalysisModelUtil.buildDetailEntityNumber((String)model.getString("tablenumber")), fieldSet);
    }

    public static RowX setRowXValue(RowX result, String key, Object value, RowMeta newRowMeta) {
        block30: {
            if (key == null) {
                return result;
            }
            Field field = newRowMeta.getField(key);
            DataType dataType = field.getDataType();
            if (DataType.StringType.equals((Object)dataType)) {
                if (value == null) {
                    value = " ";
                }
                result.set(newRowMeta.getFieldIndex(key), (Object)value.toString());
            } else if (DataType.LongType.equals((Object)dataType)) {
                try {
                    if (value == null) {
                        value = 0L;
                    }
                    if (value instanceof Long) {
                        result.set(newRowMeta.getFieldIndex(key), value);
                        break block30;
                    }
                    result.set(newRowMeta.getFieldIndex(key), (Object)Long.valueOf(value.toString()));
                }
                catch (NumberFormatException e) {
                    logger.info("[MACC-FAF] NumberFormatException " + e.getMessage() + value);
                }
            } else if (DataType.BigDecimalType.equals((Object)dataType)) {
                if (value == null) {
                    value = BigDecimal.ZERO;
                }
                if (value instanceof BigDecimal) {
                    result.set(newRowMeta.getFieldIndex(key), value);
                } else {
                    try {
                        BigDecimal bigDecimal = new BigDecimal(value.toString());
                        result.set(newRowMeta.getFieldIndex(key), (Object)bigDecimal);
                    }
                    catch (Exception e) {
                        logger.info("[MACC-FAF] parseException " + e.getMessage() + value);
                    }
                }
            } else if (DataType.IntegerType.equals((Object)dataType)) {
                try {
                    if (value == null) {
                        value = 0;
                    }
                    if (value instanceof Integer) {
                        result.set(newRowMeta.getFieldIndex(key), value);
                        break block30;
                    }
                    result.set(newRowMeta.getFieldIndex(key), (Object)Integer.valueOf(value.toString()));
                }
                catch (NumberFormatException e) {
                    logger.info("[MACC-FAF] NumberFormatException " + e.getMessage() + value);
                }
            } else if (DataType.TimestampType.equals((Object)dataType)) {
                if (value == null) {
                    result.set(newRowMeta.getFieldIndex(key), null);
                    return result;
                }
                if (value instanceof Date) {
                    result.set(newRowMeta.getFieldIndex(key), value);
                } else {
                    try {
                        Date date = threadLocal.get().parse(value.toString());
                        result.set(newRowMeta.getFieldIndex(key), (Object)date);
                    }
                    catch (ParseException e) {
                        logger.info("[MACC-FAF] parseException " + e.getMessage() + value);
                    }
                }
            } else {
                result.set(newRowMeta.getFieldIndex(key), value);
            }
        }
        return result;
    }
}

