/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.faf.export.DynamicExImport;

public abstract class DynamicExImportProcessor {
    private static final Log logger = LogFactory.getLog(DynamicExImportProcessor.class);
    protected final Map<String, Map<Object, DynamicObject>> dynMaps = new LinkedHashMap<String, Map<Object, DynamicObject>>();
    protected final List<DynamicExImport> exImportList = new ArrayList<DynamicExImport>();
    protected final Object pkvalue;

    protected abstract void setExImportList(List<DynamicExImport> var1);

    public DynamicExImportProcessor(Object pkvalue) {
        this.pkvalue = pkvalue;
        this.init();
    }

    protected final void init() {
        this.setExImportList(this.exImportList);
    }

    public OperationResult executeSave() {
        for (DynamicExImport exImport : this.exImportList) {
            try {
                Map<Object, DynamicObject> objectMap;
                if (!exImport.byImport() || (objectMap = this.dynMaps.get(exImport.getKey())) == null) continue;
                Collection<DynamicObject> values = objectMap.values();
                for (DynamicObject value : values) {
                    OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)exImport.getEntityName(), (DynamicObject[])new DynamicObject[]{value}, (OperateOption)OperateOption.create());
                    exImport.setImportSuccess(result.isSuccess());
                    if (result.isSuccess()) {
                        exImport.afterExcueteSave(result.isSuccess(), value);
                    }
                    if (result.isSuccess()) continue;
                    this.rollback();
                    result.setMessage(result.getMessage() + exImport.getTip() + value.getString("number"));
                    return result;
                }
            }
            catch (Exception ex) {
                logger.error("import_sys_faf save erro", (Throwable)ex);
                this.rollback();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s:\u4fdd\u5b58\u6570\u636e\u5931\u8d25,%2$s\u3002", (String)"DynamicExImportProcessor_0", (String)"macc-faf-business", (Object[])new Object[0]), exImport.getTip(), ex.getMessage()));
            }
        }
        return new OperationResult();
    }

    protected void rollback() {
        for (DynamicExImport exImport : this.exImportList) {
            Map<Object, DynamicObject> objectMap;
            if (!exImport.byImport() || !exImport.isImportSuccess() || (objectMap = this.dynMaps.get(exImport.getKey())) == null || objectMap.size() <= 0) continue;
            Object[] objects = objectMap.values().stream().map(DataEntityBase::getPkValue).toArray(Object[]::new);
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)exImport.getEntityName());
            DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])objects);
        }
    }
}

