/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.export.port;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.export.DynamicExImport;

public class DynamicExDatasource
extends DynamicExImport {
    public DynamicExDatasource() {
    }

    public DynamicExDatasource(Map<String, Map<Object, DynamicObject>> maps, Object pkvalue) {
        super(maps, pkvalue, false);
    }

    @Override
    public String getKey() {
        return "datasource:";
    }

    @Override
    public String getTip() {
        return ResManager.loadKDString((String)"\u6570\u636e\u6e90", (String)"DynamicExDatasource_0", (String)"macc-faf-business", (Object[])new Object[0]);
    }

    @Override
    public String getEntityName() {
        return "pa_datasourceconfig";
    }

    @Override
    protected String getSelect() {
        return "id,number,name,datasource_type,entity_number";
    }

    @Override
    public QFilter getQFilter() {
        return null;
    }

    @Override
    public Object loadData() {
        QFilter qFilter = new QFilter("model", "=", this.getPkvalue());
        ArrayList<Object> idList = new ArrayList<Object>(4);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"FAFDynamicExImport.load_syncschema", (String)"pa_syncdataschema", (String)"datasource", (QFilter[])qFilter.toArray(), null, (int)100);){
            for (Row row : ds) {
                idList.add(row.get(0));
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        QFilter qfilter = new QFilter("id", "in", idList);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FAFDynamicExImport.load_datasource", (String)this.getEntityName(), (String)this.getSelectProperties(), (QFilter[])qfilter.toArray(), null, (int)100);){
            for (Row row : dataSet) {
                map.put(row.getString("number"), row.getString("datasource_type") + "$" + row.getString("entity_number"));
            }
        }
        return map;
    }

    @Override
    public void parseImport(String dynbase64) {
        DynamicObject[] dyns;
        Map map = (Map)SerializationUtils.deSerializeFromBase64((String)dynbase64);
        LinkedHashMap<String, String> mapCurr = new LinkedHashMap<String, String>(map.size());
        Set numberset = map.keySet();
        QFilter qfilter = new QFilter("number", "in", numberset);
        for (DynamicObject dyna : dyns = BusinessDataServiceHelper.load((String)this.getEntityName(), (String)this.getSelectProperties(), (QFilter[])qfilter.toArray(), null)) {
            String entity_number = dyna.getString("entity_number.number");
            mapCurr.put(dyna.getString("number"), dyna.getString("datasource_type") + "$" + (entity_number == null ? "" : entity_number));
        }
        logger.info("import datasource:" + map);
        logger.info("current sys datasource:" + mapCurr);
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            if (!mapCurr.containsKey(entry.getKey())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a %1$s \u7684\u6570\u636e\u6e90\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u914d\u7f6e\u3002", (String)"DynamicExDatasource_1", (String)"macc-faf-business", (Object[])new Object[0]), entry.getKey()));
            }
            if (StringUtils.equals((CharSequence)((CharSequence)entry.getValue()), (CharSequence)((CharSequence)mapCurr.get(entry.getKey())))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a %1$s \u7684\u6570\u636e\u6e90,\u5b57\u6bb5\"\u5b9e\u4f53\u7c7b\u578b\"\u548c\"\u5b9e\u4f53\"\u4e0e\u539f\u7cfb\u7edf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u914d\u7f6e\u3002", (String)"DynamicExDatasource_2", (String)"macc-faf-business", (Object[])new Object[0]), entry.getKey()));
        }
        for (DynamicObject dyna : dyns) {
            this.putDynamic(dyna);
        }
    }
}

