/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.export.port;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.export.DynamicExImport;
import kd.macc.faf.export.DynamicLink;

public abstract class DynamicExmapping
extends DynamicExImport {
    private final List<DynamicLink> linkConfigs = new ArrayList<DynamicLink>();

    public List<DynamicLink> getLinkConfigs() {
        return this.linkConfigs;
    }

    public void setLinkConfigs(List<DynamicLink> linkConfigs) {
    }

    public DynamicExmapping(Map<String, Map<Object, DynamicObject>> dynMaps, Object pkvalue) {
        super(dynMaps, pkvalue);
        this.setLinkConfigs(this.linkConfigs);
    }

    public String getNumberKey(String entityname) {
        if ("epm_model".equals(entityname) || "bcm_model".equals(entityname)) {
            return "shownumber";
        }
        return "number";
    }

    @Override
    public Object loadData() {
        DynamicObject[] data = (DynamicObject[])super.loadData();
        ArrayList<DynamicLink[]> linkdatas = new ArrayList<DynamicLink[]>(data.length);
        List<DynamicLink> configs = this.getLinkConfigs();
        for (DynamicObject dynamic : data) {
            linkdatas.add(this.getDynamicLinkdata(configs, dynamic));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", data);
        map.put("link", linkdatas);
        return map;
    }

    private DynamicLink[] getDynamicLinkdata(List<DynamicLink> configs, DynamicObject dynamic) {
        DynamicLink[] linkdata = new DynamicLink[configs.size()];
        for (int i = 0; i < configs.size(); ++i) {
            DynamicLink link = configs.get(i);
            DynamicLink newLink = new DynamicLink(link.getLinkfield(), link.getEntityname());
            newLink.setByImportKey(link.getByImportKey());
            if ("#".equals(link.getEntityname())) {
                List<DynamicLink> _configs = link.getEntryconfigs();
                DynamicObjectCollection collection = dynamic.getDynamicObjectCollection(link.getLinkfield());
                for (DynamicObject _dynamic : collection) {
                    DynamicLink[] _linkdata = this.getDynamicLinkdata(_configs, _dynamic);
                    newLink.getEntrydata().add(_linkdata);
                }
            } else {
                boolean find;
                long pkvalue = dynamic.getLong(link.getLinkfield());
                String entityname = link.getEntityname();
                if (entityname.startsWith("$")) {
                    entityname = dynamic.getString(entityname.substring(1));
                }
                if (!(find = this.setNumberByPkvalue(newLink, pkvalue, entityname))) continue;
            }
            linkdata[i] = newLink;
        }
        return linkdata;
    }

    protected boolean setNumberByPkvalue(DynamicLink newLink, long pkvalue, String entityname) {
        if (StringUtils.isEmpty((CharSequence)entityname)) {
            return false;
        }
        DynamicObject fromCache = BusinessDataServiceHelper.loadSingleFromCache((Object)pkvalue, (String)entityname, (String)this.getNumberKey(entityname));
        if (fromCache != null) {
            newLink.setNumber(fromCache.getString(this.getNumberKey(entityname)));
            return true;
        }
        return false;
    }

    public DynamicObject[] deSerialize(String dynbase64) {
        HashMap map = (HashMap)SerializationUtils.deSerializeFromBase64((String)dynbase64);
        DynamicObject[] data = (DynamicObject[])map.get("data");
        List linkdatas = (List)FAFUtils.cast(map.get("link"));
        for (int i = 0; i < data.length; ++i) {
            DynamicObject dynamic = data[i];
            DynamicLink[] linkdata = (DynamicLink[])linkdatas.get(i);
            this.linkDynamicObject(dynamic, linkdata);
        }
        return data;
    }

    private void linkDynamicObject(DynamicObject dynamic, DynamicLink[] linkdata) {
        for (DynamicLink link : linkdata) {
            String entityname = link.getEntityname();
            if ("#".equals(entityname)) {
                DynamicObjectCollection collection = dynamic.getDynamicObjectCollection(link.getLinkfield());
                List<DynamicLink[]> entrydata = link.getEntrydata();
                for (int i = 0; i < collection.size(); ++i) {
                    DynamicObject _dynamic = (DynamicObject)collection.get(i);
                    this.linkDynamicObject(_dynamic, entrydata.get(i));
                }
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)link.getByImportKey())) {
                DynamicObject dyna = (DynamicObject)((Map)this.dynaMaps.get(link.getByImportKey())).get(link.getNumber());
                dynamic.set(link.getLinkfield(), dyna.getPkValue());
                continue;
            }
            this.linkdata(dynamic, link);
        }
    }

    private void linkdata(DynamicObject dynamic, DynamicLink link) {
        List ids;
        String entityname = link.getEntityname();
        if (entityname.startsWith("$")) {
            link.setEntityname(dynamic.getString(entityname.substring(1)));
        }
        if ((ids = QueryServiceHelper.queryPrimaryKeys((String)link.getEntityname(), (QFilter[])this.linkQFilter(dynamic, link).toArray(), null, (int)2)).size() == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7f16\u53f7\u4e3a%2$s\u7684\u57fa\u7840\u8d44\u6599(%3$s)\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u7cfb\u7edf\u914d\u7f6e\u3002", (String)"DynamicExmapping_0", (String)"macc-faf-business", (Object[])new Object[0]), this.getTip(), link.getNumber(), this.getEntityCaption(link.getEntityname())));
        }
        if (ids.size() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7f16\u53f7\u4e3a%2$s\u7684\u57fa\u7840\u8d44\u6599(%3$s)\u5b58\u5728\u591a\u4e2a\uff0c\u8bf7\u68c0\u67e5\u7cfb\u7edf\u914d\u7f6e\u3002", (String)"DynamicExmapping_1", (String)"macc-faf-business", (Object[])new Object[0]), this.getTip(), link.getNumber(), link.getEntityname()));
        }
        dynamic.set(link.getLinkfield(), ids.get(0));
    }

    protected QFilter linkQFilter(DynamicObject dynamic, DynamicLink linkCompare) {
        return new QFilter(this.getNumberKey(linkCompare.getEntityname()), "=", (Object)linkCompare.getNumber());
    }

    @Override
    protected void putDynamic(DynamicObject importDyn, DynamicObject newDyn) {
        if (importDyn != null && newDyn != null) {
            ((Map)this.dynaMaps.get(this.getKey())).put(importDyn.getPkValue(), newDyn);
        }
    }

    @Override
    protected DynamicObject validDynamic(DynamicObject importDyn) {
        return importDyn;
    }

    @Override
    protected DynamicObject validDynamic(DynamicObject importDyn, DynamicObject newDynamic) {
        return newDynamic;
    }
}

