/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.export.sys;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.export.DynamicExImportProcessor;
import kd.macc.faf.export.IDataExImport;
import kd.macc.faf.export.sys.AnalysisSystemExImportProcessor;

public class AnalysisSystemExportBuilder
extends AnalysisSystemExImportProcessor {
    private static final Log logger = LogFactory.getLog(DynamicExImportProcessor.class);
    private final String filename;
    private final StringBuilder sb;

    public AnalysisSystemExportBuilder(Object pkValue) {
        super(pkValue);
        DynamicObject system = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)"pa_anasystemsetting", (String)"number,name");
        if (system == null) {
            throw new KDBizException("analysis system is null.");
        }
        this.filename = system.getString("number") + "-" + system.getString("name");
        this.sb = new StringBuilder();
    }

    public String build() {
        for (IDataExImport exImport : this.exImportList) {
            try {
                String toBase64 = exImport.exportToString();
                if (!StringUtils.isNotEmpty((CharSequence)toBase64)) continue;
                this.sb.append(toBase64).append("\r\n");
            }
            catch (Exception ex) {
                logger.error("export erro", (Throwable)ex);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u4f53\u7cfb\u53d1\u751f\u9519\u8bef%s", (String)"AnalysisSystemExportBuilder_0", (String)"macc-faf-business", (Object[])new Object[0]), ex.getMessage()));
            }
        }
        String toString = this.sb.toString();
        return toString;
    }

    public String getExportFileName() {
        return "export_sys-" + this.filename + ".dts";
    }
}

