/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.fas.exception.FAFFormulaTranslationException;
import kd.macc.faf.fas.formula.FormulaCalculatorHelper;
import kd.macc.faf.fas.formula.ParseException;

public class FAFFormulaCalculationDataHelper {
    public static String translateFormulaExpression(String expression, Long systemId) throws FAFFormulaTranslationException {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        try {
            FormulaCalculatorHelper.tryCalculate((String)expression);
        }
        catch (Error | ParseException exception) {
            throw new FAFFormulaTranslationException(String.format(ResManager.loadKDString((String)"\u8bed\u6cd5\u9519\u8bef:%1$s%2$s", (String)"FAFFormulaCalculationDataHelper_0", (String)"macc-faf-business", (Object[])new Object[0]), "\r\n", exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage()));
        }
        List<String> validIndexNumberList = FAFFormulaCalculationDataHelper.getVariateNumberInFormula(expression);
        QFilter numberFilter = new QFilter("number", "in", validIndexNumberList);
        QFilter systemFilter = new QFilter("system", "=", (Object)systemId);
        Map idDynamicMap = BusinessDataServiceHelper.loadFromCache((String)"pa_fasindex", (QFilter[])new QFilter[]{numberFilter, systemFilter});
        Map<String, DynamicObject> numberDynamicMap = idDynamicMap.values().stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy));
        int i = 1;
        boolean existIndexNumber = false;
        ArrayList<String> nonIndexNumberList = new ArrayList<String>();
        HashMap<String, String> tempVariables = new HashMap<String, String>(validIndexNumberList.size());
        String expressionDesc = expression = FAFFormulaCalculationDataHelper.formatFormulaExpression(expression);
        for (String string : validIndexNumberList) {
            DynamicObject index = numberDynamicMap.get(string);
            if (index != null && StringUtils.isNotBlank((CharSequence)index.getString("name"))) {
                String tempVariable = String.format("###%s###", i);
                tempVariables.put(tempVariable, index.getString("name"));
                expressionDesc = expressionDesc.replace(string, tempVariable);
                existIndexNumber = true;
                ++i;
                continue;
            }
            nonIndexNumberList.add(string);
        }
        if (!CollectionUtils.isEmpty(nonIndexNumberList)) {
            throw new FAFFormulaTranslationException(String.format(ResManager.loadKDString((String)"\u8bed\u6cd5\u9519\u8bef:%1$s\u5b58\u5728\u4e0d\u5408\u6cd5\u53c2\u6570 (%2$s)", (String)"FAFFormulaCalculationDataHelper_1", (String)"macc-faf-business", (Object[])new Object[0]), "\r\n", String.join((CharSequence)"\uff0c", nonIndexNumberList)));
        }
        if (!existIndexNumber) {
            throw new FAFFormulaTranslationException(String.format(ResManager.loadKDString((String)"\u8bed\u6cd5\u9519\u8bef:%s\u4e0d\u652f\u6301\u7eaf\u5e38\u91cf\u516c\u5f0f\u8ba1\u7b97", (String)"FAFFormulaCalculationDataHelper_2", (String)"macc-faf-business", (Object[])new Object[0]), "\r\n"));
        }
        for (Map.Entry entry : tempVariables.entrySet()) {
            expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return expressionDesc;
    }

    public static String formatFormulaExpression(String formulaExpression) {
        List tokens;
        if (StringUtils.isBlank((CharSequence)formulaExpression)) {
            return "";
        }
        try {
            tokens = FormulaCalculatorHelper.resolveFormulaAsTokenList((String)formulaExpression);
        }
        catch (Error | ParseException e) {
            throw new FAFFormulaTranslationException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u5f02\u5e38,\u683c\u5f0f\u5316\u5931\u8d25 : %s", (String)"FAFFormulaCalculationDataHelper_3", (String)"macc-faf-business", (Object[])new Object[0]), e.getCause() != null ? e.getCause().getMessage() : e.getMessage()));
        }
        String formatFormulaExpression = tokens.stream().map(token -> token.image).collect(Collectors.joining(" "));
        return formatFormulaExpression.length() >= 500 ? formulaExpression : formatFormulaExpression;
    }

    public static List<String> getVariateNumberInFormula(String formulaExpression) {
        List tokens;
        if (StringUtils.isBlank((CharSequence)formulaExpression)) {
            return new ArrayList<String>();
        }
        try {
            tokens = FormulaCalculatorHelper.resolveFormulaAsTokenList((String)formulaExpression);
        }
        catch (Error | ParseException e) {
            throw new FAFFormulaTranslationException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u5f02\u5e38,\u83b7\u53d6\u516c\u5f0f\u4e2d\u7684\u53d8\u91cf\u7f16\u53f7\u96c6\u5408\u5931\u8d25 : %s", (String)"FAFFormulaCalculationDataHelper_4", (String)"macc-faf-business", (Object[])new Object[0]), e.getCause() != null ? e.getCause().getMessage() : e.getMessage()));
        }
        return tokens.stream().filter(token -> token.kind == 6).map(variateToken -> variateToken.image).distinct().collect(Collectors.toList());
    }
}

