/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.DefaultFilterValueSetter;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.IFilterValueSetter;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.enums.FAFDimensionTypeEnum;
import kd.macc.faf.fas.dto.FAFDateRange;
import kd.macc.faf.fas.index.FAFIndexDynamicObject;
import kd.macc.faf.fas.index.model.FAFIndex;

public class FAFIndexBusinessHelper {
    public static List<DynamicObject> loadAllDimensions(Object ... pkValues) {
        List list = null;
        for (Object obj : pkValues) {
            FAFIndex root = FAFIndexDynamicObject.create(obj).getRoot();
            if (list == null) {
                list = root.getDimensions();
                continue;
            }
            list.retainAll(root.getDimensions());
        }
        return list;
    }

    public static List<Object> loadAllDimensionIds(Object pkId) {
        FAFIndex root = FAFIndexDynamicObject.create(pkId).getRoot();
        return root.getDimensions().stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
    }

    public static String getEntityNumber(DynamicObject dyModel) {
        if (dyModel != null) {
            String tablenumber = dyModel.getString("tablenumber");
            if (StringUtils.isNotEmpty((CharSequence)tablenumber)) {
                return "pa_" + dyModel.getString("tablenumber");
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u578b\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u672a\u521b\u5efa\u3002", (String)"FAFIndexBusinessHelper_0", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        return null;
    }

    public static String getBasedataByDimension(DynamicObject dimension) {
        String dimensiontype = dimension.getString("dimensiontype");
        if (FAFDimensionTypeEnum.DATABASE.eqScene((Object)dimensiontype)) {
            return dimension.getString("dimensionsource_id");
        }
        if (FAFDimensionTypeEnum.ASSISTANTDATA.eqScene((Object)dimensiontype)) {
            return "bos_assistantdata_detail";
        }
        return null;
    }

    public static Map<String, Map<Object, String>> getEnumDimMap(Map<Object, DynamicObject> dimensionMap) {
        List enumDimList = dimensionMap.values().stream().filter(dy -> FAFDimensionTypeEnum.DENUMS.eqScene((Object)dy.getString("dimensiontype"))).collect(Collectors.toList());
        HashMap<String, Map<Object, String>> result = new HashMap<String, Map<Object, String>>(enumDimList.size());
        for (DynamicObject enumDimDy : enumDimList) {
            DynamicObjectCollection enumValueCol = enumDimDy.getDynamicObjectCollection("entryentityenums");
            Map<Object, String> collect = enumValueCol.stream().collect(Collectors.toMap(row -> row.get("value"), row -> row.getString("title")));
            result.put(enumDimDy.getString("number"), collect);
        }
        return result;
    }

    public static List<QFilter> getIndexModelQFilter(DynamicObject model, String conditionJson) {
        String entityNumber = FAFIndexBusinessHelper.getEntityNumber(model);
        return FAFIndexBusinessHelper.getIndexModelQFilter(entityNumber, conditionJson);
    }

    public static List<QFilter> getIndexModelQFilter(String entityNumber, String conditionJson) {
        if (StringUtils.isEmpty((CharSequence)conditionJson)) {
            return new ArrayList<QFilter>(0);
        }
        ArrayList<QFilter> list = new ArrayList<QFilter>(1);
        QFilter qFilter = FAFIndexBusinessHelper.getIndexModelSimpleQFilter(entityNumber, conditionJson);
        if (qFilter != null) {
            list.add(qFilter);
        }
        return list;
    }

    public static QFilter getIndexModelSimpleQFilter(String entityNumber, String conditionJson) {
        try {
            if (StringUtils.isEmpty((CharSequence)conditionJson)) {
                return null;
            }
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class);
            List filterRow = filterCondition.getFilterRow();
            for (SimpleFilterRow simpleFilterRow : filterRow) {
                String fieldName = simpleFilterRow.getFieldName();
                int charIndex = fieldName.indexOf(".");
                if (charIndex <= -1) continue;
                simpleFilterRow.setFieldName(fieldName.substring(0, charIndex));
                if (!"9".equals(simpleFilterRow.getCompareType())) continue;
                simpleFilterRow.setCompareType("83");
                FilterValue filterValue = new FilterValue();
                filterValue.setValue((Object)"0");
                simpleFilterRow.setValue(Collections.singletonList(filterValue));
            }
            FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumber), filterCondition, (IFilterValueSetter)new DefaultFilterValueSetter(){

                public List<Object> getFieldValue(SimpleFilterRow simpleFilterRow) {
                    List baseDataIds = simpleFilterRow.getBaseDataIds();
                    if (baseDataIds.isEmpty()) {
                        return new DefaultFilterValueSetter().getFieldValue(simpleFilterRow);
                    }
                    return simpleFilterRow.getBaseDataIds().stream().map(FilterValue::getValue).collect(Collectors.toList());
                }
            }, true, null);
            filterBuilder.buildFilter(false);
            return filterBuilder.getQFilter();
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6307\u6807\u201c\u7ef4\u5ea6\u8fc7\u6ee4\u6761\u4ef6\u201d\u914d\u7f6e\u9519\u8bef\u3002", (String)"FAFIndexBusinessHelper_1", (String)"macc-faf-business", (Object[])new Object[0]));
        }
    }

    public static QFilter getQFilterByDimension(DynamicObject dimension) {
        if (dimension == null) {
            return null;
        }
        String dimensiontype = dimension.getString("dimensiontype");
        if (FAFDimensionTypeEnum.DATABASE.eqScene((Object)dimensiontype)) {
            String grouptype = dimension.getString("typefield");
            Object group_id = dimension.get("group_id");
            if (StringUtils.isNotEmpty((CharSequence)grouptype) && group_id != null) {
                QFilter qFilter = new QFilter(grouptype, "=", group_id);
                if ("bd_period".equals(dimension.getString("dimensionsource_id"))) {
                    qFilter = qFilter.and("isadjustperiod", "=", (Object)"0");
                }
                return qFilter;
            }
            if ("pa_analysisperiod".equals(dimension.getString("dimensionsource_id"))) {
                return new QFilter("isadjust", "=", (Object)"0");
            }
            return null;
        }
        if (FAFDimensionTypeEnum.ASSISTANTDATA.eqScene((Object)dimensiontype)) {
            DynamicObject assistant = dimension.getDynamicObject("assistantsource");
            return new QFilter("group", "=", assistant.getPkValue());
        }
        return null;
    }

    public static Object covertTypeTo(String name, Class<?> primaryKeyType, Object o) {
        if (primaryKeyType == Long.class) {
            if (o instanceof Long) {
                return o;
            }
            try {
                return Long.parseLong(String.valueOf(o));
            }
            catch (Exception ex) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570[%s]\u5165\u53c2\u7c7b\u578b\u9519\u8bef\u3002", (String)"FAFIndexBusinessHelper_2", (String)"macc-faf-business", (Object[])new Object[0]), name));
            }
        }
        if (primaryKeyType == Date.class) {
            return FAFDateRange.toDate((String)String.valueOf(o));
        }
        return String.valueOf(o);
    }

    public static Class<?> getDimensionPrimaryKeyType(DynamicObject dimension) {
        String dimensiontype = dimension.getString("dimensiontype");
        if (FAFDimensionTypeEnum.DATABASE.eqScene((Object)dimensiontype)) {
            Object dimensionsource = dimension.getDynamicObject("dimensionsource").getPkValue();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)((String)dimensionsource));
            ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
            if (primaryKey instanceof VarcharProp) {
                return String.class;
            }
            return Long.class;
        }
        if (FAFDimensionTypeEnum.ASSISTANTDATA.eqScene((Object)dimensiontype)) {
            return Long.class;
        }
        if (FAFDimensionTypeEnum.OTHER.eqScene((Object)dimensiontype)) {
            return String.class;
        }
        if (FAFDimensionTypeEnum.DENUMS.eqScene((Object)dimensiontype)) {
            return String.class;
        }
        if (FAFDimensionTypeEnum.DATE.eqScene((Object)dimensiontype)) {
            return Date.class;
        }
        return String.class;
    }

    public static List<Long> getOrderedIndexIdsByNumbers(List<String> indexNumberList, Long systemId) {
        ArrayList<Long> indexIds = new ArrayList<Long>(16);
        QFilter numberFilter = new QFilter("number", "in", indexNumberList);
        QFilter systemFilter = new QFilter("system", "=", (Object)systemId);
        Map<String, Long> indexNumberIdsMap = QueryServiceHelper.query((String)"pa_fasindex", (String)"id,number", (QFilter[])new QFilter[]{numberFilter, systemFilter}).stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getLong("id")));
        for (String indexNumber : indexNumberList) {
            indexIds.add(indexNumberIdsMap.get(indexNumber));
        }
        return indexIds;
    }

    public static FAFIndex buildFasIndex(ReportQueryParam queryParam) {
        Map customParam = queryParam.getCustomParam();
        String comparisontype = (String)customParam.get("comparisontype");
        FAFIndex fasindex = FAFIndexDynamicObject.create(customParam.get("pkValue")).calculateMix(customParam, comparisontype);
        String includeProcess = (String)customParam.get("includeProcess");
        if ("false".equals(includeProcess)) {
            fasindex.setIncludeProcess(false);
        }
        return fasindex;
    }
}

