/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.enums.FAFDimensionTypeEnum;
import kd.macc.faf.fas.FAFIndexBusinessHelper;
import kd.macc.faf.fas.dto.FAFComparisonDTO;
import kd.macc.faf.fas.enums.FAFComparisonEnum;
import kd.macc.faf.fas.enums.FAFIndexCategoryEnum;
import kd.macc.faf.fas.index.FAFParseParamsUtil;
import kd.macc.faf.fas.index.model.FAFCompositeIndex;
import kd.macc.faf.fas.index.model.FAFDateProcess;
import kd.macc.faf.fas.index.model.FAFElementaryIndex;
import kd.macc.faf.fas.index.model.FAFIndex;
import kd.macc.faf.fas.index.model.FAFIndexModel;
import kd.macc.faf.fas.index.model.FAFVariable;

public class FAFIndexDynamicObject {
    private static final Log logger = LogFactory.getLog(FAFIndexDynamicObject.class);
    private final DynamicObject rootDy;
    private final Map<String, FAFIndex> elementaryIndexMap = new LinkedHashMap<String, FAFIndex>();
    private final Map<String, FAFIndex> allIndexMap = new LinkedHashMap<String, FAFIndex>();
    private DynamicObject dimPeriod;
    private boolean hasNecessityPeriod = true;
    private DynamicObject dimOrg;
    private boolean hasNecessityOrg = true;
    private final FAFDateProcess dateProcess = new FAFDateProcess();
    private Map<String, Map<Long, Long>> linkMap = null;
    private FAFComparisonDTO dto;
    private FAFIndex root;

    public static FAFIndexDynamicObject create(Object obj) {
        try {
            if (obj instanceof DynamicObject) {
                return new FAFIndexDynamicObject((DynamicObject)obj);
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"pa_fasindex");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)obj, (DynamicObjectType)dataEntityType);
            return new FAFIndexDynamicObject(dynamicObject);
        }
        catch (KDBizException ex) {
            logger.info("\u6784\u5efa\u6307\u6807\u53d1\u751f\u9519\u8bef", (Object)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.info("\u6784\u5efa\u6307\u6807\u53d1\u751f\u9519\u8bef", (Object)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u6784\u5efa\u6307\u6807\u53d1\u751f\u610f\u5916\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"FAFIndexDynamicObject_0", (String)"macc-faf-business", (Object[])new Object[0]));
        }
    }

    private void buildFASIndex() {
        this.toFASIndex(new HashSet<Object>(0), this.rootDy);
        this.root.setElementaryIndexMap(this.elementaryIndexMap);
        this.root.setAllIndexMap(this.allIndexMap);
    }

    private FAFIndexDynamicObject(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6307\u6807\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"FAFIndexDynamicObject_1", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        this.rootDy = dynamicObject;
        this.buildFASIndex();
    }

    private void checkCircularRefeerence(Set<Object> dependencyIndex, DynamicObject dy) {
        if (dependencyIndex.contains(dy.getPkValue())) {
            throw new KDBizException(new ErrorCode("pa.fas.fasindex.create.erro", ResManager.loadKDString((String)"\u590d\u5408\u6307\u6807\u201c%s\u201d\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\u3002", (String)"FAFIndexDynamicObject_2", (String)"macc-faf-business", (Object[])new Object[0])), new Object[]{dy.getString("name")});
        }
    }

    private void initCommon(DynamicObject dy, FAFIndex fasIndex) {
        fasIndex.setNumber(dy.getString("number"));
        fasIndex.setName(dy.getString("name"));
        fasIndex.setSystem((Object)dy.getDynamicObject("system"));
        Object precision = dy.get("precision");
        fasIndex.setPrecision((Integer)precision);
    }

    private FAFIndex toFASIndex(Set<Object> dependencyIndex, DynamicObject dy) {
        FAFIndex fasIndex;
        String category = dy.getString("category");
        if (FAFIndexCategoryEnum.COMPOSITE.eq((Object)category)) {
            fasIndex = this.createCompositeIndex(dependencyIndex, dy);
        } else {
            fasIndex = this.createElementaryIndex(dy);
            if (this.dto != null && this.dto.needComparison()) {
                fasIndex.setLinkMap(this.linkMap);
                fasIndex.setComparisonTypeList(this.dto.getComparionTypeList());
            }
            this.elementaryIndexMap.put(fasIndex.getOriginalIndexNumber(), fasIndex);
        }
        this.allIndexMap.put(fasIndex.getOriginalIndexNumber(), fasIndex);
        return fasIndex;
    }

    private List<String> createDefaultgrouper() {
        return this.getDefaultgrouper().stream().map(dynamicObject -> dynamicObject.getString("number")).collect(Collectors.toList());
    }

    public List<DynamicObject> getDefaultgrouper() {
        return Collections.emptyList();
    }

    public FAFIndex getRoot() {
        if (this.hasNecessityOrg) {
            this.root.setDimensionOrg(this.dimOrg);
        }
        if (this.hasNecessityPeriod) {
            this.root.setDimensionPeriod(this.dimPeriod);
        }
        return this.root;
    }

    private FAFIndex createElementaryIndex(DynamicObject dy) {
        FAFElementaryIndex fasIndex = new FAFElementaryIndex(this.root, dy.getPkValue());
        if (this.root == null) {
            this.root = fasIndex;
        }
        this.initCommon(dy, (FAFIndex)fasIndex);
        String filterCondition = dy.getString(FAFUtils.bigTextField((String)"dimensioncondition"));
        DynamicObject dynamicObject = (DynamicObject)FAFUtils.safeGet((DynamicObject)dy, (String)"model");
        if (StringUtils.isNotEmpty((CharSequence)filterCondition)) {
            List<QFilter> condition = FAFIndexBusinessHelper.getIndexModelQFilter(dynamicObject, filterCondition);
            fasIndex.setCondition(condition);
        }
        fasIndex.setAggregate(dy.getString("aggregate"));
        fasIndex.setAggmeasure(dy.getString("aggmeasure.number"));
        FAFIndexModel model = new FAFIndexModel();
        model.setNumber(dynamicObject.getString("number"));
        model.setName(dynamicObject.getString("name"));
        String tablenumber = dynamicObject.getString("tablenumber");
        if (StringUtils.isBlank((CharSequence)tablenumber)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u201c%s\u201d\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u672a\u521b\u5efa\u3002", (String)"FAFIndexDynamicObject_3", (String)"macc-faf-business", (Object[])new Object[0]), model.getName()));
        }
        model.setEntityname("pa_" + tablenumber);
        model.setTablename("t_pa_" + tablenumber);
        DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("dimension_entry");
        ArrayList<DynamicObject> dimensionList = new ArrayList<DynamicObject>();
        for (DynamicObject dyn : entry) {
            Object dimension_id = dyn.get("dimension_id");
            DynamicObject dimension = BusinessDataServiceHelper.loadSingleFromCache((Object)dimension_id, (String)"pa_dimension", (String)"number,name,dimensiontype,dimensionsource,typefield,group");
            String necessity = dyn.getString("necessity_dim");
            if (this.hasNecessityOrg && "0".equals(necessity)) {
                if (this.dimOrg == null) {
                    this.dimOrg = dimension;
                } else {
                    this.hasNecessityOrg = this.dimOrg.getPkValue().equals(dimension.getPkValue());
                }
            }
            if (this.hasNecessityPeriod && "1".equals(necessity)) {
                if (this.dimPeriod == null) {
                    this.dimPeriod = dimension;
                } else {
                    this.hasNecessityPeriod = this.dimPeriod.getPkValue().equals(dimension.getPkValue());
                }
            }
            dimensionList.add(dimension);
        }
        model.setDimensions(dimensionList);
        List condition = fasIndex.getCondition();
        ArrayList<QFilter> modelConditions = new ArrayList<QFilter>(condition.size() + 1);
        modelConditions.addAll(condition);
        modelConditions.add(new QFilter("collectstatus", "=", (Object)1L));
        model.setCondition(modelConditions);
        fasIndex.setModel(model);
        return fasIndex;
    }

    private FAFIndex createCompositeIndex(Set<Object> dependencyIndex, DynamicObject dy) {
        FAFCompositeIndex fasIndex = new FAFCompositeIndex(this.root, dy.getPkValue());
        if (this.root == null) {
            this.root = fasIndex;
        }
        fasIndex.setDependencyIndex(dependencyIndex);
        fasIndex.getDependencyIndex().add(dy.getPkValue());
        this.initCommon(dy, (FAFIndex)fasIndex);
        fasIndex.setIndexformula(dy.getString("indexformula"));
        List<FAFIndex> indexformulaargs = this.createIndexformulaargs(fasIndex.getDependencyIndex(), dy);
        fasIndex.setIndexformulaargs(indexformulaargs);
        return fasIndex;
    }

    private List<FAFIndex> createIndexformulaargs(Set<Object> dependencyIndex, DynamicObject dy) {
        DynamicObjectCollection dyc = dy.getDynamicObjectCollection("indexformulaargs");
        ArrayList<FAFIndex> list = new ArrayList<FAFIndex>(dyc.size());
        ArrayList<DynamicObject> dyList = new ArrayList<DynamicObject>(dyc.size());
        for (DynamicObject object : dyc) {
            MainEntityType dataEntityType;
            Object fbasedataid_id = object.get("fbasedataid_id");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)fbasedataid_id, (DynamicObjectType)(dataEntityType = EntityMetadataCache.getDataEntityType((String)"pa_fasindex")));
            if (dynamicObject == null) {
                throw new KDBizException(new ErrorCode("pa.fas.fasindex.create.erro", ResManager.loadKDString((String)"\u590d\u5408\u6307\u6807\u201c%s\u201d\u4f9d\u8d56\u7684\u6307\u6807\u4e0d\u5b58\u5728\u3002", (String)"FAFIndexDynamicObject_4", (String)"macc-faf-business", (Object[])new Object[0])), new Object[]{dy.getString("name")});
            }
            this.checkCircularRefeerence(dependencyIndex, dynamicObject);
            dyList.add(dynamicObject);
        }
        for (DynamicObject dynamicObject : dyList) {
            list.add(this.toFASIndex(dependencyIndex, dynamicObject));
        }
        return list;
    }

    public void checkPerm(Long useOrgId) throws KDBizException {
        Set dataids;
        if (useOrgId == null) {
            return;
        }
        Object value = BaseDataServiceHelper.getBaseDataIdInFilter((String)"pa_fasindex", (Long)useOrgId).getValue();
        if (value instanceof Set && (dataids = (Set)FAFUtils.cast((Object)value)).contains(this.rootDy.getPkValue())) {
            return;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6743\u8bbf\u95ee\u8be5\u6307\u6807,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FAFIndexDynamicObject_5", (String)"macc-faf-business", (Object[])new Object[0]));
    }

    public void checkEnable() throws KDBizException {
        if ("0".equals(this.rootDy.getString("enable"))) {
            Object name = FAFUtils.safeGet((DynamicObject)this.rootDy, (String)"name");
            Object number = FAFUtils.safeGet((DynamicObject)this.rootDy, (String)"number");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6307\u6807 %1$s(%2$s) \u5df2\u88ab\u7981\u7528\u3002", (String)"FAFIndexDynamicObject_6", (String)"macc-faf-business", (Object[])new Object[0]), name, number));
        }
    }

    private void parseParams(Map<Long, Object[]> params) {
        List grouperFields = this.root.getParamsGrouperFields();
        grouperFields.clear();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (params != null && params.size() > 0) {
            try {
                Object[] pkvalus = params.keySet().toArray();
                Map dimensionMap = BusinessDataServiceHelper.loadFromCache((Object[])pkvalus, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pa_dimension"));
                for (Object o2 : pkvalus) {
                    DynamicObject dimension = (DynamicObject)dimensionMap.get(o2);
                    grouperFields.add(dimension.getString("number"));
                }
                Set<Map.Entry<Long, Object[]>> entries = params.entrySet();
                qFilters = new ArrayList(entries.size());
                for (Map.Entry<Long, Object[]> entry : entries) {
                    DynamicObject dimension;
                    Class<?> primaryKeyType;
                    if (entry.getValue() == null || entry.getValue().length <= 0 || (primaryKeyType = FAFIndexBusinessHelper.getDimensionPrimaryKeyType(dimension = (DynamicObject)dimensionMap.get(entry.getKey()))) == Date.class) continue;
                    Object[] ids = entry.getValue();
                    Object[] objects = Arrays.stream(ids).map(o -> FAFIndexBusinessHelper.covertTypeTo(dimension.getString("name"), primaryKeyType, o)).toArray();
                    qFilters.add(new QFilter(dimension.getString("number"), "in", (Object)objects));
                }
            }
            catch (KDBizException ex) {
                throw ex;
            }
            catch (Exception ex) {
                logger.warn("index invalid params 001", (Throwable)ex);
                throw new KDBizException(new ErrorCode("invalid params", ResManager.loadKDString((String)"\u5165\u53c2\u9519\u8bef\u3002", (String)"FAFIndexDynamicObject_7", (String)"macc-faf-business", (Object[])new Object[0])), new Object[0]);
            }
        } else {
            grouperFields.addAll(this.createDefaultgrouper());
        }
        this.root.getParamsQFilters().clear();
        this.root.getParamsQFilters().addAll(qFilters);
    }

    private void fillRoot() {
        if (this.hasNecessityOrg) {
            this.root.setDimensionOrg(this.dimOrg);
        }
        if (this.hasNecessityPeriod) {
            this.root.setDimensionPeriod(this.dimPeriod);
        }
        this.dateProcess.setNeedProcess(true);
        this.root.setDateProcess(this.dateProcess);
    }

    private void fillComparisonParams(Map<Long, Object[]> params, FAFComparisonDTO dto) {
        this.dto = dto;
        if (dto != null && dto.needComparison()) {
            if (!this.hasNecessityPeriod || this.dimPeriod == null || params == null) {
                throw new KDBizException(new ErrorCode("invalid params", ResManager.loadKDString((String)"\u5f53\u524d\u6307\u6807\u53c2\u4e0e\u8ba1\u7b97\u7684\u5206\u6790\u6a21\u578b\u5fc5\u8981\u7ef4\u5ea6\"\u4f1a\u8ba1\u671f\u95f4\"\u4e0d\u540c,\u65e0\u6cd5\u8ba1\u7b97\u540c\u6bd4/\u73af\u6bd4\u3002", (String)"FAFIndexDynamicObject_8", (String)"macc-faf-business", (Object[])new Object[0])), new Object[0]);
            }
            if (FAFDimensionTypeEnum.DATE.eqScene(this.dimPeriod)) {
                throw new KDBizException(new ErrorCode("invalid params", ResManager.loadKDString((String)"\u5fc5\u8981\u7ef4\u5ea6\"\u671f\u95f4/\u65f6\u95f4\",\u4e3a\u65e5\u671f\u7c7b\u578b\u65f6\u4e0d\u80fd\u8ba1\u7b97\u540c\u6bd4/\u73af\u6bd4\u3002", (String)"FAFIndexDynamicObject_9", (String)"macc-faf-business", (Object[])new Object[0])), new Object[0]);
            }
            Object[] objects = params.get(this.dimPeriod.getLong("id"));
            if (objects == null || objects.length <= 0) {
                throw new KDBizException(new ErrorCode("invalid params", ResManager.loadKDString((String)"\u8ba1\u7b97\u540c\u6bd4/\u73af\u6bd4,\u5fc5\u987b\u9650\u5b9a\"%s\"\u7684\u503c\u3002", (String)"FAFIndexDynamicObject_10", (String)"macc-faf-business", (Object[])new Object[0])), new Object[]{this.dimPeriod.getString("name")});
            }
            Object[] ids = Arrays.stream(objects).map(o -> FAFIndexBusinessHelper.covertTypeTo(this.dimPeriod.getString("name"), Long.class, o)).toArray();
            this.linkMap = dto.loadLinkMap(this.dimPeriod, ids);
            this.root.setComparisonTypeList(dto.getComparionTypeList());
            this.root.setLinkMap(this.linkMap);
        }
    }

    public FAFIndex calculateMix(Map<String, Object> mixParams, String comparisontype) {
        logger.info("call calculateMix => mixParams: {}", (Object)SerializationUtils.toJsonString(mixParams));
        this.root.setRequestSource(String.valueOf(mixParams.getOrDefault("requestSource", "test")));
        Map params = (Map)FAFUtils.cast((Object)mixParams.get("params"));
        FAFIndex fasIndex = this.calculate((Map<Long, Object[]>)params, FAFComparisonDTO.quickCreate((String)comparisontype));
        List matchs = (List)FAFUtils.cast((Object)mixParams.get("matchs"));
        if (matchs != null) {
            for (Map match : matchs) {
                Long dimensionPkvalue = (Long)match.get("dimensionid");
                if (this.dimOrg != null && dimensionPkvalue.equals(this.dimOrg.getPkValue())) {
                    if ("qing".equals(this.root.getRequestSource())) {
                        Object variable = match.get("variable");
                        fasIndex.getVariableList().add(new FAFVariable(fasIndex.getOrgNumber(), variable));
                        continue;
                    }
                    QFilter qFilter = FAFParseParamsUtil.createQFilter(this.dimOrg, match);
                    if (qFilter == null) continue;
                    fasIndex.getParamsQFilters().add(qFilter);
                    continue;
                }
                DynamicObject paDimension = BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionPkvalue, (String)"pa_dimension");
                if (paDimension != null && FAFDimensionTypeEnum.DATE.eqScene(paDimension)) {
                    QFilter qFilter = FAFParseParamsUtil.createQFilter(paDimension, match);
                    if (qFilter == null) continue;
                    fasIndex.getParamsQFilters().add(qFilter);
                    continue;
                }
                if (paDimension != null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%s\u201d\u5165\u53c2\u9519\u8bef\u3002", (String)"FAFIndexDynamicObject_11", (String)"macc-faf-business", (Object[])new Object[0]), FAFUtils.safeGet((DynamicObject)paDimension, (String)"name").toString()));
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5165\u53c2\u4e2d\u6709\u4e0d\u5b58\u5728\u7684\u7ef4\u5ea6\u3002", (String)"FAFIndexDynamicObject_12", (String)"macc-faf-business", (Object[])new Object[0]));
            }
        }
        fasIndex.setMixParams(mixParams);
        return fasIndex;
    }

    @Deprecated
    public FAFIndex calculate(Map<Long, Object[]> params) {
        return this.calculate(params, FAFComparisonDTO.quickCreate((String)FAFComparisonEnum.C_00.getCode()));
    }

    public FAFIndex calculate(Map<Long, Object[]> params, String comparisontype) {
        return this.calculate(params, FAFComparisonDTO.quickCreate((String)comparisontype));
    }

    public FAFIndex calculate(Map<Long, Object[]> params, Map<String, Object> comparison) {
        return this.calculate(params, FAFComparisonDTO.create(comparison));
    }

    @Deprecated
    public FAFIndex calculate(Map<Long, Object[]> params, FAFComparisonDTO dto) {
        logger.info("call calculate => params: {} FASComparisonDTO: {}", (Object)SerializationUtils.toJsonString(params), (Object)dto.getComparionTypeList());
        this.parseParams(params);
        this.fillRoot();
        this.fillComparisonParams(params, dto);
        this.root.getMixParams().put("params", params);
        return this.root;
    }
}

