/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.schedule;

import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.macc.faf.fas.FAFIndexBusinessHelper;
import kd.macc.faf.fas.index.model.FAFIndex;
import kd.macc.faf.fas.service.factory.FAFIndexServiceFactory;

public class FASQingCacheScheduleTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(FASQingCacheScheduleTask.class);
    private static final String ALGO_KEY = FASQingCacheScheduleTask.class.getName();
    private static final Object[] DEFAULT_VALUE_OBJ = new Object[]{null, null};
    private static final String APP_ID = "pa";
    private static final String APP_ID2 = "faf";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info(String.format("[MACC-FAF] QingCache ScheduleTask execute success! map:%s", map));
        this.processQingPlan();
    }

    public void processQingPlan() {
        try (DataSet sourceDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DBRoute.of((String)"sys"), (String)"select ffilter from t_qing_bill");
             DataSet parseDataSet = sourceDataSet.map(new MapFunction(){
            private static final long serialVersionUID = 5719531984418856508L;

            public Object[] map(Row row) {
                try {
                    Object filterObj = row.get(0);
                    if (filterObj == null) {
                        return DEFAULT_VALUE_OBJ;
                    }
                    String filterJson = new String((byte[])filterObj);
                    Map filterMap = (Map)SerializationUtils.fromJsonString((String)filterJson, Map.class);
                    if (filterMap == null || filterMap.isEmpty()) {
                        return DEFAULT_VALUE_OBJ;
                    }
                    Map customParams = (Map)filterMap.get("CustomParams");
                    if (customParams == null || customParams.isEmpty()) {
                        return DEFAULT_VALUE_OBJ;
                    }
                    String appId = (String)filterMap.get("AppId");
                    String queryParam = (String)customParams.get("queryParam");
                    return new Object[]{appId, queryParam};
                }
                catch (Exception e) {
                    logger.error("[MACC-FAF] QingCache ScheduleTask parse error!", (Throwable)e);
                    return DEFAULT_VALUE_OBJ;
                }
            }

            public RowMeta getResultRowMeta() {
                Field appIdField = new Field("appId", (DataType)DataType.StringType);
                Field queryParamField = new Field("queryParam", (DataType)DataType.StringType);
                return new RowMeta(new Field[]{appIdField, queryParamField});
            }
        }).filter(new FilterFunction(){
            private static final long serialVersionUID = 7554547707989614767L;

            public boolean test(Row row) {
                String appId = row.getString(0);
                String queryParam = row.getString(1);
                if (StringUtils.isEmpty((CharSequence)appId) || StringUtils.isEmpty((CharSequence)queryParam)) {
                    return false;
                }
                return StringUtils.equals((CharSequence)FASQingCacheScheduleTask.APP_ID, (CharSequence)appId) || StringUtils.equals((CharSequence)FASQingCacheScheduleTask.APP_ID2, (CharSequence)appId);
            }
        });
             DataSet resultDataSet = parseDataSet.distinct();){
            logger.info(String.format("[MACC-FAF] QingCache ScheduleTask indexExecute begin! time:%s", System.currentTimeMillis()));
            for (Row row : resultDataSet) {
                try {
                    String queryParam = row.getString("queryParam");
                    ReportQueryParam reportQueryParam = (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)queryParam);
                    FAFIndex fasIndex = FAFIndexBusinessHelper.buildFasIndex(reportQueryParam);
                    FAFIndexServiceFactory.getCalculateService().commit(fasIndex, 20);
                    logger.info(String.format("[MACC-FAF] QingCache ScheduleTask indexExecute success! fasIndex:%s", fasIndex));
                }
                catch (Exception e) {
                    logger.info("[MACC-FAF] QingCache ScheduleTask indexExecute error!", (Object)e);
                }
            }
            logger.info(String.format("[MACC-FAF] QingCache ScheduleTask indexExecute end! time:%s", System.currentTimeMillis()));
        }
    }
}

