/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.service;

import java.util.Map;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.macc.faf.fas.index.IComparison;
import kd.macc.faf.fas.index.func.FAFIdToNameMapFunction;
import kd.macc.faf.fas.index.func.algo.FAFAdapterAlgoMapFunction;
import kd.macc.faf.fas.index.model.FAFIndex;
import kd.macc.faf.fas.service.FAFCalcBaseService;

public abstract class FAFAlgoBaseService
extends FAFCalcBaseService {
    public abstract DataSet calculate(IComparison var1);

    @Override
    protected Map<String, Object> execute(FAFIndex fasIndex, int timeout) {
        try {
            DataSet dataSet = this.removeLinkRow(this.calculate((IComparison)fasIndex));
            if (dataSet == null) {
                return null;
            }
            if ("qing".equals(fasIndex.getRequestSource())) {
                Map<String, Map<Object, String>> namesMap = this.loadDimensionNames(dataSet, fasIndex);
                dataSet = dataSet.map((MapFunction)new FAFAdapterAlgoMapFunction((kd.bos.algox.MapFunction)new FAFIdToNameMapFunction(dataSet.getRowMeta(), fasIndex.getOrgNumber(), namesMap)));
            }
            CachedDataSet cache = dataSet.cache(this.getCacheHint(fasIndex));
            return this.buildResult(fasIndex, cache.getRowMeta(), cache.getCacheId());
        }
        catch (Exception ex) {
            logger.info("calculate index erro", (Object)ex);
            throw new KDBizException(new ErrorCode("pa.fas.algo.cal.algo", ex.getMessage()), new Object[0]);
        }
    }

    protected DataSet removeLinkRow(DataSet result) {
        if (result != null && result.getRowMeta().getField("_link", false) != null) {
            return result.removeFields(new String[]{"_link"});
        }
        return result;
    }

    protected DataSet addLinkRow(DataSet result) {
        String[] fieldNames = result.getRowMeta().getFieldNames();
        if (fieldNames.length == 1) {
            return result.addFields(new String[]{"1"}, new String[]{"_link"}).select(new String[]{"_link", fieldNames[0]});
        }
        return result;
    }
}

