/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.service;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Output;
import kd.bos.algo.output.DataSetCacheOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RunningTimeoutException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.macc.faf.fas.index.IComparison;
import kd.macc.faf.fas.index.func.FAFIdToNameMapFunction;
import kd.macc.faf.fas.index.model.FAFIndex;
import kd.macc.faf.fas.service.FAFCalcBaseService;

public abstract class FAFAlgoxBaseService
extends FAFCalcBaseService {
    protected final JobSession session = AlgoX.createSession((String)"pa.fas.calculate.index", (String)ResManager.loadKDString((String)"\u6307\u6807\u7ba1\u7406.\u8ba1\u7b97\u4efb\u52a1", (String)"FAFAlgoxBaseService_0", (String)"macc-faf-business", (Object[])new Object[0]));

    public abstract DataSetX calculate(IComparison var1);

    @Override
    protected Map<String, Object> execute(FAFIndex fasIndex, int timeout) {
        try {
            DataSetX dataSetX = this.removeLinkRow(this.calculate((IComparison)fasIndex));
            if (dataSetX == null) {
                return null;
            }
            if ("qing".equals(fasIndex.getRequestSource())) {
                Map<String, Map<Object, String>> namesMap = this.loadDimensionNames(fasIndex);
                dataSetX = dataSetX.map((MapFunction)new FAFIdToNameMapFunction(dataSetX.getRowMeta(), fasIndex.getOrgNumber(), namesMap));
            }
            DataSetCacheOutput dataSetCacheOutput = new DataSetCacheOutput(dataSetX.getRowMeta(), this.getCacheHint(fasIndex));
            dataSetX.output((Output)dataSetCacheOutput);
            this.session.commit(timeout, TimeUnit.SECONDS);
            return this.buildResult(fasIndex, dataSetX.getRowMeta(), dataSetCacheOutput.getId());
        }
        catch (RunningTimeoutException rex) {
            throw new KDBizException(new ErrorCode("pa.fas.algox.cal.timeout", String.format(ResManager.loadKDString((String)"\u6267\u884c\u672c\u6b21\u8ba1\u7b97\u4efb\u52a1\u8d85\u65f6,\u9650\u65f6( %s s)", (String)"FAFAlgoxBaseService_1", (String)"macc-faf-business", (Object[])new Object[0]), timeout)), new Object[0]);
        }
        catch (Exception ex) {
            logger.info("calculate index erro", (Object)ex);
            throw new KDBizException(new ErrorCode("pa.fas.algox.cal.algo", ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage()), new Object[0]);
        }
    }

    protected DataSetX removeLinkRow(DataSetX result) {
        if (result != null && result.getRowMeta().getField("_link", false) != null) {
            return result.removeFields(new String[]{"_link"});
        }
        return result;
    }

    protected DataSetX addLinkRow(DataSetX result) {
        String[] fieldNames = result.getRowMeta().getFieldNames();
        if (fieldNames.length == 1) {
            return result.addFields(new Field[]{new Field("_link", (DataType)DataType.IntegerType)}, new Object[]{1}).select(new String[]{"_link", fieldNames[0]});
        }
        return result;
    }
}

