/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.service;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CacheHint;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.NoSuchPropertyException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.fas.FAFIndexBusinessHelper;
import kd.macc.faf.fas.dto.FAFComparisonDTO;
import kd.macc.faf.fas.index.FAFIndexDynamicObject;
import kd.macc.faf.fas.index.IProcess;
import kd.macc.faf.fas.index.model.FAFIndex;
import kd.macc.faf.fas.service.ICalculateService;
import kd.macc.faf.fas.service.helper.FAFCalcCacheServiceHelper;

public abstract class FAFCalcBaseService
implements ICalculateService {
    protected static final Log logger = LogFactory.getLog(FAFCalcBaseService.class);
    protected static final String _link = "_link";

    protected abstract Map<String, Object> execute(FAFIndex var1, int var2);

    @Override
    public Map<String, Object> commit(Long pkValue, Long useOrgId, Map<Long, Object[]> params, Map<String, Object> comparison) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"pa_fasindex");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (DynamicObjectType)dataEntityType);
        FAFIndexDynamicObject fObject = FAFIndexDynamicObject.create(dynamicObject);
        fObject.checkEnable();
        fObject.checkPerm(useOrgId);
        FAFIndex fasIndex = fObject.calculate(params, comparison);
        fasIndex.setRequestSource("service");
        fasIndex.setIncludeProcess(false);
        fasIndex.setMicroservice(true);
        Map<String, Object> commit = this.commit(fasIndex);
        commit.put("comparisonMap", FAFUtils.convert((Map)fasIndex.getLinkMap()));
        return commit;
    }

    @Override
    public Map<String, Object> commitMix(Long pkValue, Long useOrgId, Map<String, Object> mixParams) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"pa_fasindex");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (DynamicObjectType)dataEntityType);
        FAFIndexDynamicObject fObject = FAFIndexDynamicObject.create(dynamicObject);
        fObject.checkEnable();
        fObject.checkPerm(useOrgId);
        FAFIndex fasIndex = fObject.calculateMix(mixParams, FAFComparisonDTO.parseComparisonType(mixParams));
        fasIndex.setRequestSource("service");
        fasIndex.setIncludeProcess(false);
        fasIndex.setMicroservice(true);
        Map<String, Object> commit = this.commit(fasIndex);
        commit.put("comparisonMap", FAFUtils.convert((Map)fasIndex.getLinkMap()));
        return commit;
    }

    @Override
    public Map<String, Object> commit(FAFIndex fasIndex) {
        return this.commit(fasIndex, 600);
    }

    @Override
    public Map<String, Object> commit(FAFIndex fasIndex, int timeout) {
        LocalDateTime startTime = LocalDateTime.now();
        logger.info("start: {} execute : {}", (Object)startTime, (Object)fasIndex.toString());
        Map<String, Object> result = this.excuteFromCache(fasIndex, timeout);
        LocalDateTime endTime = LocalDateTime.now();
        logger.info("end: {} \u8017\u65f6(\u6beb\u79d2): {}", (Object)endTime, (Object)Duration.between(startTime, endTime).toMillis());
        return result;
    }

    protected CacheHint getCacheHint(FAFIndex fasIndex) {
        CacheHint cacheHint = CacheHint.getDefault();
        if (FAFCalcCacheServiceHelper.isCacheCalc(fasIndex)) {
            cacheHint.setTimeout((long)(FAFCalcCacheServiceHelper.todayRemainMillis() + 600000), TimeUnit.MILLISECONDS);
        } else {
            cacheHint.setTimeout(600000L, TimeUnit.MILLISECONDS);
        }
        return cacheHint;
    }

    private Map<String, Object> excuteFromCache(FAFIndex fasIndex, int timeout) {
        if (FAFCalcCacheServiceHelper.isCacheCalc(fasIndex)) {
            Map<String, Object> cache = FAFCalcCacheServiceHelper.loadCache(fasIndex);
            if (cache == null) {
                cache = this.execute(fasIndex, timeout);
                FAFCalcCacheServiceHelper.saveCache(fasIndex, cache);
            }
            return cache;
        }
        FAFCalcCacheServiceHelper.clearCache(fasIndex);
        return this.execute(fasIndex, timeout);
    }

    protected String[] getGrouper(IProcess process) {
        String[] grouper = process.grouper();
        if (grouper.length == 0) {
            grouper = new String[]{_link};
        }
        return grouper;
    }

    protected Map<String, Object> buildResult(FAFIndex fasIndex, RowMeta rowMeta, String cacheId) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(2);
        result.put("rowMeta", rowMeta);
        result.put("cacheId", cacheId);
        result.put("cacheKey", FAFCalcCacheServiceHelper.getCacheKey(fasIndex));
        return result;
    }

    protected boolean containDateField(RowMeta rowMeta) {
        Field[] fields;
        for (Field field : fields = rowMeta.getFields()) {
            if (!field.getDataType().equals((Object)DataType.TimestampType) && !field.getDataType().equals((Object)DataType.DateType)) continue;
            return true;
        }
        return false;
    }

    protected Map<String, Map<Object, String>> loadDimensionNames(DataSet dsResult, FAFIndex fasIndex) {
        try {
            HashMap<String, Map<Object, String>> result = new HashMap<String, Map<Object, String>>();
            Map mixParams = fasIndex.getMixParams();
            Map params = (Map)FAFUtils.cast(mixParams.get("params"));
            if (params != null && params.size() > 0) {
                Object[] pkvalus = params.keySet().toArray();
                Map dimensionMap = BusinessDataServiceHelper.loadFromCache((Object[])pkvalus, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pa_dimension"));
                Map<String, Map<Object, String>> enumDimMap = FAFIndexBusinessHelper.getEnumDimMap(dimensionMap);
                result.putAll(enumDimMap);
                Set entries = params.entrySet();
                for (Map.Entry entry : entries) {
                    DynamicObject dimension = (DynamicObject)dimensionMap.get(entry.getKey());
                    String basedata = FAFIndexBusinessHelper.getBasedataByDimension(dimension);
                    if (basedata == null) continue;
                    String number = dimension.getString("number");
                    Set<Object> ids = this.load(dsResult, number);
                    QFilter qFilter = new QFilter("id", "in", ids);
                    DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FASAlgoxBaseService_loadnames", (String)basedata, (String)"id,name", (QFilter[])qFilter.toArray(), null);
                    Throwable throwable = null;
                    try {
                        Map<Object, String> collect = StreamSupport.stream(Spliterators.spliteratorUnknownSize(dataSet, 16), false).collect(Collectors.toMap(row -> row.get("id"), row -> row.getString("name"), (o1, o2) -> o1));
                        result.put(dimension.getString("number"), collect);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dataSet == null) continue;
                        if (throwable != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        dataSet.close();
                    }
                }
            }
            return result;
        }
        catch (KDException | NoSuchPropertyException ex) {
            throw ex;
        }
        catch (AlgoException ex) {
            logger.warn("index algo exception", (Throwable)ex);
            throw new KDBizException(new ErrorCode("algo exception", ex.getMessage()), new Object[0]);
        }
        catch (Exception ex) {
            logger.warn("index invalid params 003", (Throwable)ex);
            throw new KDBizException(new ErrorCode("invalid params", ResManager.loadKDString((String)"\u52a0\u8f7d\u7ef4\u5ea6\u540d\u79f0\u5c5e\u6027\u53d1\u751f\u9519\u8bef\u3002", (String)"FAFCalcBaseService_0", (String)"macc-faf-business", (Object[])new Object[0])), new Object[0]);
        }
    }

    private Set<Object> load(DataSet dataSet, String number) {
        try (DataSet ds = dataSet.copy().groupBy(new String[]{number}).finish();){
            HashSet<Object> set = new HashSet<Object>();
            for (Row d : ds) {
                set.add(d.get(0));
                if (set.size() <= 48000) continue;
                HashSet<Object> hashSet = set;
                return hashSet;
            }
            HashSet<Object> hashSet = set;
            return hashSet;
        }
    }

    protected Map<String, Map<Object, String>> loadDimensionNames(FAFIndex fasIndex) {
        try {
            HashMap<String, Map<Object, String>> result = new HashMap<String, Map<Object, String>>();
            Map mixParams = fasIndex.getMixParams();
            Map params = (Map)FAFUtils.cast(mixParams.get("params"));
            if (params != null && params.size() > 0) {
                Object[] pkvalus = params.keySet().toArray();
                Map dimensionMap = BusinessDataServiceHelper.loadFromCache((Object[])pkvalus, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pa_dimension"));
                Map<String, Map<Object, String>> enumDimMap = FAFIndexBusinessHelper.getEnumDimMap(dimensionMap);
                result.putAll(enumDimMap);
                Set entries = params.entrySet();
                for (Map.Entry entry : entries) {
                    DynamicObject dimension = (DynamicObject)dimensionMap.get(entry.getKey());
                    String basedata = FAFIndexBusinessHelper.getBasedataByDimension(dimension);
                    if (basedata == null) continue;
                    QFilter qFilter = null;
                    if ("bos_org".equals(basedata)) {
                        List allOrg = OrgUnitServiceHelper.getAllOrg((String)"15");
                        qFilter = new QFilter("id", "in", (Object)allOrg);
                    }
                    DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FASAlgoxBaseService_loadnames", (String)basedata, (String)"id,name", (QFilter[])(qFilter == null ? null : qFilter.toArray()), null, (int)49999);
                    Throwable throwable = null;
                    try {
                        Map<Object, String> collect = StreamSupport.stream(Spliterators.spliteratorUnknownSize(dataSet, 16), false).collect(Collectors.toMap(row -> row.get("id"), row -> row.getString("name"), (o1, o2) -> o1));
                        result.put(dimension.getString("number"), collect);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dataSet == null) continue;
                        if (throwable != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        dataSet.close();
                    }
                }
            }
            return result;
        }
        catch (KDException | NoSuchPropertyException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.warn("index invalid params 004", (Throwable)ex);
            throw new KDBizException(new ErrorCode("invalid params", ResManager.loadKDString((String)"\u52a0\u8f7d\u7ef4\u5ea6\u540d\u79f0\u5c5e\u6027\u53d1\u751f\u9519\u8bef\u3002", (String)"FAFCalcBaseService_0", (String)"macc-faf-business", (Object[])new Object[0])), new Object[0]);
        }
    }
}

