/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.service.helper;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.common.FAFSystemParamHelper;
import kd.macc.faf.fas.index.model.FAFIndex;

public class FAFCalcCacheServiceHelper {
    protected static final Log logger = LogFactory.getLog(FAFCalcCacheServiceHelper.class);
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("pa_fas_region");

    public static String getCacheKey(FAFIndex fasIndex) {
        return fasIndex.getRequestSource() + fasIndex.getPkValue() + fasIndex.getParamsKey();
    }

    public static boolean isCacheCalc(FAFIndex fasIndex) {
        if (FAFSystemParamHelper.useCalcCache().booleanValue() && !"service".equals(fasIndex.getRequestSource())) {
            return fasIndex.getParamsQFilters().size() == 0;
        }
        return false;
    }

    public static int todayRemainMillis() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime tomorrow = now.plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
        long millis = Duration.between(now, tomorrow).toMillis();
        return (int)millis;
    }

    public static Map<String, Object> loadCache(FAFIndex fasIndex) {
        String key = FAFCalcCacheServiceHelper.getCacheKey(fasIndex);
        String result = (String)cache.get(key);
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)result);
        }
        return null;
    }

    public static void saveCache(FAFIndex fasIndex, Map<String, Object> result) {
        cache.put(FAFCalcCacheServiceHelper.getCacheKey(fasIndex), (Object)SerializationUtils.serializeToBase64(result), FAFCalcCacheServiceHelper.todayRemainMillis(), TimeUnit.MILLISECONDS);
    }

    public static void clearCache(FAFIndex fasIndex) {
        FAFCalcCacheServiceHelper.clearCache("qing" + fasIndex.getPkValue() + fasIndex.getParamsKey());
        FAFCalcCacheServiceHelper.clearCache("test" + fasIndex.getPkValue() + fasIndex.getParamsKey());
    }

    public static void clearCache(String cacheKey) {
        String result = (String)cache.get(cacheKey);
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            Map map = (Map)SerializationUtils.deSerializeFromBase64((String)result);
            cache.remove(cacheKey);
            Algo.removeCacheDataSet((String)String.valueOf(map.get("cacheId")));
        }
    }
}

