/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.service.impl;

import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.macc.faf.fas.enums.FAFComparisonMetaEnum;
import kd.macc.faf.fas.enums.FAFIndexAggregateEnum;
import kd.macc.faf.fas.index.IAggregateProcess;
import kd.macc.faf.fas.index.IComparison;
import kd.macc.faf.fas.index.IFormulaProcess;
import kd.macc.faf.fas.index.IProcess;
import kd.macc.faf.fas.index.func.FAFComparisonMapFunction;
import kd.macc.faf.fas.index.func.FAFCompositeIndexFormulaCalcMapFunction;
import kd.macc.faf.fas.index.func.FAFDateTimeToDateMapFunction;
import kd.macc.faf.fas.index.func.FAFJoinFunction;
import kd.macc.faf.fas.index.func.FAFOffsetMapFunction;
import kd.macc.faf.fas.index.func.algo.FAFAdapterAlgoFullJoin;
import kd.macc.faf.fas.index.func.algo.FAFAdapterAlgoFullJoinMapFunction;
import kd.macc.faf.fas.index.func.algo.FAFAdapterAlgoMapFunction;
import kd.macc.faf.fas.index.model.FAFDateProcess;
import kd.macc.faf.fas.service.FAFAlgoBaseService;

public class FAFIndexAlgoCalculateServiceImpl
extends FAFAlgoBaseService {
    @Override
    public DataSet calculate(IComparison comparison) {
        DataSet result = this.calculate((IProcess)comparison, FAFComparisonMetaEnum.NONE);
        if (comparison.needComparison() && result != null) {
            String[] grouper = this.getGrouper((IProcess)comparison);
            List metaList = comparison.getComparisonMetaList();
            if (metaList.size() > 0) {
                for (String cmetaCode : metaList) {
                    FAFComparisonMetaEnum cmeta = FAFComparisonMetaEnum.getEnum((String)cmetaCode);
                    DataSet right = this.calculate((IProcess)comparison, cmeta);
                    if (right == null) continue;
                    right = right.map((MapFunction)new FAFAdapterAlgoMapFunction((kd.bos.algox.MapFunction)new FAFOffsetMapFunction(right.getRowMeta(), comparison.getPeriodFieldName(), (Map)comparison.getLinkMap().get(cmetaCode))));
                    JoinDataSet joinDataSet = result.leftJoin(right);
                    for (String group : grouper) {
                        joinDataSet = joinDataSet.on(group, group);
                    }
                    FAFJoinFunction func = new FAFJoinFunction(result.getRowMeta(), right.getRowMeta(), grouper);
                    result = joinDataSet.select(func.getResultRowMeta().getFieldNames()).finish();
                }
                result = result.map((MapFunction)new FAFAdapterAlgoMapFunction((kd.bos.algox.MapFunction)new FAFComparisonMapFunction(result.getRowMeta(), comparison)));
            }
        }
        return result;
    }

    private DataSet calculate(IProcess process, FAFComparisonMetaEnum cmeta) {
        if (process instanceof IAggregateProcess) {
            return this.calculateAggregate((IAggregateProcess)process, cmeta);
        }
        if (process instanceof IFormulaProcess) {
            return this.calculateFormula((IFormulaProcess)process, cmeta);
        }
        throw new KDBizException(new ErrorCode("pa.fas.algox.cal", "be unable to handle this type index"), new Object[0]);
    }

    private DataSet calculateAggregate(IAggregateProcess process, FAFComparisonMetaEnum cmeta) {
        DataSet result;
        OrmInput input;
        OrmInput ormInput = input = cmeta.eq((Object)FAFComparisonMetaEnum.NONE) ? process.getOrmInput() : process.getOffsetOrmInput(cmeta.getCode());
        if (input == null) {
            return null;
        }
        DataSet dataSet = Algo.create((String)"pa.fas.calculate.index").createDataSet(new Input[]{input});
        FAFDateProcess dateProcess = process.getDateProcess();
        if (dateProcess.needProcess() && this.containDateField(dataSet.getRowMeta())) {
            dataSet = dataSet.map((MapFunction)new FAFAdapterAlgoMapFunction((kd.bos.algox.MapFunction)new FAFDateTimeToDateMapFunction(dataSet.getRowMeta(), dateProcess)));
        }
        String fieldName = process.getFieldName(cmeta.getPrefix());
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(process.grouper());
        String aggregate = process.getAggregate();
        if (FAFIndexAggregateEnum.SUM.eq((Object)aggregate)) {
            result = groupbyDataSet.sum(process.getAggmeasure(), fieldName).finish();
        } else if (FAFIndexAggregateEnum.COUNT.eq((Object)aggregate)) {
            result = groupbyDataSet.count(fieldName).finish();
        } else if (FAFIndexAggregateEnum.AVERAGE.eq((Object)aggregate)) {
            result = groupbyDataSet.avg(process.getAggmeasure(), fieldName).finish();
        } else if (FAFIndexAggregateEnum.MAX.eq((Object)aggregate)) {
            result = groupbyDataSet.max(process.getAggmeasure(), fieldName).finish();
        } else if (FAFIndexAggregateEnum.MIN.eq((Object)aggregate)) {
            result = groupbyDataSet.min(process.getAggmeasure(), fieldName).finish();
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u5904\u7406\u7684\u805a\u5408\u65b9\u5f0f: %s", (String)"FAFIndexAlgoCalculateServiceImpl_0", (String)"macc-faf-business", (Object[])new Object[0]), aggregate));
        }
        return this.addLinkRow(result);
    }

    private DataSet calculateFormula(IFormulaProcess process, FAFComparisonMetaEnum cmeta) {
        List list = process.getAllAggregateProcess();
        DataSet result = null;
        String[] grouper = this.getGrouper((IProcess)process);
        if (list.size() > 0) {
            DataSet left = this.calculateAggregate((IAggregateProcess)list.get(0), cmeta);
            if (left != null && list.size() > 1) {
                for (int i = 1; i < list.size(); ++i) {
                    DataSet right = this.calculateAggregate((IAggregateProcess)list.get(i), cmeta);
                    if (right == null) continue;
                    JoinDataSet joinDataSet = left.fullJoin(right);
                    for (String group : grouper) {
                        joinDataSet = joinDataSet.on(group, group);
                    }
                    FAFAdapterAlgoFullJoin join = new FAFAdapterAlgoFullJoin(left.getRowMeta(), right.getRowMeta(), grouper);
                    left = joinDataSet.select(join.getLeftSelect(), join.getRightSelect()).finish().map((MapFunction)new FAFAdapterAlgoFullJoinMapFunction(join));
                }
            }
            if (left != null) {
                result = left.map((MapFunction)new FAFAdapterAlgoMapFunction((kd.bos.algox.MapFunction)new FAFCompositeIndexFormulaCalcMapFunction(left.getRowMeta(), process, grouper, cmeta)));
            }
        }
        return result;
    }
}

