/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.service.impl;

import java.util.List;
import java.util.Map;
import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.Grouper;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.JoinFunction;
import kd.bos.algox.MapFunction;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.macc.faf.fas.enums.FAFComparisonMetaEnum;
import kd.macc.faf.fas.enums.FAFIndexAggregateEnum;
import kd.macc.faf.fas.index.IAggregateProcess;
import kd.macc.faf.fas.index.IComparison;
import kd.macc.faf.fas.index.IFormulaProcess;
import kd.macc.faf.fas.index.IProcess;
import kd.macc.faf.fas.index.func.FAFAvgReduceFunction;
import kd.macc.faf.fas.index.func.FAFComparisonMapFunction;
import kd.macc.faf.fas.index.func.FAFCompositeIndexFormulaCalcMapFunction;
import kd.macc.faf.fas.index.func.FAFDateTimeToDateMapFunction;
import kd.macc.faf.fas.index.func.FAFJoinFunction;
import kd.macc.faf.fas.index.func.FAFOffsetMapFunction;
import kd.macc.faf.fas.index.model.FAFDateProcess;
import kd.macc.faf.fas.index.model.FAFIndex;
import kd.macc.faf.fas.service.FAFAlgoxBaseService;

public class FAFIndexAlgoxCalculateServiceImpl
extends FAFAlgoxBaseService {
    @Deprecated
    public DataSetX createAlgoXFlow(FAFIndex fasIndex) {
        DataSetX result = this.calculate((IComparison)fasIndex);
        return this.removeLinkRow(result);
    }

    @Override
    public DataSetX calculate(IComparison comparison) {
        DataSetX result = this.calculate((IProcess)comparison, FAFComparisonMetaEnum.NONE);
        if (comparison.needComparison() && result != null) {
            String[] grouper = this.getGrouper((IProcess)comparison);
            List metaList = comparison.getComparisonMetaList();
            if (metaList.size() > 0) {
                for (String cmetaCode : metaList) {
                    FAFComparisonMetaEnum cmeta = FAFComparisonMetaEnum.getEnum((String)cmetaCode);
                    DataSetX right = this.calculate((IProcess)comparison, cmeta);
                    if (right == null) continue;
                    right = right.map((MapFunction)new FAFOffsetMapFunction(right.getRowMeta(), comparison.getPeriodFieldName(), (Map)comparison.getLinkMap().get(cmetaCode)));
                    JoinDataSetX joinDataSetX = result.leftJoin(right);
                    for (String group : grouper) {
                        joinDataSetX = joinDataSetX.on(group, group);
                    }
                    result = joinDataSetX.withFunc((JoinFunction)new FAFJoinFunction(result.getRowMeta(), right.getRowMeta(), grouper));
                }
                result = result.map((MapFunction)new FAFComparisonMapFunction(result.getRowMeta(), comparison));
            }
        }
        return result;
    }

    private DataSetX calculate(IProcess process, FAFComparisonMetaEnum cmeta) {
        if (process instanceof IAggregateProcess) {
            return this.calculateAggregate((IAggregateProcess)process, cmeta);
        }
        if (process instanceof IFormulaProcess) {
            return this.calculateFormula((IFormulaProcess)process, cmeta);
        }
        throw new KDBizException(new ErrorCode("pa.fas.algox.cal", "be unable to handle this type index"), new Object[0]);
    }

    private DataSetX calculateAggregate(IAggregateProcess process, FAFComparisonMetaEnum cmeta) {
        DataSetX result;
        OrmInput input;
        OrmInput ormInput = input = cmeta.eq((Object)FAFComparisonMetaEnum.NONE) ? process.getOrmInput() : process.getOffsetOrmInput(cmeta.getCode());
        if (input == null) {
            return null;
        }
        DataSetX dataSetX = this.session.fromInput((Input)input);
        FAFDateProcess dateProcess = process.getDateProcess();
        if (dateProcess.needProcess() && this.containDateField(dataSetX.getRowMeta())) {
            dataSetX = dataSetX.map((MapFunction)new FAFDateTimeToDateMapFunction(dataSetX.getRowMeta(), dateProcess));
        }
        String fieldName = process.getFieldName(cmeta.getPrefix());
        Grouper grouper = dataSetX.groupBy(process.grouper());
        String aggregate = process.getAggregate();
        if (FAFIndexAggregateEnum.SUM.eq((Object)aggregate)) {
            result = grouper.sum(process.getAggmeasure(), fieldName);
        } else if (FAFIndexAggregateEnum.COUNT.eq((Object)aggregate)) {
            result = grouper.count("id", fieldName);
        } else if (FAFIndexAggregateEnum.AVERAGE.eq((Object)aggregate)) {
            result = grouper.reduceGroup((GroupReduceFunction)new FAFAvgReduceFunction(dataSetX.getRowMeta(), process, fieldName));
        } else if (FAFIndexAggregateEnum.MAX.eq((Object)aggregate)) {
            result = grouper.max(process.getAggmeasure(), fieldName);
        } else if (FAFIndexAggregateEnum.MIN.eq((Object)aggregate)) {
            result = grouper.min(process.getAggmeasure(), fieldName);
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u5904\u7406\u7684\u805a\u5408\u65b9\u5f0f: %s", (String)"FAFIndexAlgoxCalculateServiceImpl_0", (String)"macc-faf-business", (Object[])new Object[0]), aggregate));
        }
        return this.addLinkRow(result);
    }

    private DataSetX calculateFormula(IFormulaProcess process, FAFComparisonMetaEnum cmeta) {
        List list = process.getAllAggregateProcess();
        DataSetX result = null;
        String[] grouper = this.getGrouper((IProcess)process);
        if (list.size() > 0) {
            DataSetX left = this.calculateAggregate((IAggregateProcess)list.get(0), cmeta);
            if (left != null && list.size() > 1) {
                for (int i = 1; i < list.size(); ++i) {
                    DataSetX right = this.calculateAggregate((IAggregateProcess)list.get(i), cmeta);
                    if (right == null) continue;
                    JoinDataSetX joinDataSetX = left.fullJoin(right);
                    for (String group : grouper) {
                        joinDataSetX = joinDataSetX.on(group, group);
                    }
                    left = joinDataSetX.withFunc((JoinFunction)new FAFJoinFunction(left.getRowMeta(), right.getRowMeta(), grouper));
                }
            }
            if (left != null) {
                result = left.map((MapFunction)new FAFCompositeIndexFormulaCalcMapFunction(left.getRowMeta(), process, grouper, cmeta));
            }
        }
        return result;
    }
}

