/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.management.exec.executor;

import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.macc.faf.management.bo.param.request.BatchUpdateTaskParam;
import kd.macc.faf.management.bo.param.request.QueryTaskParam;
import kd.macc.faf.management.bo.param.request.SubTaskInfo;
import kd.macc.faf.management.enums.TaskOptTypeEnum;
import kd.macc.faf.management.exception.TaskExecuteException;
import kd.macc.faf.management.exec.executor.SubTaskService;
import kd.macc.faf.management.exec.executor.TaskManagementExecutor;
import kd.macc.faf.management.factory.TaskParamFactory;
import kd.macc.faf.management.helper.TaskManagementDataHelper;

public class BatchUpdateTaskManagementExecutor
extends TaskManagementExecutor<BatchUpdateTaskParam> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(BatchUpdateTaskParam updateTaskParam) {
        try (TXHandle h = TX.required();){
            this.createOrUpdateSubTask(updateTaskParam);
            Object var4_5 = null;
            return var4_5;
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void createOrUpdateSubTask(BatchUpdateTaskParam updateTaskParam) {
        DynamicObject[] taskDys;
        SubTaskService subTaskService = SubTaskService.getInstance();
        for (DynamicObject taskDy : taskDys = this.getExistTaskByParam(updateTaskParam)) {
            DynamicObjectCollection subTaskEntry = taskDy.getDynamicObjectCollection("entryentity");
            for (SubTaskInfo subTaskInfo : updateTaskParam.getSubTaskInfos()) {
                int subTaskIndex = subTaskInfo.getSubTaskIndex();
                Optional<DynamicObject> subTaskEntryOption = subTaskEntry.stream().filter(subTask -> subTask.getInt("seq") == subTaskIndex).findAny();
                if (subTaskEntryOption.isPresent()) {
                    subTaskService.updateSubTask(subTaskInfo, updateTaskParam.getSubTaskCount(), taskDy, subTaskEntryOption.get());
                    continue;
                }
                subTaskEntry.add((Object)subTaskService.createSubTask(subTaskInfo, subTaskEntry.getDynamicObjectType()));
            }
        }
        TaskManagementDataHelper.saveTask(taskDys);
    }

    private DynamicObject[] getExistTaskByParam(BatchUpdateTaskParam updateTaskParam) {
        QueryTaskParam queryTaskParam = (QueryTaskParam)TaskParamFactory.get(TaskOptTypeEnum.QUERY, null);
        queryTaskParam.setRequestId(updateTaskParam.getRequestId());
        Object[] ExistTaskDys = TaskManagementDataHelper.loadDysByParam(queryTaskParam);
        if (ArrayUtils.isEmpty((Object[])ExistTaskDys)) {
            throw new TaskExecuteException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u66f4\u65b0\u7684\u4efb\u52a1\u4e0d\u5b58\u5728,\u66f4\u65b0\u4efb\u52a1\u53c2\u6570\u4e3a : %s\u3002", (String)"UpdateTaskManagementExecutor_2", (String)"macc-faf-business", (Object[])new Object[0]), updateTaskParam));
        }
        return ExistTaskDys;
    }
}

