/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.management.exec.executor;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.macc.faf.management.bo.param.request.OrgPeriodCombBO;
import kd.macc.faf.management.bo.param.request.RegisterTaskParam;
import kd.macc.faf.management.enums.TaskStatusEnum;
import kd.macc.faf.management.exception.TaskExecuteException;
import kd.macc.faf.management.exec.executor.TaskManagementExecutor;
import kd.macc.faf.management.helper.TaskManagementDataHelper;

public class RegisterTaskManagementExecutor
extends TaskManagementExecutor<RegisterTaskParam> {
    @Override
    public Object execute(RegisterTaskParam registerTaskParam) {
        if (registerTaskParam.isTestRegister()) {
            return 0;
        }
        DynamicObject[] taskDys = this.buildTaskDys(registerTaskParam);
        TaskManagementDataHelper.batchSave(taskDys);
        return taskDys.length;
    }

    protected DynamicObject[] buildTaskDys(RegisterTaskParam registerTaskParam) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"faf_taskmanagement");
        List orgPeriodIds = registerTaskParam.getOrgPeriodIds();
        Object[] batchNumbers = CodeRuleServiceHelper.getBatchNumber((String)"faf_taskmanagement", (DynamicObject)new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"faf_taskmanagement")), null, (int)orgPeriodIds.size());
        if (ArrayUtils.isEmpty((Object[])batchNumbers)) {
            throw new TaskExecuteException(ResManager.loadKDString((String)"\u751f\u6210\u4efb\u52a1\u65f6\u627e\u4e0d\u5230\u6709\u6548\u7684\u7f16\u53f7\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u4efb\u52a1\u7ba1\u7406\u6a21\u5757\u7684\u7f16\u53f7\u89c4\u5219\u914d\u7f6e\u3002", (String)"RegisterTaskManagementExecutor_0", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        Date now = new Date();
        ArrayList<DynamicObject> registerTaskDys = new ArrayList<DynamicObject>(orgPeriodIds.size());
        for (int i = 0; i < orgPeriodIds.size(); ++i) {
            OrgPeriodCombBO orgPeriodCombBO = (OrgPeriodCombBO)orgPeriodIds.get(i);
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
            dynamicObject.set("requestid", (Object)registerTaskParam.getRequestId());
            dynamicObject.set("billno", batchNumbers[i]);
            dynamicObject.set("tasktype", (Object)registerTaskParam.getTaskType());
            dynamicObject.set("anamodel", (Object)registerTaskParam.getAnaModelId());
            dynamicObject.set("org", (Object)orgPeriodCombBO.getOrgId());
            dynamicObject.set("period", (Object)orgPeriodCombBO.getPeriodId());
            dynamicObject.set("creator", (Object)registerTaskParam.getCreatorId());
            dynamicObject.set("createtime", (Object)now);
            dynamicObject.set("progress", (Object)"0%");
            dynamicObject.set("execstatus", (Object)TaskStatusEnum.TODO.getCode());
            dynamicObject.set("exectype", (Object)registerTaskParam.getTaskExecType());
            dynamicObject.set("businessinfo", (Object)registerTaskParam.getBusinessInfo());
            dynamicObject.set("businesskey", (Object)registerTaskParam.getBusinessKey());
            registerTaskDys.add(dynamicObject);
        }
        return registerTaskDys.toArray(new DynamicObject[0]);
    }
}

