/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.management.exec.executor;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.macc.faf.management.bo.param.request.SubTaskInfo;
import kd.macc.faf.management.enums.SubTaskStatusEnum;
import kd.macc.faf.management.enums.TaskStatusEnum;

public class SubTaskService {
    private static final SubTaskService service = new SubTaskService();

    private SubTaskService() {
    }

    public static SubTaskService getInstance() {
        return service;
    }

    public DynamicObject createSubTask(SubTaskInfo subTaskInfo, DynamicObjectType dyt) {
        DynamicObject subTaskDy = new DynamicObject(dyt);
        subTaskDy.set("seq", (Object)subTaskInfo.getSubTaskIndex());
        subTaskDy.set("taskname", (Object)subTaskInfo.getSubTaskName());
        subTaskDy.set("subtaskuuid", (Object)subTaskInfo.getUuid());
        subTaskDy.set("subtaskstatus", (Object)subTaskInfo.getSubTaskStatus());
        return subTaskDy;
    }

    public void updateSubTask(SubTaskInfo subTaskInfo, int subTaskCount, DynamicObject taskDy, DynamicObject subTaskDy) {
        int subTaskIndex = subTaskDy.getInt("seq");
        String subTaskStatus = subTaskInfo.getSubTaskStatus();
        DynamicObjectCollection subTaskEntry = taskDy.getDynamicObjectCollection("entryentity");
        subTaskDy.set("subtaskstatus", (Object)subTaskStatus);
        switch (SubTaskStatusEnum.getEnumByCode((String)subTaskStatus)) {
            case TODO: {
                subTaskDy.set("subtaskalgoid", null);
                subTaskDy.set("subtaskstarttime", null);
                subTaskDy.set("subtaskendtime", null);
                subTaskDy.set("subconsumetime", null);
                subTaskDy.set("subconsumetimestr", null);
                subTaskDy.set("subtaskcomment", null);
                long countOfSuccess = subTaskEntry.stream().filter(subTask -> SubTaskStatusEnum.SUCCEED == SubTaskStatusEnum.getEnumByCode((String)subTask.getString("subtaskstatus"))).count();
                taskDy.set("progress", (Object)new BigDecimal(countOfSuccess).multiply(new BigDecimal("100")).divide(new BigDecimal(subTaskCount), 2, 4));
                break;
            }
            case PROCESSING: {
                subTaskDy.set("subtaskstarttime", (Object)new Date());
                subTaskDy.set("subtaskalgoid", (Object)subTaskInfo.getJobId());
                if (subTaskIndex != 1) break;
                taskDy.set("execstatus", (Object)TaskStatusEnum.PROCESSING.getCode());
                taskDy.set("startexectime", (Object)new Date());
                break;
            }
            case SUCCEED: {
                Date subTaskStartTime = subTaskDy.getDate("subtaskstarttime");
                Date endTime = new Date();
                BigDecimal subTaskConsumerTime = null;
                if (subTaskStartTime != null) {
                    subTaskConsumerTime = new BigDecimal(endTime.getTime() - subTaskStartTime.getTime()).divide(new BigDecimal("1000"), 2, 4);
                }
                subTaskDy.set("subtaskendtime", (Object)endTime);
                subTaskDy.set("subconsumetime", subTaskConsumerTime);
                if (subTaskConsumerTime != null) {
                    int consumeSeconds = subTaskConsumerTime.intValue();
                    subTaskDy.set("subconsumetimestr", (Object)String.format("%1$d:%2$02d:%3$02d", consumeSeconds / 3600, consumeSeconds % 3600 / 60, consumeSeconds % 60));
                }
                long countOfSuccess = subTaskEntry.stream().filter(subTask -> SubTaskStatusEnum.SUCCEED == SubTaskStatusEnum.getEnumByCode((String)subTask.getString("subtaskstatus"))).count();
                taskDy.set("progress", (Object)(new BigDecimal(countOfSuccess).multiply(new BigDecimal("100")).divide(new BigDecimal(subTaskCount), 2, 4) + "%"));
                if (subTaskIndex != subTaskCount) break;
                taskDy.set("execstatus", (Object)TaskStatusEnum.SUCCEED.getCode());
                taskDy.set("endexectime", (Object)endTime);
                Date taskStartTime = taskDy.getDate("startexectime");
                BigDecimal taskConsumerTime = null;
                if (taskStartTime != null) {
                    taskConsumerTime = new BigDecimal(endTime.getTime() - taskStartTime.getTime()).divide(new BigDecimal("1000"), 2, 4);
                }
                taskDy.set("consumetime", taskConsumerTime);
                if (taskConsumerTime == null) break;
                int consumeSeconds = taskConsumerTime.intValue();
                taskDy.set("consumetimestr", (Object)String.format("%1$d:%2$02d:%3$02d", consumeSeconds / 3600, consumeSeconds % 3600 / 60, consumeSeconds % 60));
                break;
            }
            case FAILED: {
                Date endTime = new Date();
                subTaskDy.set("subtaskendtime", (Object)endTime);
                subTaskDy.set("subtaskcomment", (Object)subTaskInfo.getSubTaskComment());
                taskDy.set("execstatus", (Object)TaskStatusEnum.FAILED.getCode());
                taskDy.set("endexectime", (Object)endTime);
                taskDy.set("loginfo", (Object)subTaskInfo.getSubTaskComment());
                break;
            }
        }
    }
}

