/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.management.exec.executor;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.macc.faf.management.bo.param.request.OrgPeriodCombBO;
import kd.macc.faf.management.bo.param.request.QueryTaskParam;
import kd.macc.faf.management.bo.param.request.SubTaskInfo;
import kd.macc.faf.management.bo.param.request.UpdateTaskParam;
import kd.macc.faf.management.enums.TaskOptTypeEnum;
import kd.macc.faf.management.exception.TaskExecuteException;
import kd.macc.faf.management.exec.executor.SubTaskService;
import kd.macc.faf.management.exec.executor.TaskManagementExecutor;
import kd.macc.faf.management.factory.TaskParamFactory;
import kd.macc.faf.management.helper.TaskManagementDataHelper;

public class UpdateTaskManagementExecutor
extends TaskManagementExecutor<UpdateTaskParam> {
    @Override
    public Object execute(UpdateTaskParam updateTaskParam) {
        DynamicObject taskDy = this.getExistTaskByParam(updateTaskParam);
        this.executeSubEntry(updateTaskParam.getSubTaskInfos(), updateTaskParam.getSubTaskCount(), taskDy);
        return null;
    }

    private void executeSubEntry(List<SubTaskInfo> subTaskInfos, int subTaskCount, DynamicObject taskDy) {
        SubTaskService subTaskService = SubTaskService.getInstance();
        DynamicObjectCollection subTaskEntry = taskDy.getDynamicObjectCollection("entryentity");
        for (SubTaskInfo subTaskInfo : subTaskInfos) {
            int subTaskIndex = subTaskInfo.getSubTaskIndex();
            Optional<DynamicObject> subTaskEntryOption = subTaskEntry.stream().filter(subTask -> subTask.getInt("seq") == subTaskIndex).findAny();
            try {
                TXHandle h = TX.required();
                Throwable throwable = null;
                try {
                    if (subTaskEntryOption.isPresent()) {
                        subTaskService.updateSubTask(subTaskInfo, subTaskCount, taskDy, subTaskEntryOption.get());
                    } else {
                        subTaskEntry.add((Object)subTaskService.createSubTask(subTaskInfo, subTaskEntry.getDynamicObjectType()));
                    }
                    TaskManagementDataHelper.saveTask(new DynamicObject[]{taskDy});
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (h == null) continue;
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    h.close();
                }
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private DynamicObject getExistTaskByParam(UpdateTaskParam updateTaskParam) {
        QueryTaskParam queryTaskParam = (QueryTaskParam)TaskParamFactory.get(TaskOptTypeEnum.QUERY, null);
        Long taskId = updateTaskParam.getTaskId();
        if (taskId != null && taskId > 0L) {
            queryTaskParam.setTaskIds(Collections.singletonList(taskId));
        } else {
            OrgPeriodCombBO orgPeriodCombBO = OrgPeriodCombBO.of((Long)updateTaskParam.getOrgId(), (Long)updateTaskParam.getPeriodId());
            queryTaskParam.setRequestId(updateTaskParam.getRequestId());
            queryTaskParam.setOrgPeriodIds(Collections.singletonList(orgPeriodCombBO));
        }
        Object[] ExistTaskDys = TaskManagementDataHelper.loadDysByParam(queryTaskParam);
        if (ArrayUtils.isEmpty((Object[])ExistTaskDys)) {
            throw new TaskExecuteException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u66f4\u65b0\u7684\u4efb\u52a1\u4e0d\u5b58\u5728,\u66f4\u65b0\u4efb\u52a1\u53c2\u6570\u4e3a : %s\u3002", (String)"UpdateTaskManagementExecutor_2", (String)"macc-faf-business", (Object[])new Object[0]), updateTaskParam));
        }
        return ExistTaskDys[0];
    }
}

