/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.management.exec.processor.manage;

import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.macc.faf.management.bo.param.BeforeWrapperParam;
import kd.macc.faf.management.bo.param.request.BatchUpdateTaskParam;
import kd.macc.faf.management.bo.param.request.SubTaskInfo;
import kd.macc.faf.management.bo.result.ParamCheckResult;
import kd.macc.faf.management.enums.SubTaskStatusEnum;
import kd.macc.faf.management.enums.TaskOptTypeEnum;
import kd.macc.faf.management.exec.processor.manage.TaskManagementProcessor;

public class BatchUpdateTaskManagementProcessor
extends TaskManagementProcessor<BatchUpdateTaskParam> {
    private static final Log logger = LogFactory.getLog(BatchUpdateTaskManagementProcessor.class);

    public BatchUpdateTaskManagementProcessor() {
        super(TaskOptTypeEnum.BATCH_UPDATE);
    }

    @Override
    ParamCheckResult checkParam(BatchUpdateTaskParam updateTaskParam) {
        logger.info(String.format("[BatchUpdateTaskManagementProcessor - checkParam] : %s", updateTaskParam.toString()));
        Long requestId = updateTaskParam.getRequestId();
        if (requestId == null || requestId <= 0L) {
            return ParamCheckResult.of((boolean)false, (String)ResManager.loadKDString((String)"\u4efb\u52a1\u8bf7\u6c42id\u4e0d\u5408\u6cd5\u3002", (String)"UpdateTaskManagementProcessor_3", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        int subTaskCount = updateTaskParam.getSubTaskCount();
        if (subTaskCount < 1) {
            return ParamCheckResult.of((boolean)false, (String)ResManager.loadKDString((String)"\u5b50\u4efb\u52a1\u603b\u6570\u4e0d\u5408\u6cd5\u3002", (String)"UpdateTaskManagementProcessor_0", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        List subTaskInfos = updateTaskParam.getSubTaskInfos();
        if (CollectionUtils.isEmpty((Collection)subTaskInfos)) {
            return ParamCheckResult.of((boolean)false, (String)ResManager.loadKDString((String)"\u5b50\u4efb\u52a1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpdateTaskManagementProcessor_8", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        for (SubTaskInfo subTaskInfo : subTaskInfos) {
            String subTaskStatus = subTaskInfo.getSubTaskStatus();
            if (StringUtils.isBlank((CharSequence)subTaskStatus)) {
                return ParamCheckResult.of((boolean)false, (String)ResManager.loadKDString((String)"\u5b50\u4efb\u52a1\u66f4\u65b0\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpdateTaskManagementProcessor_1", (String)"macc-faf-business", (Object[])new Object[0]));
            }
            try {
                SubTaskStatusEnum.getEnumByCode((String)subTaskStatus);
            }
            catch (Exception e) {
                return ParamCheckResult.of((boolean)false, (String)e.getMessage());
            }
            int subTaskIndex = subTaskInfo.getSubTaskIndex();
            if (subTaskIndex >= 1 && subTaskIndex <= subTaskCount) continue;
            return ParamCheckResult.of((boolean)false, (String)ResManager.loadKDString((String)"\u5b50\u4efb\u52a1\u7d22\u5f15\u4e0d\u5408\u6cd5\u3002", (String)"UpdateTaskManagementProcessor_2", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        return ParamCheckResult.of((boolean)true, (String)"");
    }

    @Override
    protected void beforeExecute(BeforeWrapperParam<BatchUpdateTaskParam> beforeWrapperParam) {
        BatchUpdateTaskParam batchUpdateTaskParam = (BatchUpdateTaskParam)beforeWrapperParam.getParam();
        for (SubTaskInfo subTaskInfo : batchUpdateTaskParam.getSubTaskInfos()) {
            String subTaskComment = subTaskInfo.getSubTaskComment();
            if (!StringUtils.isNotBlank((CharSequence)subTaskComment) || subTaskComment.length() <= 1024) continue;
            subTaskInfo.setSubTaskComment(subTaskComment.substring(0, 1024));
        }
    }
}

