/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.management.exec.processor.manage;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.macc.faf.management.bo.param.BeforeWrapperParam;
import kd.macc.faf.management.bo.param.request.QueryTaskParam;
import kd.macc.faf.management.bo.param.request.RegisterTaskParam;
import kd.macc.faf.management.bo.result.ParamCheckResult;
import kd.macc.faf.management.enums.TaskOptTypeEnum;
import kd.macc.faf.management.enums.TaskResultCodeEnum;
import kd.macc.faf.management.enums.TaskStatusEnum;
import kd.macc.faf.management.enums.TaskTypeEnum;
import kd.macc.faf.management.exec.processor.manage.TaskManagementProcessor;
import kd.macc.faf.management.factory.TaskParamFactory;
import kd.macc.faf.management.helper.TaskManagementDataHelper;

public class RegisterTaskManagementProcessor
extends TaskManagementProcessor<RegisterTaskParam> {
    private static final Log logger = LogFactory.getLog(RegisterTaskManagementProcessor.class);

    public RegisterTaskManagementProcessor() {
        super(TaskOptTypeEnum.REGISTER);
    }

    @Override
    ParamCheckResult checkParam(RegisterTaskParam registerTaskParam) {
        logger.info(String.format("[RegisterTaskManagementProcessor - checkParam - \u53d6\u6570\u4efb\u52a1\u6ce8\u518c\u8bf7\u6c42\u53c2\u6570] registerTaskParam : %s", registerTaskParam.toString()));
        String cloudId = registerTaskParam.getCloudId();
        if (StringUtils.isBlank((CharSequence)cloudId)) {
            return ParamCheckResult.of((boolean)false, (String)ResManager.loadKDString((String)"\u4e91id\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RegisterTaskManagementProcessor_0", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        String appId = registerTaskParam.getAppId();
        if (StringUtils.isBlank((CharSequence)appId)) {
            return ParamCheckResult.of((boolean)false, (String)ResManager.loadKDString((String)"appId\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RegisterTaskManagementProcessor_1", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        String taskType = registerTaskParam.getTaskType();
        if (StringUtils.isBlank((CharSequence)appId)) {
            return ParamCheckResult.of((boolean)false, (String)ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RegisterTaskManagementProcessor_2", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        try {
            TaskTypeEnum.getEnumByCode((String)taskType);
        }
        catch (Exception e) {
            return ParamCheckResult.of((boolean)false, (String)e.getMessage());
        }
        Long anaModelId = registerTaskParam.getAnaModelId();
        if (anaModelId == null || anaModelId <= 0L) {
            return ParamCheckResult.of((boolean)false, (String)ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578bid\u4e0d\u5408\u6cd5\u3002", (String)"RegisterTaskManagementProcessor_3", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        Long requestId = registerTaskParam.getRequestId();
        if (requestId == null || requestId <= 0L) {
            return ParamCheckResult.of((boolean)false, (String)ResManager.loadKDString((String)"\u8bf7\u6c42id\u4e0d\u5408\u6cd5\u3002", (String)"RegisterTaskManagementProcessor_4", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        Long creatorId = registerTaskParam.getCreatorId();
        if (creatorId == null || creatorId <= 0L) {
            return ParamCheckResult.of((boolean)false, (String)ResManager.loadKDString((String)"\u521b\u5efa\u4ebaid\u4e0d\u5408\u6cd5\u3002", (String)"RegisterTaskManagementProcessor_5", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        List orgPeriodIds = registerTaskParam.getOrgPeriodIds();
        if (CollectionUtils.isEmpty((Collection)orgPeriodIds)) {
            return ParamCheckResult.of((boolean)false, (String)ResManager.loadKDString((String)"[\u7ec4\u7ec7+\u671f\u95f4]\u53c2\u6570\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RegisterTaskManagementProcessor_6", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        if (orgPeriodIds.size() > 100) {
            return ParamCheckResult.of((boolean)false, (String)ResManager.loadKDString((String)"[\u7ec4\u7ec7+\u671f\u95f4]\u53c2\u6570\u96c6\u5408\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7100\u3002", (String)"RegisterTaskManagementProcessor_7", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        String businessKey = registerTaskParam.getBusinessKey();
        if (StringUtils.isBlank((CharSequence)businessKey)) {
            return ParamCheckResult.of((boolean)false, (String)ResManager.loadKDString((String)"\u4e1a\u52a1Key\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RegisterTaskManagementProcessor_12", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        String taskExecType = registerTaskParam.getTaskExecType();
        if (StringUtils.isBlank((CharSequence)taskExecType)) {
            return ParamCheckResult.of((boolean)false, (String)ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u7c7b\u578b\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RegisterTaskManagementProcessor_8", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        return ParamCheckResult.of((boolean)true, (String)"");
    }

    @Override
    protected void beforeExecute(BeforeWrapperParam<RegisterTaskParam> beforeWrapperParam) {
        Object[] succeedTaskDys;
        RegisterTaskParam registerTaskParam = (RegisterTaskParam)beforeWrapperParam.getParam();
        Object[] waitingTaskDys = this.getExistTaskByStatuses(registerTaskParam, TaskStatusEnum.TODO.getCode(), TaskStatusEnum.PROCESSING.getCode());
        if (!ArrayUtils.isEmpty((Object[])waitingTaskDys)) {
            TaskTypeEnum taskTypeEnum = TaskTypeEnum.getEnumByCode((String)waitingTaskDys[0].getString("tasktype"));
            Set orgNames = Arrays.stream(waitingTaskDys).map(dy -> dy.getDynamicObject("org").getString("name")).collect(Collectors.toSet());
            String orgNameStr = orgNames.size() > 10 ? String.format(ResManager.loadKDString((String)"%1$s\u7b49%2$s\u4e2a\u7ec4\u7ec7", (String)"RegisterTaskManagementProcessor_11", (String)"macc-faf-business", (Object[])new Object[0]), orgNames.stream().limit(10L).collect(Collectors.joining("\u3001")), orgNames.size()) : String.join((CharSequence)"\u3001", orgNames);
            beforeWrapperParam.setCancel(true);
            beforeWrapperParam.setErrorCode(TaskResultCodeEnum.CLIENT_ERROR_401.getCode());
            beforeWrapperParam.setCancelMessage(String.format(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\uff08%1$s\uff09\u5728%2$s\u5df2\u6709\u5f85\u6267\u884c\u6216\u6267\u884c\u4e2d\u7684%3$s\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"RegisterTaskManagementProcessor_9", (String)"macc-faf-business", (Object[])new Object[0]), orgNameStr, waitingTaskDys[0].getDynamicObject("period").getString("name"), taskTypeEnum.getText()));
            return;
        }
        boolean force = registerTaskParam.isForce();
        if (!force && !ArrayUtils.isEmpty((Object[])(succeedTaskDys = this.getExistTaskByStatuses(registerTaskParam, TaskStatusEnum.SUCCEED.getCode())))) {
            TaskTypeEnum taskTypeEnum = TaskTypeEnum.getEnumByCode((String)succeedTaskDys[0].getString("tasktype"));
            Set orgNames = Arrays.stream(succeedTaskDys).map(dy -> dy.getDynamicObject("org").getString("name")).collect(Collectors.toSet());
            String orgNameStr = orgNames.size() > 10 ? String.format(ResManager.loadKDString((String)"%1$s\u7b49%2$s\u4e2a\u7ec4\u7ec7", (String)"RegisterTaskManagementProcessor_11", (String)"macc-faf-business", (Object[])new Object[0]), orgNames.stream().limit(10L).collect(Collectors.joining("\u3001")), orgNames.size()) : String.join((CharSequence)"\u3001", orgNames);
            beforeWrapperParam.setCancel(true);
            beforeWrapperParam.setErrorCode(TaskResultCodeEnum.TO_CONFIRM.getCode());
            beforeWrapperParam.setCancelMessage(String.format(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\uff08%1$s\uff09\u5728%2$s\u5df2\u6267\u884c\u8fc7\u8be5%3$s\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u6267\u884c\u3002", (String)"RegisterTaskManagementProcessor_10", (String)"macc-faf-business", (Object[])new Object[0]), orgNameStr, succeedTaskDys[0].getDynamicObject("period").getString("name"), taskTypeEnum.getText()));
        }
    }

    protected DynamicObject[] getExistTaskByStatuses(RegisterTaskParam registerTaskParam, String ... taskStatuses) {
        QueryTaskParam queryTaskParam = (QueryTaskParam)TaskParamFactory.get(TaskOptTypeEnum.QUERY, null);
        queryTaskParam.setModelId(registerTaskParam.getAnaModelId());
        queryTaskParam.setOrgPeriodIds(registerTaskParam.getOrgPeriodIds());
        queryTaskParam.setTaskStatuses(Stream.of(taskStatuses).collect(Collectors.toList()));
        queryTaskParam.setBusinessKey(registerTaskParam.getBusinessKey());
        return TaskManagementDataHelper.loadDysByParam(queryTaskParam);
    }

    @Override
    protected boolean isTriggerDistribute(RegisterTaskParam param) {
        return false;
    }
}

