/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.management.exec.processor.manage;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.management.bo.param.BeforeWrapperParam;
import kd.macc.faf.management.bo.param.request.TaskParam;
import kd.macc.faf.management.bo.result.ParamCheckResult;
import kd.macc.faf.management.bo.result.TaskManagementResult;
import kd.macc.faf.management.enums.TaskOptTypeEnum;
import kd.macc.faf.management.enums.TaskResultCodeEnum;
import kd.macc.faf.management.exception.TaskExecuteException;
import kd.macc.faf.management.exec.executor.TaskManagementExecutor;
import kd.macc.faf.management.exec.processor.Processor;
import kd.macc.faf.management.factory.TaskManagementExecutorFactory;
import kd.macc.faf.management.helper.TaskDistributor;

public abstract class TaskManagementProcessor<P extends TaskParam>
implements Processor<P> {
    private static final Log logger = LogFactory.getLog(TaskManagementProcessor.class);
    protected final TaskOptTypeEnum taskOptTypeEnum;
    protected TaskManagementExecutor<P> taskManagementExecutor;

    public TaskManagementProcessor(TaskOptTypeEnum taskOptTypeEnum) {
        this.taskOptTypeEnum = taskOptTypeEnum;
        this.taskManagementExecutor = TaskManagementExecutorFactory.get(this.taskOptTypeEnum);
    }

    public TaskManagementResult process(P requestData) {
        ParamCheckResult checkResult = this.checkParam(requestData);
        if (!checkResult.isValid()) {
            return TaskManagementResult.of((String)TaskResultCodeEnum.CLIENT_ERROR.getCode(), (String)checkResult.getErrorMessage());
        }
        TaskManagementResult resp = this.manage(requestData);
        if (TaskResultCodeEnum.SUCCESS != TaskResultCodeEnum.getEnumByCode((String)resp.getCode())) {
            return resp;
        }
        if (this.isTriggerDistribute(requestData)) {
            TaskDistributor.getInstance().triggerTaskDistribute();
        }
        return resp;
    }

    abstract ParamCheckResult checkParam(P var1);

    private TaskManagementResult manage(P taskParam) {
        BeforeWrapperParam beforeWrapperParam = BeforeWrapperParam.of(taskParam, (boolean)false, (String)"", (String)"");
        this.beforeExecute(beforeWrapperParam);
        TaskManagementResult taskManagementResult = TaskManagementResult.of((String)"", (String)"");
        if (!beforeWrapperParam.isCancel()) {
            try {
                taskManagementResult.setData(this.taskManagementExecutor.execute(taskParam));
                taskManagementResult.setCode(TaskResultCodeEnum.SUCCESS.getCode());
            }
            catch (TaskExecuteException taskExecuteException) {
                String errorMessage = taskExecuteException.getCause() != null ? taskExecuteException.getCause().getMessage() : taskExecuteException.getMessage();
                taskManagementResult.setCode(TaskResultCodeEnum.CLIENT_ERROR.getCode());
                taskManagementResult.setErrorMessage(errorMessage);
                logger.error("[TaskManagementProcessor - manage] \u4efb\u52a1\u6267\u884c\u5f02\u5e38 : %s", (Object)errorMessage);
            }
            catch (Exception exception) {
                String errorMessage = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
                taskManagementResult.setCode(TaskResultCodeEnum.SERVER_ERROR.getCode());
                taskManagementResult.setErrorMessage(errorMessage);
                logger.error("[TaskManagementProcessor - manage] \u7cfb\u7edf\u5f02\u5e38 : %s", (Object)errorMessage);
            }
        } else {
            taskManagementResult.setCode(beforeWrapperParam.getErrorCode());
            taskManagementResult.setErrorMessage(beforeWrapperParam.getCancelMessage());
        }
        return taskManagementResult;
    }

    protected void beforeExecute(BeforeWrapperParam<P> beforeWrapperParam) {
    }

    protected boolean isTriggerDistribute(P taskParam) {
        return false;
    }
}

