/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.management.factory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.management.enums.TaskOptTypeEnum;
import kd.macc.faf.management.exception.TaskInitException;
import kd.macc.faf.management.exec.executor.BatchUpdateTaskManagementExecutor;
import kd.macc.faf.management.exec.executor.QueryTaskManagementExecutor;
import kd.macc.faf.management.exec.executor.RegisterTaskManagementExecutor;
import kd.macc.faf.management.exec.executor.TaskManagementExecutor;
import kd.macc.faf.management.exec.executor.UpdateTaskManagementExecutor;

public class TaskManagementExecutorFactory {
    private static final Log logger = LogFactory.getLog(TaskManagementExecutorFactory.class);
    private static final Map<String, TaskManagementExecutor> taskExecutorMap = new ConcurrentHashMap<String, TaskManagementExecutor>();

    public static <T extends TaskManagementExecutor> T get(TaskOptTypeEnum taskOptTypeEnum) throws TaskInitException {
        if (taskOptTypeEnum == null) {
            throw new TaskInitException(ResManager.loadKDString((String)"[TaskManagementExecutorFactory] \u4efb\u52a1\u64cd\u4f5c\u7c7b\u578b\u679a\u4e3e\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskManagementExecutorFactory_0", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        String key = taskOptTypeEnum.getCode();
        return (T)taskExecutorMap.computeIfAbsent(key, k -> TaskManagementExecutorFactory.create(taskOptTypeEnum));
    }

    private static <T extends TaskManagementExecutor> T create(TaskOptTypeEnum taskOptTypeEnum) throws TaskInitException {
        Class clazz;
        switch (taskOptTypeEnum) {
            case QUERY: {
                clazz = QueryTaskManagementExecutor.class;
                break;
            }
            case REGISTER: {
                clazz = RegisterTaskManagementExecutor.class;
                break;
            }
            case UPDATE: {
                clazz = UpdateTaskManagementExecutor.class;
                break;
            }
            case BATCH_UPDATE: {
                clazz = BatchUpdateTaskManagementExecutor.class;
                break;
            }
            default: {
                throw new TaskInitException(String.format(ResManager.loadKDString((String)"[TaskManagementExecutorFactory] \u4e0d\u652f\u6301\u4efb\u52a1\u64cd\u4f5c\u7c7b\u578b\u679a\u4e3e\u503c%s\u3002", (String)"TaskManagementExecutorFactory_1", (String)"macc-faf-business", (Object[])new Object[0]), taskOptTypeEnum.getCode()));
            }
        }
        try {
            return (T)((TaskManagementExecutor)clazz.newInstance());
        }
        catch (Exception ex) {
            logger.error("[TaskManagementExecutorFactory] \u521d\u59cb\u5316\u4efb\u52a1\u6267\u884c\u5668\u5bf9\u8c61\u5931\u8d25", (Throwable)ex);
            throw new TaskInitException(ResManager.loadKDString((String)"[TaskManagementExecutorFactory] \u521d\u59cb\u5316\u4efb\u52a1\u6267\u884c\u5668\u5bf9\u8c61\u5931\u8d25\u3002", (String)"TaskManagementExecutorFactory_2", (String)"macc-faf-business", (Object[])new Object[0]));
        }
    }
}

