/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.management.factory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.management.enums.TaskOptTypeEnum;
import kd.macc.faf.management.exception.TaskInitException;
import kd.macc.faf.management.exec.processor.manage.BatchUpdateTaskManagementProcessor;
import kd.macc.faf.management.exec.processor.manage.QueryTaskManagementProcessor;
import kd.macc.faf.management.exec.processor.manage.RegisterTaskManagementProcessor;
import kd.macc.faf.management.exec.processor.manage.TaskManagementProcessor;
import kd.macc.faf.management.exec.processor.manage.UpdateTaskManagementProcessor;

public class TaskManagementProcessorFactory {
    private static final Log logger = LogFactory.getLog(TaskManagementProcessorFactory.class);
    private static final Map<String, TaskManagementProcessor> taskProcessorMap = new ConcurrentHashMap<String, TaskManagementProcessor>();

    public static <T extends TaskManagementProcessor> T get(TaskOptTypeEnum taskOptTypeEnum) throws TaskInitException {
        if (taskOptTypeEnum == null) {
            throw new TaskInitException(ResManager.loadKDString((String)"[TaskManagementProcessorFactory] \u4efb\u52a1\u64cd\u4f5c\u7c7b\u578b\u679a\u4e3e\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskManagementProcessorFactory_0", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        String key = taskOptTypeEnum.getCode();
        return (T)taskProcessorMap.computeIfAbsent(key, k -> TaskManagementProcessorFactory.create(taskOptTypeEnum));
    }

    private static <T extends TaskManagementProcessor> T create(TaskOptTypeEnum taskOptTypeEnum) throws TaskInitException {
        Class clazz;
        switch (taskOptTypeEnum) {
            case QUERY: {
                clazz = QueryTaskManagementProcessor.class;
                break;
            }
            case REGISTER: {
                clazz = RegisterTaskManagementProcessor.class;
                break;
            }
            case UPDATE: {
                clazz = UpdateTaskManagementProcessor.class;
                break;
            }
            case BATCH_UPDATE: {
                clazz = BatchUpdateTaskManagementProcessor.class;
                break;
            }
            default: {
                throw new TaskInitException(String.format(ResManager.loadKDString((String)"[TaskManagementProcessorFactory] \u4e0d\u652f\u6301\u4efb\u52a1\u64cd\u4f5c\u7c7b\u578b\u679a\u4e3e\u503c%s\u3002", (String)"TaskManagementProcessorFactory_1", (String)"macc-faf-business", (Object[])new Object[0]), taskOptTypeEnum.getCode()));
            }
        }
        try {
            return (T)((TaskManagementProcessor)clazz.newInstance());
        }
        catch (Exception ex) {
            logger.error("[TaskManagementProcessorFactory] \u521d\u59cb\u5316\u4efb\u52a1\u8fc7\u7a0b\u5904\u7406\u5668\u5bf9\u8c61\u5931\u8d25", (Throwable)ex);
            throw new TaskInitException(ResManager.loadKDString((String)"[TaskManagementProcessorFactory] \u521d\u59cb\u5316\u4efb\u52a1\u8fc7\u7a0b\u5904\u7406\u5668\u5bf9\u8c61\u5931\u8d25\u3002", (String)"TaskManagementProcessorFactory_2", (String)"macc-faf-business", (Object[])new Object[0]));
        }
    }
}

