/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.management.factory;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.management.bo.param.request.BatchUpdateTaskParam;
import kd.macc.faf.management.bo.param.request.QueryTaskParam;
import kd.macc.faf.management.bo.param.request.RegisterTaskParam;
import kd.macc.faf.management.bo.param.request.TaskParam;
import kd.macc.faf.management.bo.param.request.UpdateTaskParam;
import kd.macc.faf.management.enums.TaskOptTypeEnum;
import kd.macc.faf.management.exception.TaskInitException;

public class TaskParamFactory {
    private static final Log logger = LogFactory.getLog(TaskParamFactory.class);

    public static <T extends TaskParam> T get(TaskOptTypeEnum taskOptTypeEnum, String jsonData) throws TaskInitException {
        if (taskOptTypeEnum == null) {
            throw new TaskInitException(ResManager.loadKDString((String)"[TaskParamFactory] \u4efb\u52a1\u64cd\u4f5c\u7c7b\u578b\u679a\u4e3e\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskParamFactory_0", (String)"macc-faf-business", (Object[])new Object[0]));
        }
        return TaskParamFactory.create(taskOptTypeEnum, jsonData);
    }

    private static <T extends TaskParam> T create(TaskOptTypeEnum taskOptTypeEnum, String jsonData) throws TaskInitException {
        Class<QueryTaskParam> clazz;
        switch (taskOptTypeEnum) {
            case QUERY: {
                clazz = QueryTaskParam.class;
                break;
            }
            case REGISTER: {
                clazz = RegisterTaskParam.class;
                break;
            }
            case UPDATE: {
                clazz = UpdateTaskParam.class;
                break;
            }
            case BATCH_UPDATE: {
                clazz = BatchUpdateTaskParam.class;
                break;
            }
            default: {
                throw new TaskInitException(String.format(ResManager.loadKDString((String)"[TaskParamFactory] \u4efb\u52a1\u64cd\u4f5c\u7c7b\u578b\u679a\u4e3e\u503c%s\u4e0d\u5b58\u5728\u3002", (String)"TaskParamFactory_1", (String)"macc-faf-business", (Object[])new Object[0]), taskOptTypeEnum.getCode()));
            }
        }
        try {
            TaskParam taskParam = StringUtils.isBlank((CharSequence)jsonData) ? (TaskParam)clazz.newInstance() : (TaskParam)SerializationUtils.fromJsonString((String)jsonData, clazz);
            return (T)taskParam;
        }
        catch (Exception ex) {
            logger.error("[TaskParamFactory] \u521d\u59cb\u5316\u4efb\u52a1\u53c2\u6570\u5bf9\u8c61\u5931\u8d25", (Throwable)ex);
            throw new TaskInitException(ResManager.loadKDString((String)"[TaskParamFactory] \u521d\u59cb\u5316\u4efb\u52a1\u53c2\u6570\u5bf9\u8c61\u5931\u8d25\u3002", (String)"TaskParamFactory_2", (String)"macc-faf-business", (Object[])new Object[0]));
        }
    }
}

