/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.result.ServiceResult;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ResultCodeEnum;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.model.impl.FAFAnalysisModelModel;
import kd.macc.faf.service.FAFFetchDataScheduleServiceHelper;
import kd.macc.faf.service.bean.PeriodCtrlResult;
import kd.macc.faf.service.bean.RecordItem;
import kd.macc.faf.stream.pipe.IExceptionListener;

public class PeriodServiceHelper {
    private static final Log log = LogFactory.getLog(PeriodServiceHelper.class);
    private static final String FORMID_PERIOD_CTRL = "pa_accperiodlock";
    private static final String FORMID_ANALYSIS_PERIOD = "pa_analysisperiod";
    private static final String FORMID_BD_PERIOD = "bd_period";
    private static final String KEY_ANALYSIS_MODEL = "analysismodel";
    private static final String KEY_ANALYSIS_SYSTEM = "analysissystem";
    private static final String KEY_PERIOD_TYPE = "periodtype";
    private static final String KEY_ORG = "choseorg";
    private static final String KEY_PERIOD = "period";
    private static final String KEY_MODIFY_TIME = "modifytime";
    private static final String KEY_MODIFIER = "modifier";
    private static final String KEY_CREATE_TIME = "createtime";
    private static final String KEY_CREATOR = "creator";
    private static final String KEY_IS_OPEN = "isopen";
    private static final String KEY_START_DATE = "startdate";
    private static final String KEY_END_DATE = "enddate";
    private static final String ANALYSIS_MODEL_ID = "analysismodel_id";
    private static final String ANALYSIS_SYSTEM_ID = "analysissystem_id";
    private static final String ORG_ID = "choseorg_id";
    private static final String PERIOD_ID = "period_id";

    public static Boolean openPeriod(long pkId) {
        DynamicObject curObj = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)FORMID_PERIOD_CTRL);
        if (curObj != null) {
            Date endDate;
            long orgId = curObj.getLong(ORG_ID);
            long analysisModelId = curObj.getLong(ANALYSIS_MODEL_ID);
            boolean isCanOpenPeriod = PeriodServiceHelper.canOpenPeriod(analysisModelId, orgId, endDate = curObj.getDate(KEY_END_DATE));
            if (isCanOpenPeriod) {
                DynamicObject fullObj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)FORMID_PERIOD_CTRL);
                fullObj.set(KEY_IS_OPEN, (Object)true);
                fullObj.set(KEY_MODIFIER, (Object)RequestContext.get().getCurrUserId());
                fullObj.set(KEY_MODIFY_TIME, (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fullObj});
                return true;
            }
        }
        return false;
    }

    public static Boolean closePeriod(long pkId) {
        ServiceResult result = new ServiceResult(ResultCodeEnum.SUCCESS);
        result.setData((Object)false);
        DynamicObject curObj = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)FORMID_PERIOD_CTRL);
        if (curObj != null) {
            long orgId = curObj.getLong(ORG_ID);
            long analysisModelId = curObj.getLong(ANALYSIS_MODEL_ID);
            long analysisSystemId = curObj.getLong(ANALYSIS_SYSTEM_ID);
            String periodFormId = curObj.getString(KEY_PERIOD_TYPE);
            Date startDate = curObj.getDate(KEY_START_DATE);
            boolean isCanClosePeriod = PeriodServiceHelper.canClosePeriod(analysisModelId, orgId, startDate);
            if (isCanClosePeriod) {
                DynamicObject fullObj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)FORMID_PERIOD_CTRL);
                fullObj.set(KEY_IS_OPEN, (Object)"0");
                fullObj.set(KEY_MODIFIER, (Object)RequestContext.get().getCurrUserId());
                fullObj.set(KEY_MODIFY_TIME, (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fullObj});
                PeriodServiceHelper.fixPeriod(analysisSystemId, analysisModelId, orgId, periodFormId, startDate);
                result.setData((Object)true);
            }
        }
        return (Boolean)result.getData();
    }

    public static Boolean checkSingle(long analysisModelId, long orgId, long periodId) {
        ServiceResult result = new ServiceResult(ResultCodeEnum.SUCCESS);
        QFilter[] qFilters = new QFilter[]{new QFilter(KEY_ANALYSIS_MODEL, "=", (Object)analysisModelId), new QFilter(KEY_ORG, "=", (Object)orgId), new QFilter(KEY_PERIOD, "=", (Object)periodId)};
        DynamicObject record = BusinessDataServiceHelper.loadSingleFromCache((String)FORMID_PERIOD_CTRL, (QFilter[])qFilters);
        if (record == null) {
            result.setData((Object)true);
        } else {
            result.setData((Object)record.getBoolean(KEY_IS_OPEN));
        }
        return (Boolean)result.getData();
    }

    public static Object batchCheckPeriod(long analysisModelId, List<Long> orgIds, List<Long> periodIds, boolean isCheckAfter) {
        Object firstDate;
        log.info("MACC.FAF: \u5f00\u59cb\u671f\u95f4\u72b6\u6001\u68c0\u6d4b. Method: batchCheckPeriod");
        PeriodCtrlResult pr = new PeriodCtrlResult();
        pr.setAnalysisModelId(analysisModelId);
        if (ObjectUtils.isEmpty(orgIds)) {
            log.info("ACC.FAF: Method: batchCreateCtrlRecord, Args: orgIds is empty");
            pr.setSuccess(false);
            pr.setErrorMsg("orgIds is empty");
            return SerializationUtils.toJsonString((Object)pr);
        }
        if (ObjectUtils.isEmpty(periodIds)) {
            log.info("ACC.FAF: Method: batchCreateCtrlRecord, Args: periodIds is empty");
            pr.setSuccess(false);
            pr.setErrorMsg("periodIds is empty");
            return SerializationUtils.toJsonString((Object)pr);
        }
        QFilter[] qFilters = new QFilter[]{new QFilter(KEY_ANALYSIS_MODEL, "=", (Object)analysisModelId), new QFilter(KEY_ORG, "in", orgIds), new QFilter(KEY_PERIOD, "in", periodIds), new QFilter(KEY_IS_OPEN, "=", (Object)false)};
        String selectProperties = "id, choseorg, period";
        Map closeRecords = BusinessDataServiceHelper.loadFromCache((String)FORMID_PERIOD_CTRL, (String)selectProperties, (QFilter[])qFilters);
        log.info("MACC.FAF: \u9009\u5b9a\u7ec4\u7ec7\u548c\u671f\u95f4\u7684\u7ec4\u5408\u5904\u4e8e\u5173\u95ed\u72b6\u6001\u7684\u8bb0\u5f55\u4e2a\u6570\u4e3a\uff1a" + closeRecords.size());
        if (closeRecords.size() <= 0 && isCheckAfter && (firstDate = PeriodServiceHelper.getFirstDate(analysisModelId, periodIds)) != null) {
            ArrayList<QFilter> arrayList = new ArrayList<QFilter>();
            arrayList.add(new QFilter(KEY_ANALYSIS_MODEL, "=", (Object)analysisModelId));
            arrayList.add(new QFilter(KEY_ORG, "in", orgIds));
            arrayList.add(new QFilter(KEY_IS_OPEN, "=", (Object)false));
            arrayList.add(new QFilter(KEY_START_DATE, ">=", firstDate));
            closeRecords = BusinessDataServiceHelper.loadFromCache((String)FORMID_PERIOD_CTRL, (String)selectProperties, (QFilter[])arrayList.toArray(new QFilter[0]));
        }
        if (closeRecords.size() > 0) {
            log.info("MACC.FAF: \u5b58\u5728\u9700\u8981\u5173\u95ed\u7684\u671f\u95f4\uff0c\u6570\u91cf\u4e3a\uff1a" + closeRecords.size());
            pr.setSuccess(false);
            for (Map.Entry entry : closeRecords.entrySet()) {
                Object id = entry.getKey();
                DynamicObject obj = (DynamicObject)entry.getValue();
                RecordItem resultItem = new RecordItem();
                resultItem.setId(id);
                resultItem.setOrgId(obj.getLong(ORG_ID));
                resultItem.setPeriodId(obj.getLong(PERIOD_ID));
                resultItem.setOpenStatus(false);
                pr.getCloseItems().add(resultItem);
            }
        }
        String result = SerializationUtils.toJsonString((Object)pr);
        log.info("MACC.FAF: batchCheckPeriod\uff0c\u68c0\u6d4b\u7ed3\u679c\u4e3a\uff1a" + result);
        return result;
    }

    public static Boolean checkPeriodOrgList(long analysisModelId, List<Long> orgIds, List<Long> periodIds, boolean isCheckAfter) {
        log.info("MACC.FAF: \u5f00\u59cb\u671f\u95f4\u72b6\u6001\u68c0\u6d4b. Method: checkPeriodOrgList");
        if (ObjectUtils.isEmpty(periodIds)) {
            log.info("ACC.FAF: Method: batchCreateCtrlRecord, Args: periodIds is empty");
            return false;
        }
        Object obj = PeriodServiceHelper.batchCheckPeriod(analysisModelId, orgIds, periodIds, isCheckAfter);
        if (obj != null) {
            PeriodCtrlResult pr = (PeriodCtrlResult)SerializationUtils.fromJsonString((String)obj.toString(), PeriodCtrlResult.class);
            return pr.isSuccess();
        }
        log.error("MACC.FAF:checkPeriodOrgList\u8fd4\u56de\u7a7a\u503c");
        return false;
    }

    public static Object batchCheckPeriodByPair(long analysisModelId, List<Map<Long, Long>> listMap, boolean isCheckAfter) {
        log.info("MACC.FAF: \u5f00\u59cb\u671f\u95f4\u72b6\u6001\u68c0\u6d4b. Method: batchCheckPeriodByPair");
        if (ObjectUtils.isEmpty(listMap)) {
            log.info("ACC.FAF: Method: batchCreateCtrlRecord, Args: listMap is empty");
            return null;
        }
        Objects.requireNonNull(listMap);
        ServiceResult result = new ServiceResult(ResultCodeEnum.SUCCESS);
        PeriodCtrlResult pr = new PeriodCtrlResult();
        pr.setAnalysisModelId(analysisModelId);
        QFilter orgAndPeriod = null;
        for (Map<Long, Long> mp : listMap) {
            Map.Entry pair = (Map.Entry)mp.entrySet().stream().findFirst().get();
            QFilter q = new QFilter(KEY_ORG, "=", pair.getKey());
            q.and(KEY_PERIOD, "=", pair.getValue());
            if (orgAndPeriod == null) {
                orgAndPeriod = q;
                continue;
            }
            orgAndPeriod.or(q);
        }
        QFilter[] qFilters = new QFilter[]{new QFilter(KEY_ANALYSIS_MODEL, "=", (Object)analysisModelId), new QFilter(KEY_IS_OPEN, "=", (Object)false), orgAndPeriod};
        String selectProperties = "id, choseorg, period";
        Map closeRecords = BusinessDataServiceHelper.loadFromCache((String)FORMID_PERIOD_CTRL, (String)selectProperties, (QFilter[])qFilters);
        log.info("MACC.FAF: \u9009\u5b9a\u7ec4\u7ec7\u548c\u671f\u95f4\u7684\u7ec4\u5408\u5904\u4e8e\u5173\u95ed\u72b6\u6001\u7684\u8bb0\u5f55\u4e2a\u6570\u4e3a\uff1a" + closeRecords.size());
        if (closeRecords.size() <= 0 && isCheckAfter) {
            List orgIds = listMap.stream().map(p -> (Long)p.keySet().stream().findAny().get()).distinct().collect(Collectors.toList());
            List<Long> periods = listMap.stream().map(p -> (Long)p.values().stream().findAny().get()).distinct().collect(Collectors.toList());
            Date firstDate = PeriodServiceHelper.getFirstDate(analysisModelId, periods);
            if (firstDate != null) {
                ArrayList<QFilter> largeFilters = new ArrayList<QFilter>();
                largeFilters.add(new QFilter(KEY_ANALYSIS_MODEL, "=", (Object)analysisModelId));
                largeFilters.add(new QFilter(KEY_ORG, "in", orgIds));
                largeFilters.add(new QFilter(KEY_IS_OPEN, "=", (Object)false));
                largeFilters.add(new QFilter(KEY_START_DATE, ">=", (Object)firstDate));
                closeRecords = BusinessDataServiceHelper.loadFromCache((String)FORMID_PERIOD_CTRL, (String)selectProperties, (QFilter[])largeFilters.toArray(new QFilter[0]));
            }
        }
        if (closeRecords.size() > 0) {
            pr.setSuccess(false);
            for (Map.Entry entry : closeRecords.entrySet()) {
                Object id = entry.getKey();
                DynamicObject obj = (DynamicObject)entry.getValue();
                RecordItem resultItem = new RecordItem();
                resultItem.setId(id);
                resultItem.setOrgId(obj.getLong(ORG_ID));
                resultItem.setPeriodId(obj.getLong(PERIOD_ID));
                resultItem.setOpenStatus(false);
                pr.getCloseItems().add(resultItem);
            }
        }
        result.setData((Object)SerializationUtils.toJsonString((Object)pr));
        log.info("MACC.FAF: batchCheckPeriodByPair\uff0c\u68c0\u6d4b\u7ed3\u679c\u4e3a\uff1a" + result.getData());
        return result.getData();
    }

    public static Object createCtrlRecord(long analysisSystemId, long analysisModelId, long orgId, long periodId, String periodFormId) {
        log.info("MACC.FAF: \u521b\u5efa\u671f\u95f4\u7ba1\u7406\u8bb0\u5f55. Method: createCtrlRecord");
        if (ObjectUtils.isEmpty((Object)periodFormId)) {
            log.info("ACC.FAF: Method: batchCreateCtrlRecord, Args: periodFormId is empty");
            return null;
        }
        ServiceResult result = new ServiceResult(ResultCodeEnum.SUCCESS);
        QFilter[] qFilters = new QFilter[]{new QFilter(KEY_ANALYSIS_MODEL, "=", (Object)analysisModelId), new QFilter(KEY_ORG, "=", (Object)orgId), new QFilter(KEY_PERIOD, "=", (Object)periodId)};
        DynamicObject curObj = BusinessDataServiceHelper.loadSingleFromCache((String)FORMID_PERIOD_CTRL, (QFilter[])qFilters);
        if (curObj == null) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)FORMID_PERIOD_CTRL);
            DynamicObject dynaObj = PeriodServiceHelper.buildNewRecord(analysisSystemId, analysisModelId, orgId, periodId, periodFormId, "1");
            if (dynaObj != null) {
                Object[] pk = SaveServiceHelper.save((IDataEntityType)dt, (Object[])new DynamicObject[]{dynaObj});
                result.setData(pk[0]);
            }
        } else {
            result.setData(curObj.getPkValue());
        }
        return result.getData();
    }

    public static Object[] batchCreateCtrlRecord(long analysisSystemId, long analysisModelId, List<Map<Long, Long>> listPair, String periodFormId) {
        return PeriodServiceHelper.batchCreateCtrlRecord(analysisSystemId, analysisModelId, listPair, periodFormId, "1");
    }

    public static Object[] batchCreateCtrlRecord(long analysisSystemId, long analysisModelId, List<Map<Long, Long>> listPair, String periodFormId, String status) {
        log.info("MACC.FAF: \u6279\u91cf\u521b\u5efa\u671f\u95f4\u7ba1\u7406\u8bb0\u5f55. Method: batchCreateCtrlRecord");
        if (ObjectUtils.isEmpty(listPair)) {
            log.info("ACC.FAF: Method: batchCreateCtrlRecord, Args: listPair is empty");
            return null;
        }
        if (ObjectUtils.isEmpty((Object)status)) {
            log.info("ACC.FAF: Method: batchCreateCtrlRecord, Args: status is empty");
            return null;
        }
        if (ObjectUtils.isEmpty((Object)periodFormId)) {
            log.info("ACC.FAF: Method: batchCreateCtrlRecord, Args: periodFormId is empty");
            return null;
        }
        ServiceResult result = new ServiceResult(ResultCodeEnum.SUCCESS);
        ArrayList<String> keyValue = new ArrayList<String>(listPair.size());
        ArrayList<Object> ids = new ArrayList<Object>(100);
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(100);
        for (Map<Long, Long> mp : listPair) {
            Map.Entry pair = (Map.Entry)mp.entrySet().stream().findFirst().get();
            Long orgId = (Long)pair.getKey();
            Long periodId = (Long)pair.getValue();
            if (keyValue.contains(orgId + "_" + periodId)) continue;
            keyValue.add(orgId + "_" + periodId);
            if (!PeriodServiceHelper.validateSinglePeriod(analysisModelId, periodId, periodFormId)) {
                log.info("\u671f\u95f4\u7ba1\u7406: \u671f\u95f4ID\u4e0d\u7b26\u5408-" + periodFormId + "-" + periodId);
                continue;
            }
            QFilter[] qFilters = new QFilter[]{new QFilter(KEY_ORG, "=", (Object)orgId), new QFilter(KEY_PERIOD, "=", (Object)periodId), new QFilter(KEY_PERIOD_TYPE, "=", (Object)periodFormId), new QFilter(KEY_ANALYSIS_MODEL, "=", (Object)analysisModelId)};
            DynamicObject existRecord = BusinessDataServiceHelper.loadSingleFromCache((String)FORMID_PERIOD_CTRL, (QFilter[])qFilters);
            if (existRecord != null) {
                ids.add(existRecord.getPkValue());
                continue;
            }
            DynamicObject newObject = PeriodServiceHelper.buildNewRecord(analysisSystemId, analysisModelId, orgId, periodId, periodFormId, status);
            if (newObject == null) continue;
            objs.add(newObject);
        }
        if (objs.size() > 0) {
            DynamicObject[] arr = objs.toArray(new DynamicObject[0]);
            Object[] newIDs = SaveServiceHelper.save((DynamicObject[])arr);
            ids.add(newIDs);
        }
        Object[] dataArr = ids.toArray(new Object[0]);
        result.setData((Object)dataArr);
        return (Object[])result.getData();
    }

    public static PeriodCtrlResult checkPeriodOrgTuple(long analysisModelId, List<Map<Long, Long>> listMap, boolean isCheckAfter) {
        log.info("MACC.FAF: \u68c0\u6d4b\u671f\u95f4\u7ba1\u7406\u8bb0\u5f55\u662f\u5426\u4e3a\u5173\u95ed\u72b6\u6001. Method: checkPeriodOrgTuple");
        if (ObjectUtils.isEmpty(listMap)) {
            log.info("ACC.FAF: Method: batchCreateCtrlRecord, Args: listMap is empty");
            return null;
        }
        Object obj = PeriodServiceHelper.batchCheckPeriodByPair(analysisModelId, listMap, isCheckAfter);
        PeriodCtrlResult data = null;
        if (obj != null) {
            data = (PeriodCtrlResult)SerializationUtils.fromJsonString((String)obj.toString(), PeriodCtrlResult.class);
        }
        return data;
    }

    public static Object[] batchCreateCtrlRecord(long analysisSystemId, long analysisModelId, List<Long> orgIds, List<Long> periodIds, String periodFormId) {
        log.info("MACC.FAF: \u6279\u91cf\u521b\u5efa\u671f\u95f4\u7ba1\u7406\u8bb0\u5f55. Method: batchCreateCtrlRecord");
        if (ObjectUtils.isEmpty(orgIds)) {
            log.info("ACC.FAF: Method: batchCreateCtrlRecord, Args: org is empty");
            return null;
        }
        if (ObjectUtils.isEmpty(periodIds)) {
            log.info("ACC.FAF: Method: batchCreateCtrlRecord, Args: periods is empty");
            return null;
        }
        if (ObjectUtils.isEmpty((Object)periodFormId)) {
            log.info("ACC.FAF: Method: batchCreateCtrlRecord, Args: periodFormId is empty");
            return null;
        }
        ServiceResult result = new ServiceResult(ResultCodeEnum.SUCCESS);
        List<Object> filterPeriodIds = PeriodServiceHelper.getNormalPeriod(analysisModelId, periodIds, periodFormId);
        if (filterPeriodIds == null || filterPeriodIds.isEmpty()) {
            log.info("\u671f\u95f4\u7ba1\u7406\u670d\u52a1: \u6240\u6709\u671f\u95f4\u90fd\u4e0d\u7b26\u5408\u3002");
            return null;
        }
        ArrayList<String> keyValue = new ArrayList<String>(orgIds.size());
        QFilter[] qFilters = new QFilter[]{new QFilter(KEY_ORG, "in", orgIds), new QFilter(KEY_PERIOD, "in", filterPeriodIds), new QFilter(KEY_PERIOD_TYPE, "=", (Object)periodFormId), new QFilter(KEY_ANALYSIS_MODEL, "=", (Object)analysisModelId)};
        Map existRecords = BusinessDataServiceHelper.loadFromCache((String)FORMID_PERIOD_CTRL, (QFilter[])qFilters);
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>();
        for (Long orgId : orgIds) {
            for (Object periodId : filterPeriodIds) {
                DynamicObject newObject;
                if (keyValue.contains(orgId + "_" + periodId)) continue;
                keyValue.add(orgId + "_" + periodId);
                boolean present = existRecords.values().stream().filter(o -> orgId.equals(o.getLong(ORG_ID)) && periodId.equals(o.getLong(PERIOD_ID))).findAny().isPresent();
                if (present || (newObject = PeriodServiceHelper.buildNewRecord(analysisSystemId, analysisModelId, orgId, periodId, periodFormId, "1")) == null) continue;
                objs.add(newObject);
            }
        }
        DynamicObject[] arr = objs.toArray(new DynamicObject[0]);
        Object[] ids = SaveServiceHelper.save((DynamicObject[])arr);
        result.setData((Object)ids);
        log.info("MACC.FAF: \u5b8c\u6210\u6279\u91cf\u521b\u5efa\u671f\u95f4\u7ba1\u7406\u8bb0\u5f55. Method: batchCreateCtrlRecord\uff0c size-" + ids.length);
        return (Object[])result.getData();
    }

    private static List<Object> getNormalPeriod(Object modelId, List<Long> periodIds, String periodFormId) {
        log.info("MACC.FAF: \u8fc7\u6ee4\u671f\u95f4\u5185\u975e\u81ea\u7136\u6708\u7684\u671f\u95f4. Method: getNormalPeriod");
        QFilter[] qFilters = new QFilter[2];
        QFilter filter = null;
        if (FORMID_ANALYSIS_PERIOD.equals(periodFormId)) {
            filter = new QFilter("isleaf", "=", (Object)true);
            filter.and("isadjust", "=", (Object)false);
        } else if (FORMID_BD_PERIOD.equals(periodFormId)) {
            String f1 = "id, periodtype";
            DynamicObject curObj = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel", (String)f1);
            DynamicObject periodTypeObj = curObj.getDynamicObject(KEY_PERIOD_TYPE);
            if (curObj != null && periodTypeObj != null) {
                filter = new QFilter(KEY_PERIOD_TYPE, "=", periodTypeObj.getPkValue());
                filter.and("isadjustperiod", "=", (Object)false);
            }
        } else {
            return new ArrayList<Object>();
        }
        qFilters[0] = filter;
        qFilters[1] = new QFilter("id", "in", periodIds);
        List periodIdList = QueryServiceHelper.queryPrimaryKeys((String)periodFormId, (QFilter[])qFilters, (String)"", (int)-1);
        return periodIdList;
    }

    private static boolean validateSinglePeriod(Object modelId, Object periodId, String periodFormId) {
        log.info("MACC.FAF: \u6821\u9a8c\u671f\u95f4\u662f\u5426\u7b26\u5408\u8981\u6c42. Method: validateSinglePeriod");
        QFilter[] qFilters = new QFilter[2];
        QFilter filter = null;
        if (FORMID_ANALYSIS_PERIOD.equals(periodFormId)) {
            filter = new QFilter("isleaf", "=", (Object)true);
            filter.and("isadjust", "=", (Object)false);
        } else if (FORMID_BD_PERIOD.equals(periodFormId)) {
            String f1 = "id, periodtype";
            DynamicObject curObj = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel", (String)f1);
            DynamicObject periodTypeObj = curObj.getDynamicObject(KEY_PERIOD_TYPE);
            if (curObj != null && periodTypeObj != null) {
                filter = new QFilter(KEY_PERIOD_TYPE, "=", periodTypeObj.getPkValue());
                filter.and("isadjustperiod", "=", (Object)false);
            }
        } else {
            return false;
        }
        qFilters[0] = filter;
        qFilters[1] = new QFilter("id", "=", periodId);
        boolean result = QueryServiceHelper.exists((String)periodFormId, (QFilter[])qFilters);
        return result;
    }

    private static boolean canOpenPeriod(long analysisModelId, long orgId, Date endDate) {
        ORM orm = ORM.create();
        QFilter[] qFilters = new QFilter[5];
        qFilters[0] = new QFilter(KEY_ANALYSIS_MODEL, "=", (Object)analysisModelId);
        qFilters[1] = new QFilter(KEY_IS_OPEN, "=", (Object)false);
        qFilters[2] = new QFilter(KEY_ORG, "=", (Object)orgId);
        qFilters[4] = new QFilter(KEY_START_DATE, ">", (Object)endDate);
        int count = orm.count(PeriodServiceHelper.class.getName() + ".canOpenPeriod", FORMID_PERIOD_CTRL, qFilters);
        return count <= 0;
    }

    private static boolean canClosePeriod(long analysisModelId, long orgId, Date startDate) {
        ORM orm = ORM.create();
        QFilter[] qFilters = new QFilter[]{new QFilter(KEY_ANALYSIS_MODEL, "=", (Object)analysisModelId), new QFilter(KEY_IS_OPEN, "=", (Object)true), new QFilter(KEY_ORG, "=", (Object)orgId), new QFilter(KEY_END_DATE, "<", (Object)startDate)};
        int count = orm.count(PeriodServiceHelper.class.getName() + ".canClosePeriod", FORMID_PERIOD_CTRL, qFilters);
        return count <= 0;
    }

    private static void fixPeriod(long analysisSystemId, long analysisModelId, long orgId, String periodFormId, Date currentStartDate) {
        log.info("MACC.FAF: \u8865\u9f50\u671f\u95f4. Method: fixPeriod");
        QFilter[] qFilters0 = new QFilter[]{new QFilter(KEY_ANALYSIS_MODEL, "=", (Object)analysisModelId), new QFilter(KEY_ORG, "=", (Object)orgId), new QFilter(KEY_PERIOD_TYPE, "=", (Object)periodFormId)};
        Date startDate = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(PeriodServiceHelper.class.getName() + ".fixPeriod"), (String)FORMID_PERIOD_CTRL, (String)KEY_START_DATE, (QFilter[])qFilters0, (String)"");){
            GroupbyDataSet gpds = ds.groupBy().min(KEY_START_DATE);
            DataSet finish = gpds.finish();
            while (finish.hasNext()) {
                Row next = finish.next();
                startDate = next.getDate(KEY_START_DATE);
            }
        }
        if (startDate == null) {
            log.error("MACC.FAF: \u8865\u5145\u7f3a\u5931\u671f\u95f4\u9501\u5b9a\u63a7\u5236\u8bb0\u5f55\u65f6, \u8d77\u59cb\u65e5\u671f\u4e3a\u7a7a");
            return;
        }
        if (startDate.compareTo(currentStartDate) >= 0) {
            log.info("MACC.FAF: \u4e0d\u9700\u8981\u8865\u6570\u636e");
            return;
        }
        QFilter[] qFilters = new QFilter[3];
        qFilters[0] = new QFilter(KEY_END_DATE, ">", (Object)startDate);
        qFilters[1] = new QFilter(KEY_END_DATE, "<", (Object)currentStartDate);
        QFilter otherFilter = null;
        if (FORMID_ANALYSIS_PERIOD.equals(periodFormId)) {
            otherFilter = new QFilter("isleaf", "=", (Object)true);
            otherFilter.and("isadjust", "=", (Object)false);
        } else {
            String f1 = "id, periodtype";
            DynamicObject curObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel", (String)f1);
            DynamicObject periodTypeObj = curObj.getDynamicObject(KEY_PERIOD_TYPE);
            if (curObj != null && periodTypeObj != null) {
                otherFilter = new QFilter(KEY_PERIOD_TYPE, "=", periodTypeObj.getPkValue());
                otherFilter.and("isadjustperiod", "=", (Object)false);
            }
        }
        qFilters[2] = otherFilter;
        String selectProperties = "id, enddate";
        Map periodMaps = BusinessDataServiceHelper.loadFromCache((String)periodFormId, (String)selectProperties, (QFilter[])qFilters, (String)"enddate asc");
        if (periodMaps != null && periodMaps.size() > 0) {
            QFilter[] existFilters = new QFilter[]{new QFilter(KEY_ANALYSIS_MODEL, "=", (Object)analysisModelId), new QFilter(KEY_ORG, "=", (Object)orgId)};
            String selectProp = "id, enddate, period";
            Map existRecords = BusinessDataServiceHelper.loadFromCache((String)FORMID_PERIOD_CTRL, (String)selectProp, (QFilter[])existFilters, (String)"enddate asc");
            Set existPeriodIds = existRecords.values().stream().map(p -> p.getLong(PERIOD_ID)).collect(Collectors.toSet());
            HashSet<Long> missPeriod = new HashSet<Long>(periodMaps.size());
            ArrayList<DynamicObject> missObjs = new ArrayList<DynamicObject>(8);
            for (Object id : periodMaps.keySet()) {
                Long lid = Long.valueOf(String.valueOf(id));
                if (existPeriodIds.contains(lid)) continue;
                missPeriod.add(lid);
                DynamicObject newObj = PeriodServiceHelper.buildNewRecord(analysisSystemId, analysisModelId, orgId, id, periodFormId, "0");
                if (newObj == null) continue;
                missObjs.add(newObj);
            }
            log.info("MACC.FAF: \u786e\u5b9e\u671f\u95f4ID\u4e3a: " + StringUtils.join((Object[])new Object[]{Character.valueOf(','), missPeriod}));
            if (missObjs.size() > 0) {
                DynamicObject[] arr = missObjs.toArray(new DynamicObject[0]);
                final Object[] ids = SaveServiceHelper.save((DynamicObject[])arr);
                if (!ObjectUtils.isEmpty((Object[])ids)) {
                    Long lastPeriod = (Long)existPeriodIds.stream().skip(existPeriodIds.size() - 1).findFirst().get();
                    missPeriod.add(lastPeriod);
                    Set<Long> orgSet = Stream.of(Long.valueOf(orgId)).collect(Collectors.toSet());
                    log.info("MACC.FAF: \u8c03\u7528FAFFetchDataScheduleServiceHelper,\u5f00\u59cb\u8865\u6570\u636e");
                    FAFFetchDataScheduleServiceHelper.createCal(analysisModelId, orgSet, periodFormId, missPeriod, new IExceptionListener(){

                        public boolean onError(Throwable ex) {
                            log.info("MACC.FAF: \u8865\u6570\u636e\u51fa\u73b0\u5f02\u5e38-onError, \u5220\u9664\u6389\u5df2\u521b\u5efa\u7684\u671f\u95f4\u7ba1\u7406\u8bb0\u5f55, ids:  " + StringUtils.join((Object[])new Serializable[]{Character.valueOf(','), ids}));
                            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)PeriodServiceHelper.FORMID_PERIOD_CTRL);
                            try {
                                DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])ids);
                            }
                            catch (Exception e) {
                                log.info("MACC.FAF: \u8865\u6570\u636e\u51fa\u73b0\u5f02\u5e38-onError, \u5220\u9664\u8bb0\u5f55\u51fa\u73b0\u5f02\u5e38, message\uff1a " + e.getMessage());
                            }
                            return false;
                        }
                    });
                } else {
                    log.info("MACC.FAF:  \u521b\u5efa\u7f3a\u5931\u671f\u95f4ID\u5931\u8d25 ");
                }
            }
        }
    }

    private static DynamicObject buildNewRecord(long analysisSystemId, Object analysisModelId, long orgId, Object periodId, String periodFormId, String openStatus) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)FORMID_PERIOD_CTRL);
        DynamicObject dynaObj = new DynamicObject((DynamicObjectType)dt);
        long id = DB.genLongId((String)dt.getAlias());
        long timeMill = System.currentTimeMillis();
        dynaObj.set("id", (Object)id);
        dynaObj.set("number", (Object)timeMill);
        dynaObj.set("name", (Object)String.format(ResManager.loadKDString((String)"%s", (String)"PeriodServiceHelper_1", (String)"macc-faf-business", (Object[])new Object[0]), timeMill));
        dynaObj.set("status", (Object)"C");
        dynaObj.set("masterid", (Object)id);
        dynaObj.set(KEY_ORG, (Object)orgId);
        dynaObj.set(KEY_ANALYSIS_SYSTEM, (Object)analysisSystemId);
        dynaObj.set(KEY_ANALYSIS_MODEL, analysisModelId);
        dynaObj.set(KEY_PERIOD_TYPE, (Object)periodFormId);
        dynaObj.set(KEY_PERIOD, periodId);
        StringBuilder sb = new StringBuilder();
        String beginDateFiled = FORMID_ANALYSIS_PERIOD.equals(periodFormId) ? KEY_START_DATE : "begindate";
        sb.append("id").append(",").append(beginDateFiled).append(",").append(KEY_END_DATE);
        DynamicObject periodObj = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)periodFormId, (String)sb.toString());
        if (periodObj == null) {
            return null;
        }
        dynaObj.set(KEY_START_DATE, (Object)periodObj.getDate(beginDateFiled));
        dynaObj.set(KEY_END_DATE, (Object)periodObj.getDate(KEY_END_DATE));
        dynaObj.set(KEY_MODIFY_TIME, (Object)new Date());
        dynaObj.set(KEY_MODIFIER, (Object)RequestContext.get().getCurrUserId());
        dynaObj.set(KEY_CREATE_TIME, (Object)new Date());
        dynaObj.set(KEY_CREATOR, (Object)RequestContext.get().getCurrUserId());
        dynaObj.set(KEY_IS_OPEN, (Object)openStatus);
        return dynaObj;
    }

    private static Date getFirstDate(long analysisModelId, List<Long> periodIds) {
        Date firstDate = null;
        String periodFormId = PeriodServiceHelper.getPeriodFormId(analysisModelId);
        List<Object> filterObjs = PeriodServiceHelper.getNormalPeriod(analysisModelId, periodIds, periodFormId);
        if (filterObjs != null && filterObjs.size() > 0) {
            String beginDateFiled = FORMID_ANALYSIS_PERIOD.equals(periodFormId) ? KEY_START_DATE : "begindate";
            StringBuilder sb = new StringBuilder();
            sb.append("id").append(",").append(beginDateFiled);
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", filterObjs)};
            String algoKey = "kd.macc.faf.service.PeriodServiceHelper.getFirstDate";
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)periodFormId, (String)sb.toString(), (QFilter[])filters, (String)"", (int)-1);){
                for (Row row : ds) {
                    Date currDate = row.getDate(beginDateFiled);
                    if (currDate == null) continue;
                    if (firstDate == null) {
                        firstDate = currDate;
                        continue;
                    }
                    if (!currDate.before(firstDate)) continue;
                    firstDate = currDate;
                }
            }
        } else {
            log.info("MACC.FAF: \u6ca1\u6709\u5408\u9002\u7684\u671f\u95f4, \u671f\u95f4formid: " + periodFormId);
        }
        if (firstDate != null) {
            log.info("MACC.FAF: \u9009\u5b9a\u7ec4\u7ec7\u548c\u671f\u95f4\u7684\u7ec4\u5408\u5904\u4e8e\u5173\u95ed\u72b6\u6001\u7684\u8bb0\u5f55\u7684\u6700\u65e9\u8d77\u59cb\u65f6\u95f4\u4e3a\uff1a" + firstDate);
        } else {
            log.info("MACC.FAF: \u9009\u5b9a\u7ec4\u7ec7\u548c\u671f\u95f4\u7684\u7ec4\u5408\u5904\u4e8e\u5173\u95ed\u72b6\u6001\u7684\u8bb0\u5f55\u7684\u6700\u65e9\u8d77\u59cb\u65f6\u95f4\u4e3a\u7a7a.");
        }
        return firstDate;
    }

    private static String getPeriodFormId(long analysisModelId) {
        String periodFormId = "";
        DynamicObject modelObj = BusinessDataServiceHelper.loadSingle((Object)analysisModelId, (String)"pa_analysismodel");
        FAFAnalysisModelModel modelModel = new FAFAnalysisModelModel();
        try {
            modelModel.loadFromDynamicObject(modelObj, true);
        }
        catch (Exception ex) {
            log.info("MACC.FAF: getPeriodFormId, loadFromDynamicObject--- " + ex.getMessage());
        }
        if (modelModel.getPeriodDim().getDataType() == DimensionTypeEnum.PERIOD) {
            periodFormId = FORMID_ANALYSIS_PERIOD;
        } else if (modelModel.getPeriodDim().getDataType() == DimensionTypeEnum.DATABASE) {
            periodFormId = FORMID_BD_PERIOD;
        } else {
            log.info("MACC.FAF: getPeriodFormId, \u671f\u95f4\u7c7b\u578b\u4e0d\u6b63\u786e-" + modelModel.getPeriodDim().getDataType());
        }
        log.info("MACC.FAF: getPeriodFormId, \u671f\u95f4\u7c7b\u578b-" + periodFormId);
        return periodFormId;
    }
}

