/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.summary;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.db.DB;
import kd.macc.faf.algox.FAFIntegerEntry;
import kd.macc.faf.summary.FAFBdPeriodInfo;
import kd.macc.faf.summary.FAFSummaryCalculateDTO;
import kd.macc.faf.summary.SortComparator;
import org.jetbrains.annotations.NotNull;

public class FAFSummaryCalculateGroupReduceFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private final RowMeta rowMeta;
    private final int orderIndex;
    private final int groupIndex;
    private final int quarterIndex;
    private final int periodIndex;
    private final int summaryIdIndex;
    private final int measureStartIndex;
    private final int measureEndIndex;
    private final int calculateStartIndex;
    private final List<FAFIntegerEntry> calculateList;
    private final Map<Integer, Integer> refPropIndexMap;
    private final Map<String, FAFBdPeriodInfo> bdPeriodMap;
    private final Set<Object> periodSet;
    private final int count;
    private long[] longs;
    private int pos = 0;

    public FAFSummaryCalculateGroupReduceFunction(RowMeta rowMeta, RowMeta joinRowMeta, FAFSummaryCalculateDTO dto) {
        this.rowMeta = rowMeta;
        this.bdPeriodMap = dto.getBdPeriodMap();
        this.periodSet = this.bdPeriodMap.values().stream().map(FAFBdPeriodInfo::getPkValue).collect(Collectors.toSet());
        this.orderIndex = joinRowMeta.getFieldIndex(dto.getLink().getOrderField());
        this.groupIndex = joinRowMeta.getFieldIndex(dto.getLink().prefix("periodyear"));
        this.quarterIndex = joinRowMeta.getFieldIndex(dto.getLink().prefix("periodquarter"));
        this.periodIndex = joinRowMeta.getFieldIndex(dto.getLink().getLeftField());
        this.summaryIdIndex = joinRowMeta.getFieldIndex("summaryid");
        this.measureStartIndex = dto.getFields().size() - dto.getMeasureFields().size();
        this.measureEndIndex = dto.getFields().size() - 1;
        List<String> calculateMeasures = dto.getCalculateMeasures();
        this.calculateStartIndex = dto.getCalculateStartIndex();
        this.calculateList = new ArrayList<FAFIntegerEntry>(calculateMeasures.size());
        this.refPropIndexMap = new LinkedHashMap<Integer, Integer>(calculateMeasures.size());
        Map<String, String> linkMeasureMap = dto.getLinkMeasureMap();
        Map<String, String> refDimensionPropMap = dto.getRefDimensionPropMap();
        for (String calculateMName : calculateMeasures) {
            String linkMName = linkMeasureMap.get(calculateMName);
            int linkMeasureIndex = rowMeta.getFieldIndex(linkMName);
            int calculateMeasureIndex = rowMeta.getFieldIndex(calculateMName);
            this.calculateList.add(new FAFIntegerEntry(calculateMeasureIndex, linkMeasureIndex));
            String fieldName = refDimensionPropMap.get(calculateMName);
            int refDimensionPropIndex = joinRowMeta.getFieldIndex(dto.getLink().prefix(fieldName));
            this.refPropIndexMap.put(calculateMeasureIndex, refDimensionPropIndex);
        }
        this.count = this.bdPeriodMap.size();
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        List<RowX> dataList = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterable.iterator(), 4), false).collect(Collectors.toList());
        Set dataMap = dataList.stream().map(row -> {
            Integer group = row.getInteger(this.groupIndex);
            Integer order = row.getInteger(this.orderIndex);
            return group + "_" + order;
        }).collect(Collectors.toSet());
        SortComparator sortComparator = new SortComparator(this.orderIndex);
        dataList.sort(sortComparator);
        RowX firstRow = (RowX)dataList.get(0);
        Integer periodyear = firstRow.getInteger(this.groupIndex);
        Set<Map.Entry<String, FAFBdPeriodInfo>> entries = this.bdPeriodMap.entrySet();
        List collect = entries.stream().filter(entry -> {
            Integer year = ((FAFBdPeriodInfo)entry.getValue()).getPeriodyear();
            return Objects.equals(periodyear, year);
        }).collect(Collectors.toList());
        for (Map.Entry entry2 : collect) {
            if (dataMap.contains(entry2.getKey()) || ((FAFBdPeriodInfo)entry2.getValue()).getPeriodnumber() <= firstRow.getInteger(this.orderIndex)) continue;
            RowX fillRow = this.builFillRow(firstRow, entry2);
            dataList.add(fillRow);
        }
        dataList.sort(sortComparator);
        this.calc(collector, dataList);
    }

    @NotNull
    private RowX builFillRow(RowX firstRow, Map.Entry<String, FAFBdPeriodInfo> entry) {
        RowX copy = firstRow.copy();
        copy.set(0, this.getId());
        FAFBdPeriodInfo periodInfo = entry.getValue();
        copy.set(this.periodIndex, (Object)periodInfo.getPkValue());
        for (int pos = this.measureStartIndex; pos <= this.measureEndIndex; ++pos) {
            copy.set(pos, (Object)BigDecimal.ZERO);
        }
        copy.set(this.rowMeta.getFieldCount() - 1, (Object)1L);
        copy.set(this.groupIndex, (Object)periodInfo.getPeriodyear());
        copy.set(this.quarterIndex, (Object)periodInfo.getPeriodquarter());
        copy.set(this.orderIndex, (Object)periodInfo.getPeriodnumber());
        copy.set(this.summaryIdIndex, (Object)1L);
        return copy;
    }

    private Object getId() {
        if (this.longs == null || this.pos >= this.count) {
            this.longs = DB.genGlobalLongIds((int)this.count);
            this.pos = 0;
        }
        return this.longs[this.pos++];
    }

    private void calc(Collector collector, List<RowX> sortList) {
        RowX preRow = null;
        Object[] preRefProps = new Object[this.calculateList.size()];
        for (RowX posRow : sortList) {
            int startIndex;
            int pos;
            RowX newRowX = new RowX(this.rowMeta.getFieldCount());
            for (pos = 0; pos < this.calculateStartIndex; ++pos) {
                newRowX.set(pos, posRow.get(pos));
            }
            for (pos = 0; pos < this.calculateList.size(); ++pos) {
                FAFIntegerEntry entry = this.calculateList.get(pos);
                if (entry == null) continue;
                Object refProp = posRow.get(this.refPropIndexMap.get(entry.getKey()).intValue());
                if (refProp != null && preRow != null && refProp.equals(preRefProps[pos])) {
                    BigDecimal preCalValue = preRow.getBigDecimal(entry.getKey().intValue());
                    BigDecimal linkValue = posRow.getBigDecimal(entry.getValue().intValue());
                    if (preCalValue == null) {
                        preCalValue = BigDecimal.ZERO;
                    }
                    if (linkValue == null) {
                        linkValue = BigDecimal.ZERO;
                    }
                    newRowX.set(entry.getKey().intValue(), (Object)preCalValue.add(linkValue));
                } else {
                    newRowX.set(entry.getKey().intValue(), posRow.get(entry.getValue().intValue()));
                }
                preRefProps[pos] = refProp;
            }
            for (int pos2 = startIndex = this.calculateStartIndex + this.calculateList.size(); pos2 < this.rowMeta.getFieldCount(); ++pos2) {
                newRowX.set(pos2, posRow.get(pos2));
            }
            preRow = newRowX;
            Object object = newRowX.get(this.periodIndex);
            if (!this.periodSet.contains(object)) continue;
            collector.collect(newRowX);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

