/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.summary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.macc.faf.algox.FAFExecuteDB;
import kd.macc.faf.algox.FAFJoinLinkInfo;
import kd.macc.faf.algox.FAFSQLBuilder;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.MeasureTypeEnum;
import kd.macc.faf.enums.OperationStatusEnum;
import kd.macc.faf.enums.TimeTypeEnum;
import kd.macc.faf.summary.FAFBdPeriodInfo;
import kd.macc.faf.summary.FAFSummaryCalculateDTO;
import kd.macc.faf.util.AnalysisModelHashUtil;
import kd.macc.faf.util.AnalysisModelUtil;

public class FAFSummaryDataDTO {
    private static final String ALGO_KEY = FAFSummaryDataDTO.class.getName();
    private final DynamicObject model;
    private final Object[] orgIds;
    private final Object[] periodIds;
    private final Object[] originalPeriodIds;
    private final boolean haveTime;
    private final String timeType;
    private final Date startDate;
    private final Date endDate;
    private final boolean incrementSummary;
    private List<String> fields;
    private List<String> fields_dimension;
    private List<String> fields_measure;
    private String entityName;
    private String detailEntityName;
    private String tableNumber;
    private String detailTableNumber;
    private String orgNumber;
    private String periodNumber;
    private Object periodtypeID;
    private Map<Object, DynamicObject> ordinaryMeasure;
    private List<DynamicObject> calculateMeasure;
    private Boolean executeCalculte = Boolean.TRUE;
    private boolean modelContainsDimHash = false;
    private List<String> modelHashDimensionNumberList;
    private int ormInputParallelism = 4;

    public FAFSummaryDataDTO(DynamicObject model, Object[] orgIds, Object[] periodIds, String timeType, Date startDate, Date endDate) {
        this(model, orgIds, periodIds, timeType, startDate, endDate, false);
    }

    public FAFSummaryDataDTO(DynamicObject model, Object[] orgIds, Object[] periodIds, String timeType, Date startDate, Date endDate, boolean incrementSummary) {
        this.model = model;
        this.parseModel();
        this.orgIds = orgIds != null ? orgIds : new Object[0];
        this.timeType = timeType;
        if (periodIds != null) {
            this.originalPeriodIds = periodIds;
            this.periodIds = this.processPeriods(periodIds);
        } else {
            this.originalPeriodIds = new Object[0];
            this.periodIds = new Object[0];
        }
        this.startDate = startDate;
        this.endDate = endDate;
        this.haveTime = EntityMetadataCache.getDataEntityType((String)this.entityName).getProperty("createtime") != null;
        this.incrementSummary = incrementSummary;
        this.modelHashDimensionNumberList = AnalysisModelHashUtil.queryModelHashDimension((DynamicObject)this.model);
    }

    public List<QFilter[]> getQFiltersList(Boolean original) {
        ArrayList<QFilter[]> qFilters = new ArrayList<QFilter[]>(32);
        QFilter timeQFilter = this.buildTimeQFilter(original);
        int size = this.orgIds.length / 30 + 1;
        ArrayList<Object> orgIdList = new ArrayList<Object>(size);
        for (Object orgId : this.orgIds) {
            if (orgIdList.size() >= size) {
                qFilters.add(new QFilter[]{new QFilter(this.orgNumber, "in", orgIdList), timeQFilter});
                orgIdList = new ArrayList(size);
            }
            orgIdList.add(orgId);
        }
        if (!orgIdList.isEmpty()) {
            qFilters.add(new QFilter[]{new QFilter(this.orgNumber, "in", orgIdList), timeQFilter});
        }
        return qFilters;
    }

    private QFilter buildTimeQFilter(Boolean original) {
        if (original == null) {
            if (this.periodIds != null && this.periodIds.length > 0) {
                return new QFilter(this.periodNumber, "in", (Object)this.periodIds);
            }
        } else if (original.booleanValue()) {
            if (this.originalPeriodIds != null && this.originalPeriodIds.length > 0) {
                return new QFilter(this.periodNumber, "in", (Object)this.originalPeriodIds);
            }
        } else {
            ArrayList<Object> periodList = new ArrayList<Object>(Arrays.asList(this.periodIds));
            periodList.removeAll(Arrays.asList(this.originalPeriodIds));
            if (CollectionUtils.isNotEmpty(periodList)) {
                return new QFilter(this.periodNumber, "in", periodList);
            }
        }
        return null;
    }

    public QFilter getOrgQFilter() {
        return new QFilter(this.orgNumber, "in", (Object)this.orgIds);
    }

    public Object[] getOrgQFilterIds() {
        return Arrays.copyOf(this.orgIds, this.orgIds.length);
    }

    public QFilter getPeriodQFilter(boolean isExpandPeriod, boolean isExcludeCurrentPeriod) {
        Object[] periodIdArray = this.getPeriodQFilterIds(isExpandPeriod, isExcludeCurrentPeriod);
        if (periodIdArray.length > 0) {
            return new QFilter(this.periodNumber, "in", (Object)periodIdArray);
        }
        if (TimeTypeEnum.PERIOD.getCode().equals(this.timeType)) {
            return new QFilter("1", "=", (Object)0);
        }
        return new QFilter("1", "=", (Object)1);
    }

    public Object[] getPeriodQFilterIds(boolean isExpandPeriod, boolean isExcludeCurrentPeriod) {
        ArrayList<Object> periodIdList = new ArrayList<Object>(16);
        if (isExpandPeriod) {
            periodIdList.addAll(Arrays.asList(this.periodIds));
            if (isExcludeCurrentPeriod) {
                periodIdList.removeAll(Arrays.asList(this.originalPeriodIds));
            }
        } else {
            periodIdList.addAll(Arrays.asList(this.originalPeriodIds));
        }
        return periodIdList.toArray(new Object[0]);
    }

    public QFilter getOrgPeriodQFilter(boolean isExpandPeriod) {
        return this.getOrgPeriodQFilter(isExpandPeriod, true);
    }

    public QFilter getOrgPeriodQFilter(boolean isExpandPeriod, boolean isExcludeCurrentPeriod) {
        QFilter orgQFilter = this.getOrgQFilter();
        QFilter periodQFilter = this.getPeriodQFilter(isExpandPeriod, isExcludeCurrentPeriod);
        return orgQFilter.and(periodQFilter);
    }

    public Boolean getExecuteCalculte() {
        return this.executeCalculte;
    }

    public void setExecuteCalculte(Boolean executeCalculte) {
        this.executeCalculte = executeCalculte;
    }

    private Object[] processPeriods(Object[] periodIds) {
        if (this.needCaculate()) {
            boolean year = false;
            boolean quarter = false;
            for (DynamicObject dynamicObject2 : this.calculateMeasure) {
                String dimensionattrnb = dynamicObject2.getString("dimensionattrnb");
                if (dimensionattrnb != null && dimensionattrnb.contains("periodquarter")) {
                    quarter = true;
                    continue;
                }
                if (dimensionattrnb == null || !dimensionattrnb.contains("periodyear")) continue;
                year = true;
            }
            Map bdPeriod = BusinessDataServiceHelper.loadFromCache((Object[])periodIds, (String)"bd_period");
            Long maxPeriodNumber = bdPeriod.values().stream().map(dynamicObject -> dynamicObject.getLong("periodnumber")).max(Long::compare).get();
            Set periodyear = bdPeriod.values().stream().map(dynamicObject -> dynamicObject.getInt("periodyear")).collect(Collectors.toSet());
            QFilter periodYearFilter = new QFilter("periodyear", "in", periodyear);
            QFilter orQfilter = null;
            if (year) {
                orQfilter = periodYearFilter;
            } else if (quarter) {
                Set periodquarter = bdPeriod.values().stream().map(dynamicObject -> dynamicObject.getInt("periodquarter")).collect(Collectors.toSet());
                orQfilter = periodYearFilter.and(new QFilter("periodquarter", "in", periodquarter));
            }
            QFilter qFilter = new QFilter("id", "in", (Object)periodIds).or(orQfilter).and("periodtype", "=", this.periodtypeID).and("isadjustperiod", "=", (Object)"0").and("periodnumber", "<=", (Object)maxPeriodNumber);
            Map newPeriod = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (QFilter[])qFilter.toArray());
            return newPeriod.values().stream().map(DataEntityBase::getPkValue).toArray();
        }
        return periodIds;
    }

    private void parseModel() {
        String tableSuffix = this.model.getString("tablenumber");
        this.entityName = AnalysisModelUtil.buildEntityNumber((String)tableSuffix);
        this.tableNumber = "t_" + this.entityName;
        this.detailEntityName = AnalysisModelUtil.buildDetailEntityNumber((String)tableSuffix);
        this.detailTableNumber = "t_" + this.detailEntityName;
        this.modelContainsDimHash = AnalysisModelHashUtil.isModelContainsDimHash((String)this.detailEntityName) && AnalysisModelHashUtil.isModelContainsDimHash((String)this.entityName);
        DynamicObjectCollection dEntry = this.model.getDynamicObjectCollection("dimension_entry");
        DynamicObjectCollection mEntry = this.model.getDynamicObjectCollection("measure_entry");
        this.fields = new ArrayList<String>(dEntry.size() + mEntry.size());
        this.fields.add("id");
        this.fields.add("operationstatus");
        this.fields.add("collectstatus");
        if (this.modelContainsDimHash) {
            this.fields.add("dimhash");
        }
        this.fields_dimension = new ArrayList<String>(dEntry.size());
        for (DynamicObject entry : dEntry) {
            DynamicObject dimension = entry.getDynamicObject("dimension");
            String number = dimension.getString("number");
            this.fields.add(number);
            this.fields_dimension.add(number);
            String necessity = entry.getString("necessity_dim");
            if (!StringUtils.isNotBlank((CharSequence)necessity)) continue;
            if (DimensionNecessityEnum.ORG.getCode().equals(necessity)) {
                this.orgNumber = number;
                continue;
            }
            if (!DimensionNecessityEnum.PERIOD.getCode().equals(necessity)) continue;
            this.periodNumber = number;
            this.periodtypeID = dimension.get("group_id");
        }
        this.fields_measure = new ArrayList<String>(mEntry.size());
        this.calculateMeasure = new ArrayList<DynamicObject>(mEntry.size());
        this.ordinaryMeasure = new LinkedHashMap<Object, DynamicObject>(mEntry.size());
        ArrayList<String> tempCalculatefields = new ArrayList<String>(2);
        for (DynamicObject entry : mEntry) {
            DynamicObject measure = entry.getDynamicObject("measure");
            String number = measure.getString("number");
            String measuretype = measure.getString("measuretype");
            if (String.valueOf(MeasureTypeEnum.CALCULATION.getCode()).equals(measuretype)) {
                if (!this.ableCalculate(measure)) continue;
                tempCalculatefields.add(number);
                this.calculateMeasure.add(measure);
                continue;
            }
            this.fields.add(number);
            this.fields_measure.add(number);
            this.ordinaryMeasure.put(measure.getPkValue(), measure);
        }
        this.fields.addAll(tempCalculatefields);
        this.fields_measure.addAll(tempCalculatefields);
    }

    private boolean ableCalculate(DynamicObject measure) {
        DynamicObject dimension = BusinessDataServiceHelper.loadSingleFromCache((Object)measure.getDynamicObject("dimension").getPkValue(), (String)"pa_dimension");
        String number = dimension.getString("number");
        return this.periodNumber.equals(number) && "bd_period".equals(dimension.getDynamicObject("dimensionsource").getPkValue());
    }

    public FAFSummaryCalculateDTO buildCalculateDTO() {
        int calculateStartIndex = this.fields.size() - this.calculateMeasure.size();
        FAFSummaryCalculateDTO dto = new FAFSummaryCalculateDTO(calculateStartIndex);
        dto.setFields(this.fields);
        dto.setDimensionFields(this.fields_dimension);
        dto.setMeasureFields(this.fields_measure);
        for (DynamicObject dynamicObject : this.calculateMeasure) {
            String dimensionNumber = dynamicObject.getString("dimension.number");
            if (!this.periodNumber.equals(dimensionNumber)) continue;
            String number = dynamicObject.getString("number");
            String dimensionattrnb = dynamicObject.getString("dimensionattrnb");
            Long dimensionId = dynamicObject.getLong("dimension.id");
            DynamicObject dimension = BusinessDataServiceHelper.loadSingle((Object)dimensionId, (String)"pa_dimension");
            if (!"bd_period".equals(dimension.getString("dimensionsource.number"))) continue;
            if (dimensionattrnb.contains("periodquarter")) {
                dto.addRefDimensionProp(number, "periodquarter");
            } else {
                if (!dimensionattrnb.contains("periodyear")) continue;
                dto.addRefDimensionProp(number, "periodyear");
            }
            dto.addCalculateMeasure(number);
            dto.addLinkMeasure(number, dynamicObject.getString("measure.number"));
        }
        dto.setLink(this.builLinkBDPeriod(this.periodNumber));
        dto.setBdPeriodMap(this.buildBDPeriodMap(this.originalPeriodIds));
        return dto;
    }

    private Map<String, FAFBdPeriodInfo> buildBDPeriodMap(Object[] originalPeriodIds) {
        QFilter filter = new QFilter("id", "in", (Object)originalPeriodIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"bd_period", (String)"id,periodyear,periodquarter,periodnumber", (QFilter[])filter.toArray(), (String)"periodyear desc,periodnumber desc");){
            Stream<Row> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(dataSet, 4), false);
            Map map = stream.collect(Collectors.toMap(row -> {
                Integer periodyear = row.getInteger("periodyear");
                Integer periodnumber = row.getInteger("periodnumber");
                return periodyear + "_" + periodnumber;
            }, row -> new FAFBdPeriodInfo(row.getLong("id"), row.getInteger("periodyear"), row.getInteger("periodquarter"), row.getInteger("periodnumber")), (a, a2) -> a, LinkedHashMap::new));
            return map;
        }
    }

    private FAFJoinLinkInfo builLinkBDPeriod(String dimensionNumber) {
        FAFJoinLinkInfo link = new FAFJoinLinkInfo();
        link.setLeftField(dimensionNumber);
        link.setRightField("id");
        link.setEntityName("bd_period");
        link.addLinkField("periodnumber", (DataType)DataType.IntegerType);
        link.addLinkField("periodyear", (DataType)DataType.IntegerType);
        link.addLinkField("periodquarter", (DataType)DataType.IntegerType);
        link.replaceGroupField("periodyear");
        link.orderField("periodnumber");
        link.setQfilter(new QFilter("id", "=", (Object)this.periodIds));
        link.setQfilter(new QFilter("periodtype", "=", this.periodtypeID));
        return link;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getDetailEntityName() {
        return this.detailEntityName;
    }

    public String getTableNumber() {
        return this.tableNumber;
    }

    public String getDetailTableNumber() {
        return this.detailTableNumber;
    }

    public String getOrgNumber() {
        return this.orgNumber;
    }

    public String getPeriodNumber() {
        return this.periodNumber;
    }

    public String getSelectFields() {
        return String.join((CharSequence)",", this.fields);
    }

    public String[] getFields_dimension() {
        return this.fields_dimension.toArray(new String[0]);
    }

    public Long getmodelId() {
        return (Long)this.model.getPkValue();
    }

    public List<String> getFields() {
        return this.fields;
    }

    public List<String> getOrdinaryMeasureNumbers() {
        return this.ordinaryMeasure.values().stream().map(dynamicObject -> dynamicObject.getString("number")).collect(Collectors.toList());
    }

    public List<String> getCalculateMeasureNumbers() {
        return this.calculateMeasure.stream().map(dynamicObject -> dynamicObject.getString("number")).collect(Collectors.toList());
    }

    public boolean needCaculate() {
        return !this.calculateMeasure.isEmpty() && this.executeCalculte != false && TimeTypeEnum.PERIOD.getCode().equals(this.timeType);
    }

    public String getInsertSQL() {
        FAFSQLBuilder builder = new FAFSQLBuilder(this.tableNumber);
        for (String field : this.fields) {
            if (field.equals("collectstatus") || field.equals("operationstatus")) continue;
            builder.insert("f" + field);
        }
        builder.insert("fcollectstatus", "1").insert("foperationstatus", "0").insert("fdatastatus", "0").insert("fdel", "0").insert("fsituationtype", "0").insert("foffstatus", "0");
        if (this.haveTime) {
            builder.insert("fcreatetime");
        }
        return builder.toInsertSQL();
    }

    public String getUpdateSQL() {
        FAFSQLBuilder builder = new FAFSQLBuilder(this.tableNumber);
        for (DynamicObject dynamicObject : this.ordinaryMeasure.values()) {
            builder.set("f" + dynamicObject.get("number"));
        }
        for (DynamicObject dynamicObject : this.calculateMeasure) {
            builder.set("f" + dynamicObject.get("number"));
        }
        return builder.where("fid").eq("f" + this.orgNumber, (DataType)DataType.LongType).eq("f" + this.periodNumber, (DataType)DataType.LongType).toUpdateSQL();
    }

    public String[] getDelSelectRows() {
        ArrayList<String> measureNumbers = new ArrayList<String>(1);
        measureNumbers.add("id");
        return measureNumbers.toArray(new String[0]);
    }

    public String getDelSQL() {
        FAFSQLBuilder builder = new FAFSQLBuilder(this.tableNumber);
        return builder.where("fid").toDeleteSQL();
    }

    public String[] getUpdateSelectRows() {
        List<String> measureNumbers = this.getOrdinaryMeasureNumbers();
        measureNumbers.addAll(this.getCalculateMeasureNumbers());
        measureNumbers.add("id");
        measureNumbers.add(this.orgNumber);
        measureNumbers.add(this.periodNumber);
        return measureNumbers.toArray(new String[0]);
    }

    public FAFSQLBuilder getUpdateDetailSummarySQL() {
        return new FAFSQLBuilder(this.detailTableNumber).set("fsummaryid", (DataType)DataType.LongType).set("foperationstatus", OperationStatusEnum.USED.getCodeString()).where().eq("fid", (DataType)DataType.LongType).eq("f" + this.orgNumber, (DataType)DataType.LongType).eq("f" + this.periodNumber, (DataType)DataType.LongType);
    }

    public FAFSQLBuilder getUpdateDetailDimHashSQL() {
        return new FAFSQLBuilder(this.detailTableNumber).set("fdimhash", (DataType)DataType.StringType).where().eq("fid", (DataType)DataType.LongType).eq("f" + this.orgNumber, (DataType)DataType.LongType).eq("f" + this.periodNumber, (DataType)DataType.LongType);
    }

    public FAFSQLBuilder getUpdateSummaryDimHashSQL() {
        return new FAFSQLBuilder(this.tableNumber).set("fdimhash", (DataType)DataType.StringType).where().eq("fid", (DataType)DataType.LongType).eq("f" + this.orgNumber, (DataType)DataType.LongType).eq("f" + this.periodNumber, (DataType)DataType.LongType);
    }

    public FAFSQLBuilder getUpdateSummaryImportBatchSQL() {
        return new FAFSQLBuilder(this.tableNumber).set("fimportbatch", (DataType)DataType.StringType).where().eq("fid", (DataType)DataType.LongType).eq("f" + this.orgNumber, (DataType)DataType.LongType).eq("f" + this.periodNumber, (DataType)DataType.LongType);
    }

    public FAFExecuteDB getRollbackExcuteDBs() {
        FAFSQLBuilder delete_model_data = new FAFSQLBuilder(this.tableNumber).where().in("f" + this.orgNumber, this.orgIds.length).params(this.orgIds);
        if (TimeTypeEnum.PERIOD.getCode().equals(this.timeType)) {
            delete_model_data.in("f" + this.periodNumber, this.originalPeriodIds.length).params(this.originalPeriodIds);
        } else if (this.startDate != null && this.endDate != null && TimeTypeEnum.DATE.getCode().equals(this.timeType)) {
            delete_model_data.betweenAnd("f" + this.periodNumber, (DataType)DataType.TimestampType).params(this.startDate, this.endDate);
        }
        FAFExecuteDB execute = new FAFExecuteDB("fias", delete_model_data.toDeleteSQL(), delete_model_data.getParams());
        return execute;
    }

    public boolean isHaveTime() {
        return this.haveTime;
    }

    public boolean isModelContainsDimHash() {
        return this.modelContainsDimHash;
    }

    public List<String> getModelHashDimensionNumberList() {
        return this.modelHashDimensionNumberList;
    }

    public boolean isIncrementSummary() {
        return this.incrementSummary;
    }

    public int getOrmInputParallelism() {
        return this.ormInputParallelism;
    }
}

