/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.summary;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.AlgoXCallBack;
import kd.bos.algox.CoGroupDataSetX;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.JoinFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.algox.FAFAlgoX;
import kd.macc.faf.algox.FAFExecuteDB;
import kd.macc.faf.algox.FAFJoinLinkFunction;
import kd.macc.faf.algox.FAFJoinLinkInfo;
import kd.macc.faf.algox.FAFSQLBuilder;
import kd.macc.faf.algox.XDbOutput;
import kd.macc.faf.cache.DistributeCache;
import kd.macc.faf.cache.IDataCacheModule;
import kd.macc.faf.dto.DataExtractingDTO;
import kd.macc.faf.enums.FAFSummarySceneEnum;
import kd.macc.faf.enums.OperationStatusEnum;
import kd.macc.faf.summary.FAFSummaryCalculateDTO;
import kd.macc.faf.summary.FAFSummaryCalculateGroupReduceFunction;
import kd.macc.faf.summary.FAFSummaryDataDTO;
import kd.macc.faf.summary.SummaryCoGroupFunction;
import kd.macc.faf.util.AnalysisModelUtil;

public class FAFSummaryDataHelper {
    private static final Log logger = LogFactory.getLog(FAFSummaryDataHelper.class);
    protected DistributeCache cache;
    private String taskId;
    private FAFSummarySceneEnum summaryScene;

    public FAFSummaryDataHelper(String taskId) {
        this(taskId, FAFSummarySceneEnum.SYNC_DATA);
    }

    public FAFSummaryDataHelper(String taskId, FAFSummarySceneEnum summaryScene) {
        this.taskId = taskId;
        this.summaryScene = summaryScene;
        this.cache = DistributeCache.getCache((IDataCacheModule)IDataCacheModule.FAF);
    }

    public void summary(DynamicObject model, DataExtractingDTO extraDTO, DLock dLock) {
        this.summary(new FAFSummaryDataDTO(model, extraDTO.getOrgIds(), extraDTO.getPeriodIds(), extraDTO.getTimeType(), extraDTO.getStartDate(), extraDTO.getEndDate()), dLock);
    }

    public void summary(final FAFSummaryDataDTO dto, final DLock dLock) {
        JobSession session = AlgoX.createSession((String)"pa_summary_calculate", (String)ResManager.loadKDString((String)"\u76c8\u5229\u80fd\u529b\u5206\u6790\u6c47\u603b\u4e0e\u8ba1\u7b97", (String)"FAFSummaryDataHelper_0", (String)"macc-faf-business", (Object[])new Object[0]));
        QFilter modelDetailFilter = this.buildModelDetailQFilter(dto);
        FAFAlgoX.fillModelDimHash(dto, modelDetailFilter, true);
        if (dto.needCaculate()) {
            FAFAlgoX.fillModelDimHash(dto, dto.getOrgPeriodQFilter(true, false), false);
        } else {
            FAFAlgoX.fillModelDimHash(dto, dto.getOrgPeriodQFilter(false), false);
        }
        String summaryTagId = this.tagIncrementSummaryData(dto, modelDetailFilter);
        DataSetX incrementSummaryDataSetX = this.summaryIncrementData(session, dto, modelDetailFilter, summaryTagId);
        if (dto.needCaculate()) {
            OrmInput[] previousSummaryOrmInputs = this.buildModelSummaryOrmInputs(dto, summaryTagId, true);
            DataSetX previousSummaryDataSetX = session.fromInput((Input[])previousSummaryOrmInputs);
            previousSummaryDataSetX = previousSummaryDataSetX.addFields(new Field[]{new Field("summaryid", (DataType)DataType.LongType)}, new Object[]{9L});
            incrementSummaryDataSetX = this.calculateIncrementSummaryData(session, dto, incrementSummaryDataSetX, previousSummaryDataSetX);
        }
        DataSetX dsXfilterInsert = incrementSummaryDataSetX.filter("summaryid = 1").removeFields(new String[]{"summaryid", "operationstatus", "collectstatus"});
        if (dto.isHaveTime()) {
            dsXfilterInsert = dsXfilterInsert.addFields(new Field[]{new Field("fcreatetime", (DataType)DataType.TimestampType)}, new Object[]{new Date()});
        }
        XDbOutput insertOutput = new XDbOutput("fias", dto.getInsertSQL(), dsXfilterInsert.getRowMeta());
        dsXfilterInsert.output((Output)insertOutput);
        DataSetX dsXfilterUpdate = incrementSummaryDataSetX.filter("summaryid = 0").select(dto.getUpdateSelectRows());
        XDbOutput updateOutput = new XDbOutput("fias", dto.getUpdateSQL(), dsXfilterUpdate.getRowMeta());
        dsXfilterUpdate.output((Output)updateOutput);
        session.asyncCommit(1, TimeUnit.DAYS, new AlgoXCallBack(){

            public void onFinished() {
                if (dLock != null) {
                    dLock.unlock();
                }
                FAFSummaryDataHelper.this.cache.put("FAF|" + FAFSummaryDataHelper.this.taskId, (Object)"summarySuccess");
            }

            public void onFailed(Exception e) {
                if (dLock != null) {
                    dLock.unlock();
                }
                logger.error("pa.algox.summay.onFailed", (Throwable)e);
                FAFSummaryDataHelper.this.cache.put("FAF|" + FAFSummaryDataHelper.this.taskId, (Object)("error:" + e.getMessage()));
                if (FAFSummarySceneEnum.SYNC_DATA == FAFSummaryDataHelper.this.summaryScene) {
                    FAFSummaryDataHelper.this.rollbackSummary(dto);
                }
            }
        });
    }

    private DataSetX summaryIncrementData(JobSession session, FAFSummaryDataDTO dto, QFilter modelDetailFilter, String summaryTagId) {
        String[] dimension;
        OrmInput[] detailOrmInputs = this.buildModelDetailOrmInputs(dto, modelDetailFilter);
        DataSetX detailDataSetX = session.fromInput((Input[])detailOrmInputs);
        OrmInput[] modelSummaryOrmInputs = this.buildModelSummaryOrmInputs(dto, summaryTagId, false);
        DataSetX modelSummaryDataSetX = session.fromInput((Input[])modelSummaryOrmInputs);
        CoGroupDataSetX coGroupDataSetX = modelSummaryDataSetX.coGroup(detailDataSetX, (CoGroupFunction)new SummaryCoGroupFunction(modelSummaryDataSetX.getRowMeta(), dto));
        for (String dim : dimension = dto.getFields_dimension()) {
            coGroupDataSetX.on(dim, dim);
        }
        DataSetX dsxDetail = coGroupDataSetX.filter("collectstatus = 0");
        FAFSQLBuilder refUpdateSummarySQL = dto.getUpdateDetailSummarySQL();
        XDbOutput updateDetail = new XDbOutput("fias", refUpdateSummarySQL.toUpdateSQL(), refUpdateSummarySQL.getRowMeta());
        dsxDetail.select(new String[]{"summaryid", "id", dto.getOrgNumber(), dto.getPeriodNumber()}).output((Output)updateDetail);
        DataSetX incrementSummaryDataSetX = coGroupDataSetX.filter("collectstatus = 1");
        return incrementSummaryDataSetX;
    }

    private DataSetX calculateIncrementSummaryData(JobSession session, FAFSummaryDataDTO dto, DataSetX incrementSummaryDataSetX, DataSetX previousSummaryDataSetX) {
        DataSetX totalSummaryDataSetX = incrementSummaryDataSetX.union(previousSummaryDataSetX);
        FAFSummaryCalculateDTO calculateDTO = dto.buildCalculateDTO();
        FAFJoinLinkInfo leftJoin = calculateDTO.getLink();
        OrmInput leftOrmInput = FAFAlgoX.createOrmInput(leftJoin);
        DataSetX dsXLeft = session.fromInput((Input)leftOrmInput);
        JoinDataSetX joinDataSetX = totalSummaryDataSetX.leftJoin(dsXLeft).on(leftJoin.getLeftField(), leftJoin.getRightField()).withFunc((JoinFunction)new FAFJoinLinkFunction(totalSummaryDataSetX.getRowMeta(), leftJoin));
        totalSummaryDataSetX = joinDataSetX.groupBy(this.replaceGrouperFields(dto.getFields_dimension(), leftJoin)).reduceGroup((GroupReduceFunction)new FAFSummaryCalculateGroupReduceFunction(totalSummaryDataSetX.getRowMeta(), joinDataSetX.getRowMeta(), calculateDTO));
        return totalSummaryDataSetX;
    }

    public String tagIncrementSummaryData(FAFSummaryDataDTO dto, QFilter modelDetailFilter) {
        if (!dto.isModelContainsDimHash()) {
            return "";
        }
        if (FAFSummarySceneEnum.SYNC_DATA == this.summaryScene) {
            return "";
        }
        long startTime = System.currentTimeMillis();
        String summaryEntityNumber = dto.getEntityName();
        String detailEntityNumber = dto.getDetailEntityName();
        boolean isSummaryShardingEntity = AnalysisModelUtil.isShardingEntity((String)summaryEntityNumber);
        boolean isTagSummaryByDetailDimhash = false;
        if (!isSummaryShardingEntity && ORM.create().count("countDetailModel", detailEntityNumber, new QFilter[]{modelDetailFilter}) < 200000) {
            isTagSummaryByDetailDimhash = true;
        }
        long costTime = System.currentTimeMillis() - startTime;
        logger.info("analysis detail model {} data cost {}ms", (Object)summaryEntityNumber, (Object)costTime);
        String tagId = "";
        tagId = isTagSummaryByDetailDimhash ? this.tagIncrementSummaryDataByDetailDimhash(dto, modelDetailFilter) : this.tagIncrementSummaryDataByBloomFilter(dto, modelDetailFilter);
        return tagId;
    }

    private String tagIncrementSummaryDataByBloomFilter(FAFSummaryDataDTO dto, QFilter modelDetailFilter) {
        QFilter summaryOrgPeriodQFilter = null;
        summaryOrgPeriodQFilter = dto.needCaculate() ? dto.getOrgPeriodQFilter(true, false) : dto.getOrgPeriodQFilter(false);
        String summaryEntityNumber = dto.getEntityName();
        String detailEntityNumber = dto.getDetailEntityName();
        String orgFieldName = dto.getOrgNumber();
        String periodFieldName = dto.getPeriodNumber();
        long startTime = System.currentTimeMillis();
        long detailCount = 0L;
        BloomFilter bloomFilter = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)StandardCharsets.UTF_8), (int)10000000, (double)0.01);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryDetailModelDimhash", (String)detailEntityNumber, (String)"dimhash", (QFilter[])new QFilter[]{modelDetailFilter}, null);){
            for (Row row : ds) {
                String dimhash = row.getString("dimhash");
                if (StringUtils.isBlank((CharSequence)dimhash)) {
                    throw new KDBizException(String.format("detail model %s data's dimhash is empty, stop summary", summaryEntityNumber));
                }
                ++detailCount;
                bloomFilter.put((Object)dimhash);
            }
        }
        long costTime = System.currentTimeMillis() - startTime;
        logger.info("build detail model {} data bloomFilter cost {}ms, total count is {}", new Object[]{summaryEntityNumber, costTime, detailCount});
        startTime = System.currentTimeMillis();
        String tagId = String.valueOf(DB.genGlobalLongId());
        int batchSize = 100000;
        int batchIndex = 1;
        long summaryCount = 0L;
        long updateCount = 0L;
        ArrayList<Object[]> params = new ArrayList<Object[]>(batchSize);
        String updateSql = dto.getUpdateSummaryImportBatchSQL().toUpdateSQL();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"querySummaryModelDimhash", (String)summaryEntityNumber, (String)StringUtils.join((Object[])new String[]{"id", orgFieldName, periodFieldName, "dimhash"}, (String)","), (QFilter[])new QFilter[]{summaryOrgPeriodQFilter}, null);){
            for (Row row : ds) {
                String dimhash = row.getString("dimhash");
                if (StringUtils.isBlank((CharSequence)dimhash)) {
                    throw new KDBizException(String.format("summary model %s data's dimhash is empty, stop summary", summaryEntityNumber));
                }
                ++summaryCount;
                if (!bloomFilter.mightContain((Object)dimhash)) continue;
                ++updateCount;
                params.add(new Object[]{tagId, row.getLong("id"), row.getLong(orgFieldName), row.getLong(periodFieldName)});
                if (params.size() != batchSize) continue;
                logger.info("begin update summary model {} data's dimhash, batchIndex is {}, batchSize is {}", new Object[]{summaryEntityNumber, batchIndex++, batchSize});
                FAFAlgoX.executeBatchDB(updateSql, params);
            }
        }
        FAFAlgoX.executeBatchDB(updateSql, params);
        costTime = System.currentTimeMillis() - startTime;
        logger.info("tag summary model {} data cost {}ms, total count is {}, actual hit count is {}", new Object[]{summaryEntityNumber, costTime, summaryCount, updateCount});
        return tagId;
    }

    private String tagIncrementSummaryDataByDetailDimhash(FAFSummaryDataDTO dto, QFilter modelDetailFilter) {
        long startTime = System.currentTimeMillis();
        QFilter summaryOrgPeriodQFilter = null;
        summaryOrgPeriodQFilter = dto.needCaculate() ? dto.getOrgPeriodQFilter(true, false) : dto.getOrgPeriodQFilter(false);
        String summaryEntityNumber = dto.getEntityName();
        String summaryTableNumber = dto.getTableNumber();
        String detailEntityNumber = dto.getDetailEntityName();
        String orgFieldName = dto.getOrgNumber();
        String periodFieldName = dto.getPeriodNumber();
        String summaryOrgPeriodQFilterCondition = summaryOrgPeriodQFilter.toString().replaceAll(orgFieldName, "f" + orgFieldName).replaceAll(periodFieldName, "f" + periodFieldName);
        String updateSql = String.format("update %s set f%s=? where %s and f%s=?", summaryTableNumber, "importbatch", summaryOrgPeriodQFilterCondition, "dimhash");
        String tagId = String.valueOf(DB.genGlobalLongId());
        int batchSize = 100000;
        int batchIndex = 1;
        long updateCount = 0L;
        ArrayList<Object[]> params = new ArrayList<Object[]>(batchSize);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"tagSummaryByDimHash", (String)detailEntityNumber, (String)"dimhash", (QFilter[])new QFilter[]{modelDetailFilter}, null);){
            for (Row row : ds) {
                String dimhash = row.getString("dimhash");
                if (StringUtils.isBlank((CharSequence)dimhash)) {
                    throw new KDBizException(String.format("detail model %s data's dimhash is empty, stop summary", summaryEntityNumber));
                }
                ++updateCount;
                params.add(new Object[]{tagId, dimhash});
                if (params.size() != batchSize) continue;
                logger.info("begin update summary model {} data's dimhash, batchIndex is {}, batchSize is {}", new Object[]{summaryEntityNumber, batchIndex++, batchSize});
                FAFAlgoX.executeBatchDB(updateSql, params);
            }
        }
        FAFAlgoX.executeBatchDB(updateSql, params);
        long costTime = System.currentTimeMillis() - startTime;
        logger.info("tag summary model {} data cost {}ms, total update count is {}", new Object[]{summaryEntityNumber, costTime, updateCount});
        return tagId;
    }

    private QFilter buildModelDetailQFilter(FAFSummaryDataDTO dto) {
        QFilter orgPeriodFilter = dto.getOrgPeriodQFilter(false);
        if (this.summaryScene != FAFSummarySceneEnum.SYNC_DATA && this.summaryScene == FAFSummarySceneEnum.IMPORT_DATA) {
            orgPeriodFilter = orgPeriodFilter.and("operationstatus", "=", (Object)OperationStatusEnum.UNUSED.getCode());
        }
        return orgPeriodFilter;
    }

    private OrmInput[] buildModelDetailOrmInputs(FAFSummaryDataDTO dto, QFilter modelDetailFilter) {
        int parallel = dto.getOrmInputParallelism();
        QFilter[] parallelQFilters = FAFAlgoX.parallelQFilters(parallel, new QFilter[]{modelDetailFilter});
        ArrayList<OrmInput> ormInputList = new ArrayList<OrmInput>(parallelQFilters.length);
        for (QFilter qFilter : parallelQFilters) {
            ormInputList.add(new OrmInput("pa.summaryAndCalculate", dto.getDetailEntityName(), dto.getSelectFields(), new QFilter[]{qFilter}));
        }
        return ormInputList.toArray(new OrmInput[0]);
    }

    private OrmInput[] buildModelSummaryOrmInputs(FAFSummaryDataDTO dto, String summaryTagId, boolean isExpandPeriod) {
        QFilter orgPeriodFilter = dto.getOrgPeriodQFilter(isExpandPeriod);
        if (StringUtils.isNotBlank((CharSequence)summaryTagId)) {
            orgPeriodFilter.and("importbatch", "=", (Object)summaryTagId);
        }
        int parallel = dto.getOrmInputParallelism();
        QFilter[] parallelQFilters = FAFAlgoX.parallelQFilters(parallel, new QFilter[]{orgPeriodFilter});
        ArrayList<OrmInput> ormInputList = new ArrayList<OrmInput>(parallelQFilters.length);
        for (QFilter qFilter : parallelQFilters) {
            ormInputList.add(new OrmInput("pa.summaryAndCalculate", dto.getEntityName(), dto.getSelectFields(), new QFilter[]{qFilter}));
        }
        return ormInputList.toArray(new OrmInput[0]);
    }

    private void rollbackSummary(FAFSummaryDataDTO dto) {
        FAFExecuteDB excuteDB = dto.getRollbackExcuteDBs();
        if (excuteDB != null) {
            DB.execute((DBRoute)excuteDB.getDbRoute(), (String)excuteDB.getSql(), (Object[])excuteDB.getParams());
        }
    }

    private String[] replaceGrouperFields(String[] fields_dimension, FAFJoinLinkInfo leftJoin) {
        return (String[])Arrays.stream(fields_dimension).flatMap(field -> {
            if (field.equals(leftJoin.getLeftField())) {
                return Stream.of(leftJoin.getReplaceGroupField());
            }
            return Stream.of(field);
        }).toArray(String[]::new);
    }
}

