/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.summary;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.bos.db.DB;
import kd.macc.faf.summary.FAFSummaryDataDTO;

public class SummaryCoGroupFunction
extends CoGroupFunction {
    private static final long serialVersionUID = 1L;
    private final RowMeta rowMeta;
    private final RowMeta newRowMeta;
    private final List<String> omNumbers;
    private final int startMeasureIndex;
    private final int summaryIdIndex;
    private final boolean incrementSummary;

    public SummaryCoGroupFunction(RowMeta rowMeta, FAFSummaryDataDTO dto) {
        this.rowMeta = rowMeta;
        this.omNumbers = dto.getOrdinaryMeasureNumbers();
        String[] fieldNames = rowMeta.getFieldNames();
        DataType[] dataTypes = rowMeta.getDataTypes();
        String[] names = Arrays.copyOf(fieldNames, fieldNames.length + 1);
        DataType[] types = Arrays.copyOf(dataTypes, dataTypes.length + 1);
        names[fieldNames.length] = "summaryid";
        types[dataTypes.length] = DataType.LongType;
        this.summaryIdIndex = fieldNames.length;
        this.newRowMeta = new RowMeta(names, types);
        int size = dto.getCalculateMeasureNumbers().size();
        this.startMeasureIndex = rowMeta.getFieldCount() - this.omNumbers.size() - size;
        this.incrementSummary = dto.isIncrementSummary();
    }

    public void coGroup(Iterable<RowX> iter1, Iterable<RowX> iter2, Collector collector) {
        Long summaryId;
        RowX collectRowX = new RowX(this.newRowMeta.getFieldCount());
        boolean isAdd = false;
        Iterator<RowX> sum = iter1.iterator();
        Object[] bigDecimals = new BigDecimal[this.omNumbers.size()];
        Arrays.fill(bigDecimals, BigDecimal.ZERO);
        if (sum.hasNext()) {
            int i;
            RowX next = sum.next();
            summaryId = next.getLong(0);
            collectRowX.set(this.summaryIdIndex, (Object)0L);
            for (i = 1; i < this.startMeasureIndex; ++i) {
                collectRowX.set(i, next.get(i));
            }
            if (this.incrementSummary) {
                for (i = 0; i < this.omNumbers.size(); ++i) {
                    BigDecimal originValue = next.getBigDecimal(this.startMeasureIndex + i);
                    if (originValue == null) continue;
                    bigDecimals[i] = ((BigDecimal)bigDecimals[i]).add(originValue);
                }
            }
        } else {
            isAdd = true;
            summaryId = DB.genGlobalLongId();
            collectRowX.set(this.summaryIdIndex, (Object)1L);
        }
        collectRowX.set(0, (Object)summaryId);
        RowX initRow = null;
        for (RowX row : iter2) {
            int i;
            if (initRow == null) {
                initRow = row;
            }
            RowX detailRow = new RowX(this.newRowMeta.getFieldCount());
            for (i = 0; i < row.size(); ++i) {
                detailRow.set(i, row.get(i));
            }
            detailRow.set(this.summaryIdIndex, (Object)summaryId);
            collector.collect(detailRow);
            for (i = 0; i < this.omNumbers.size(); ++i) {
                BigDecimal bigDecimal = row.getBigDecimal(this.rowMeta.getFieldIndex(this.omNumbers.get(i)));
                if (bigDecimal == null) continue;
                bigDecimals[i] = ((BigDecimal)bigDecimals[i]).add(bigDecimal);
            }
        }
        if (isAdd && initRow != null) {
            for (int i = 1; i < this.startMeasureIndex; ++i) {
                collectRowX.set(i, initRow.get(i));
            }
        }
        for (int i = 0; i < bigDecimals.length; ++i) {
            collectRowX.set(this.startMeasureIndex + i, bigDecimals[i]);
        }
        collectRowX.set(this.newRowMeta.getFieldIndex("operationstatus"), (Object)0L);
        collectRowX.set(this.newRowMeta.getFieldIndex("collectstatus"), (Object)1L);
        collector.collect(collectRowX);
    }

    public RowMeta getResultRowMeta() {
        return this.newRowMeta;
    }
}

