/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.faf.enums.FAFSyncLogStatusEnum;
import kd.macc.faf.enums.FAFWorkTaskTypeEnum;
import kd.macc.faf.model.impl.IDataMapEntry;
import kd.macc.faf.util.FAFTableUtil;

public class AnalysisModelDroptableTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(AnalysisModelDroptableTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        try {
            String desc = ResManager.loadKDString((String)"\u5f00\u59cb\u5220\u9664\u6570\u636e\u8868", (String)"AnalysisModelDroptableTask_0", (String)"macc-faf-business", (Object[])new Object[0]);
            this.feedbackProgress(0, desc, null);
            this.dealMainBusi(params);
        }
        catch (Exception ex) {
            logger.error("execute error", (Throwable)ex);
            this.wrapFeedBack(false, "errorNotice", String.format(ResManager.loadKDString((String)"\u5220\u9664\u6570\u636e\u8868\u5931\u8d25:%s,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AnalysisModelDroptableTask_1", (String)"macc-faf-business", (Object[])new Object[0]), ex.getMessage()), 3000);
        }
    }

    private void dealMainBusi(Map<String, Object> params) {
        Long pkvalue = (Long)params.get("modelId");
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)pkvalue, (String)"pa_analysismodel");
        String tableNumber = model.getString("tablenumber");
        String tableName = model.getString("tablename");
        this.feedbackProgress(20, ResManager.loadKDString((String)"\u6b63\u5728\u5220\u9664\u6570\u636e\u8868", (String)"AnalysisModelDroptableTask_2", (String)"macc-faf-business", (Object[])new Object[0]), null);
        IDataMapEntry result = FAFTableUtil.createOrDropTable((Long)pkvalue, (FAFWorkTaskTypeEnum)FAFWorkTaskTypeEnum.Drop_Table_Task, (String)tableNumber, (String)tableName, (Boolean)Boolean.FALSE, (boolean)false);
        if (result == null || FAFSyncLogStatusEnum.SUCCESS != result.getKey()) {
            throw new KDBizException(result != null ? (String)result.getValue() : "result is null");
        }
        this.feedbackProgress(90, ResManager.loadKDString((String)"\u6570\u636e\u8868\u5220\u9664\u5b8c\u6bd5\uff0c\u8bf7\u7b49\u5f85\u66f4\u65b0\u5206\u6790\u6a21\u578b\u72b6\u6001", (String)"AnalysisModelDroptableTask_3", (String)"macc-faf-business", (Object[])new Object[0]), null);
        model.set("tablenumber", null);
        model.set("tablename", null);
        SaveServiceHelper.update((DynamicObject)model);
        DB.execute((DBRoute)DBRoute.of((String)"fias"), (String)"delete from t_pa_accperiodlock where fanalysismodelid = ?", (Object[])new Object[]{pkvalue});
        this.wrapFeedBack(true, "successNotice", ResManager.loadKDString((String)"\u5220\u9664\u6570\u636e\u8868\u6210\u529f\u3002", (String)"AnalysisModelDroptableTask_4", (String)"macc-faf-business", (Object[])new Object[0]), 1000);
    }

    private void wrapFeedBack(boolean success, String msgType, String msg, Integer showTime) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", success);
        result.put("msgType", msgType);
        result.put("msg", msg);
        if (null != showTime) {
            result.put("showTime", showTime);
        }
        this.feedbackCustomdata(result);
    }
}

