/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.lock.ModelTaskLock;
import kd.macc.faf.system.IModelMarkUpgrade;
import kd.macc.faf.util.AnalysisModelHashUtil;
import kd.macc.faf.util.AnalysisModelUtil;

public class DimhashMarkUpgrade
implements IModelMarkUpgrade {
    private static final Log logger = LogFactory.getLog(DimhashMarkUpgrade.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean upgrade(Long modelId) {
        logger.info("upgrade model dimhash begin, model id is {}", (Object)modelId);
        if (modelId == null || modelId == 0L) {
            return false;
        }
        DynamicObject analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
        if (analysisModel == null) {
            return false;
        }
        String tableNumber = analysisModel.getString("tablenumber");
        String detailEntityNumber = AnalysisModelUtil.buildDetailEntityNumber((String)tableNumber);
        if (!MetadataDao.checkNumber((String)detailEntityNumber)) {
            logger.info("model does not create detail table");
            return true;
        }
        if (!AnalysisModelHashUtil.isModelContainsDimHash((String)detailEntityNumber)) {
            logger.info("model does not has dimhash field");
            return true;
        }
        ModelTaskLock modelTaskLock = ModelTaskLock.create(detailEntityNumber, modelId);
        try {
            if (modelTaskLock.tryLock(10000L)) {
                this.updateAllDimHashEmpty(detailEntityNumber);
                String summaryEntityNumber = AnalysisModelUtil.buildEntityNumber((String)tableNumber);
                this.updateAllDimHashEmpty(summaryEntityNumber);
                logger.info("upgrade model dimhash success");
                boolean bl = true;
                return bl;
            }
            logger.info("get model lock fail");
        }
        finally {
            modelTaskLock.unlock();
        }
        return false;
    }

    private void updateAllDimHashEmpty(String entityNumber) {
        DBRoute dbRoute = DBRoute.of((String)"fias");
        String tableNumber = "t_" + entityNumber;
        String selectDimHashNotEmptySql = String.format("select fid from %s where fdimhash!=' '", tableNumber);
        String updateDimHashEmptySql = "update " + tableNumber + " set fdimhash=' ' where fid in (%s)";
        int totalCount = 0;
        ArrayList<String> idList = new ArrayList<String>(5000);
        try (DataSet dataSet = DB.queryDataSet((String)"queryDimHashNotEmpty", (DBRoute)dbRoute, (String)selectDimHashNotEmptySql);){
            for (Row row : dataSet) {
                idList.add(String.valueOf(row.getLong(0)));
                ++totalCount;
                if (idList.size() != 5000) continue;
                this.doBatchUpdate(dbRoute, updateDimHashEmptySql, idList);
            }
        }
        this.doBatchUpdate(dbRoute, updateDimHashEmptySql, idList);
        logger.info("update {} dimhash empty success, total count is {}", (Object)entityNumber, (Object)totalCount);
    }

    private void doBatchUpdate(DBRoute dbRoute, String updateDimHashEmptySql, List<String> idList) {
        if (idList.isEmpty()) {
            return;
        }
        String idStr = String.join((CharSequence)",", idList);
        idList.clear();
        updateDimHashEmptySql = String.format(updateDimHashEmptySql, idStr);
        DB.update((DBRoute)dbRoute, (String)updateDimHashEmptySql);
    }
}

