/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.faf.system.IModelMarkUpgrade;
import kd.macc.faf.system.ModelMarkEnum;

public class ModelMarks {
    private static final Log logger = LogFactory.getLog(ModelMarks.class);
    private final Long modelId;

    public ModelMarks(Long modelId) {
        Assert.notNull((Object)modelId, (String)"analysis model id must not be null");
        this.modelId = modelId;
    }

    public static String defaultMarks() {
        return ModelMarks.marksToString(Collections.singletonList(ModelMarkEnum.DIMHASHV1.getCode()));
    }

    public boolean exists(ModelMarkEnum mark) {
        Assert.notNull((Object)((Object)mark), (String)"mark must not be null");
        QFilter idFilter = new QFilter("id", "=", (Object)this.modelId);
        DynamicObject analysisModel = QueryServiceHelper.queryOne((String)"pa_analysismodel", (String)"marks", (QFilter[])idFilter.toArray());
        if (analysisModel == null) {
            return false;
        }
        List<String> existMarks = this.parseMarks(analysisModel.getString("marks"));
        return existMarks.contains(mark.getCode());
    }

    public void add(ModelMarkEnum mark) {
        Assert.notNull((Object)((Object)mark), (String)"mark must not be null");
        try (TXHandle h = TX.required((String)"pa_analysismodel");){
            try {
                DynamicObject analysisModel = BusinessDataServiceHelper.loadSingle((Object)this.modelId, (String)"pa_analysismodel", (String)"marks");
                List<String> existMarks = this.parseMarks(analysisModel.getString("marks"));
                if (!existMarks.contains(mark.getCode())) {
                    existMarks.add(mark.getCode());
                    String newMarks = ModelMarks.marksToString(existMarks);
                    analysisModel.set("marks", (Object)newMarks);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{analysisModel});
                }
            }
            catch (Throwable e) {
                logger.error("add mark error", e);
                h.markRollback();
            }
        }
    }

    public void addIfAbsent(ModelMarkEnum mark, IModelMarkUpgrade upgradeFunction) {
        Assert.notNull((Object)((Object)mark), (String)"upgrade function must not be null");
        if (!this.exists(mark) && upgradeFunction.upgrade(this.modelId)) {
            this.add(mark);
        }
    }

    private List<String> parseMarks(String marks) {
        if (StringUtils.isEmpty((CharSequence)marks)) {
            return new ArrayList<String>(0);
        }
        return Arrays.stream(marks.split(",")).filter(t -> !StringUtils.isBlank((CharSequence)t)).collect(Collectors.toList());
    }

    private static String marksToString(List<String> marks) {
        if (CollectionUtils.isEmpty(marks)) {
            return "";
        }
        return "," + String.join((CharSequence)",", marks) + ",";
    }
}

