/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.alloc.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.alloc.input.PriceDiffAllocParam;
import kd.macc.sca.algox.utils.CadEmptyUtils;

@Deprecated
public class PriceDiffFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private PriceDiffAllocParam allocParam;

    public PriceDiffAllocParam getAllocParam() {
        return this.allocParam;
    }

    public void setAllocParam(PriceDiffAllocParam allocParam) {
        this.allocParam = allocParam;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        for (RowX rowX : iterable) {
            if (!this.doAlloc(rowX)) continue;
            collector.collect(rowX);
        }
    }

    public RowMeta getResultRowMeta() {
        Field[] fields = new Field[]{new Field("orgid", (DataType)DataType.LongType), new Field("costaccountid", (DataType)DataType.LongType), new Field("createtype", (DataType)DataType.StringType), new Field("materialid", (DataType)DataType.LongType), new Field("mversionid", (DataType)DataType.LongType), new Field("auxptyid", (DataType)DataType.LongType), new Field("elementid", (DataType)DataType.LongType), new Field("subelementid", (DataType)DataType.LongType), new Field("nointoamt", (DataType)DataType.BigDecimalType), new Field("intoamt", (DataType)DataType.BigDecimalType)};
        return new RowMeta(fields);
    }

    private boolean doAlloc(RowX row) {
        StringBuilder matkey = new StringBuilder();
        matkey.append(row.getString(this.getFieldIndex("materialid"))).append("@");
        matkey.append(row.getString(this.getFieldIndex("mversionid"))).append("@");
        matkey.append(row.getString(this.getFieldIndex("auxptyid")));
        BigDecimal outRate = this.allocParam.getCalcOutRateInfos().get(matkey.toString());
        if (outRate == null) {
            return false;
        }
        BigDecimal noIntoAmt = row.getBigDecimal(this.getFieldIndex("nointoamt"));
        BigDecimal intoAmt = noIntoAmt.multiply(outRate).setScale(this.allocParam.getPrecision(), 4);
        row.set(this.getFieldIndex("intoamt"), (Object)intoAmt);
        boolean isSuccess = this.allocIntoAmt(row, matkey.toString());
        return isSuccess;
    }

    private boolean allocIntoAmt(RowX row, String matkey) {
        Map<String, BigDecimal> costObjectUseQtyMap = this.allocParam.getCostObjectUseMatQtyMap().get(matkey);
        if (CadEmptyUtils.isEmpty(costObjectUseQtyMap)) {
            return false;
        }
        BigDecimal totalUseQty = BigDecimal.ZERO;
        BigDecimal maxusetQty = BigDecimal.ZERO;
        String maxCostObject = null;
        for (Map.Entry<String, BigDecimal> entry : costObjectUseQtyMap.entrySet()) {
            BigDecimal value = entry.getValue();
            totalUseQty = totalUseQty.add(value);
            if (maxusetQty.compareTo(value) >= 0) continue;
            maxusetQty = value;
            maxCostObject = entry.getKey();
        }
        if (BigDecimal.ZERO.compareTo(totalUseQty) == 0) {
            return false;
        }
        BigDecimal unAllocedAmt = row.getBigDecimal(this.getFieldIndex("intoamt"));
        HashMap<String, BigDecimal> allocResult = new HashMap<String, BigDecimal>(16);
        BigDecimal allocedAmt = BigDecimal.ZERO;
        for (Map.Entry<String, BigDecimal> entry : costObjectUseQtyMap.entrySet()) {
            BigDecimal useQty = entry.getValue();
            BigDecimal currAllocAmt = unAllocedAmt.multiply(useQty).divide(totalUseQty, this.allocParam.getPrecision(), 4);
            allocedAmt = allocedAmt.add(currAllocAmt);
            allocResult.put(entry.getKey(), currAllocAmt);
        }
        BigDecimal diffAmt = unAllocedAmt.subtract(allocedAmt);
        allocResult.put(maxCostObject, ((BigDecimal)allocResult.get(maxCostObject)).add(diffAmt));
        this.saveDB(row, allocResult);
        return true;
    }

    private void saveDB(RowX row, Map<String, BigDecimal> allocResult) {
        DynamicObject entry;
        DynamicObjectCollection entrys;
        List<QFilter> filters = this.getFilters(row, allocResult.keySet());
        List pks = QueryServiceHelper.queryPrimaryKeys((String)"sca_pricediffalloc", (QFilter[])filters.toArray(new QFilter[0]), null, (int)10000);
        DynamicObject[] pricediffallocs = null;
        if (!CadEmptyUtils.isEmpty(pks)) {
            for (DynamicObject pricediffalloc : pricediffallocs = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sca_pricediffalloc"))) {
                String costCenterId = pricediffalloc.getString("costCenter.id");
                String costObjectId = pricediffalloc.getString("costObject.id");
                entrys = pricediffalloc.getDynamicObjectCollection("entryentity");
                entry = entrys.addNew();
                entry.set("element", row.get(this.getFieldIndex("elementid")));
                entry.set("subelement", row.get(this.getFieldIndex("subelementid")));
                entry.set("amount", (Object)allocResult.remove(costCenterId + "@" + costObjectId));
            }
            SaveServiceHelper.save((DynamicObject[])pricediffallocs);
        }
        if (!CadEmptyUtils.isEmpty(allocResult)) {
            ArrayList<DynamicObject> newPricediffallocs = new ArrayList<DynamicObject>(10);
            for (Map.Entry<String, BigDecimal> entrySet : allocResult.entrySet()) {
                String[] ccAndCoInfos = entrySet.getKey().split("@");
                BigDecimal allocAmt = entrySet.getValue();
                DynamicObject newPricediffalloc = BusinessDataServiceHelper.newDynamicObject((String)"sca_pricediffalloc");
                newPricediffalloc.set("billno", (Object)("NO." + System.currentTimeMillis()));
                newPricediffalloc.set("org", row.get(this.getFieldIndex("orgid")));
                newPricediffalloc.set("costaccount", row.get(this.getFieldIndex("costaccountid")));
                newPricediffalloc.set("costcenter", (Object)ccAndCoInfos[0]);
                newPricediffalloc.set("currency", (Object)this.allocParam.getCurrencyId());
                newPricediffalloc.set("period", (Object)this.allocParam.getPeriodId());
                newPricediffalloc.set("createtype", row.get(this.getFieldIndex("createtype")));
                newPricediffalloc.set("costobject", (Object)ccAndCoInfos[1]);
                newPricediffalloc.set("material", row.get(this.getFieldIndex("materialid")));
                newPricediffalloc.set("auxpty", row.get(this.getFieldIndex("auxptyid")));
                newPricediffalloc.set("matversion", row.get(this.getFieldIndex("mversionid")));
                entrys = newPricediffalloc.getDynamicObjectCollection("entryentity");
                entry = entrys.addNew();
                entry.set("element", row.get(this.getFieldIndex("elementid")));
                entry.set("subelement", row.get(this.getFieldIndex("subelementid")));
                entry.set("amount", (Object)allocAmt);
                newPricediffallocs.add(newPricediffalloc);
            }
            SaveServiceHelper.save((DynamicObject[])newPricediffallocs.toArray(new DynamicObject[0]));
        }
    }

    private List<QFilter> getFilters(RowX row, Set<String> costobjectInfos) {
        HashMap costenterAndCostObjects = new HashMap(16);
        for (String costobjectInfo : costobjectInfos) {
            String[] costceterAndCostObject = costobjectInfo.split("@");
            if (costenterAndCostObjects.containsKey(costceterAndCostObject[0])) {
                ((Set)costenterAndCostObjects.get(costceterAndCostObject[0])).add(costceterAndCostObject[1]);
                continue;
            }
            HashSet<String> costObjectids = new HashSet<String>(16);
            costObjectids.add(costceterAndCostObject[1]);
            costenterAndCostObjects.put(costceterAndCostObject[0], costObjectids);
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)row.getLong(this.getFieldIndex("orgid"))));
        filters.add(new QFilter("costaccount", "=", (Object)row.getLong(this.getFieldIndex("costaccountid"))));
        filters.add(new QFilter("period", "=", (Object)this.allocParam.getPeriodId()));
        filters.add(new QFilter("material", "=", (Object)row.getLong(this.getFieldIndex("materialid"))));
        filters.add(new QFilter("auxpty", "=", (Object)row.getLong(this.getFieldIndex("auxptyid"))));
        filters.add(new QFilter("matversion", "=", (Object)row.getLong(this.getFieldIndex("mversionid"))));
        QFilter ccAndcoFilter = new QFilter("1", "!=", (Object)"1");
        for (Map.Entry costenterAndCostObject : costenterAndCostObjects.entrySet()) {
            QFilter tempFilter = new QFilter("costcenter", "=", costenterAndCostObject.getKey());
            tempFilter.and(new QFilter("costobject", "in", costenterAndCostObject.getValue()));
            ccAndcoFilter.or(tempFilter);
        }
        filters.add(ccAndcoFilter);
        return filters;
    }

    private int getFieldIndex(String fieldName) {
        return this.getResultRowMeta().getFieldIndex(fieldName);
    }
}

