/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.sca.algox.costrec.CostRecoveryParams;
import kd.macc.sca.algox.costrec.HalfprdStructureInfo;
import kd.macc.sca.algox.costrec.HalfprdStructureParams;
import kd.macc.sca.algox.utils.CostRecoveryHelper;
import org.apache.commons.lang3.StringUtils;

public class BopHalfprdStructureEngine {
    private static final Log logger = LogFactory.getLog(BopHalfprdStructureEngine.class);
    private static final String ALGOKEY = "kd.macc.sca.mservice.recovery.BopHalfprdStructureEngine.";

    public void genBopHalfprdStructure(CostRecoveryParams crParams) {
        if (SysParamEnum.RESTOREDIMENSION_ORG.getValue().equals(crParams.getCalDimension())) {
            HalfprdStructureParams hrParam = new HalfprdStructureParams();
            hrParam.setCalOrgId(crParams.getCalOrgId());
            hrParam.setCostAccountId(crParams.getCostAccountId());
            hrParam.setManuOrgId(0L);
            hrParam.setStOrgId(0L);
            hrParam.setPeriodId(crParams.getPeriodId());
            hrParam.setPriceScale(crParams.getPriceScale());
            this.genBopHalfprdStructure(hrParam);
        } else if (crParams.getManuOrgId() > 0L) {
            HalfprdStructureParams hrParam = new HalfprdStructureParams();
            hrParam.setCalOrgId(crParams.getCalOrgId());
            hrParam.setCostAccountId(crParams.getCostAccountId());
            hrParam.setManuOrgId(crParams.getManuOrgId());
            hrParam.setPeriodId(crParams.getPeriodId());
            hrParam.setPriceScale(crParams.getPriceScale());
            List stOrgs = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)crParams.getManuOrgId(), (boolean)true);
            for (Long storg : stOrgs) {
                hrParam.setStOrgId(storg);
                this.genBopHalfprdStructure(hrParam);
            }
        } else {
            for (Map.Entry<Long, Long> entry : crParams.getRelaOrgCostAccountMap().entrySet()) {
                HalfprdStructureParams hrParam = new HalfprdStructureParams();
                hrParam.setCalOrgId(entry.getKey());
                hrParam.setCostAccountId(entry.getValue());
                hrParam.setPeriodId(crParams.getPeriodId());
                hrParam.setPriceScale(crParams.getPriceScale());
                hrParam.setManuOrgId(0L);
                List<Long> orgToStOrgs = CostRecoveryHelper.getOrgToStOrg(entry.getKey());
                for (Long stOrg : orgToStOrgs) {
                    hrParam.setStOrgId(stOrg);
                    this.genBopHalfprdStructure(hrParam);
                }
                List manuOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)hrParam.getCalOrgId(), (boolean)true);
                for (Long manuOrg : manuOrgs) {
                    hrParam.setManuOrgId(manuOrg);
                    List stOrgs = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)manuOrg, (boolean)true);
                    for (Long storg : stOrgs) {
                        hrParam.setStOrgId(storg);
                        this.genBopHalfprdStructure(hrParam);
                    }
                }
            }
        }
    }

    public void genBopHalfprdStructure(HalfprdStructureParams hrParam) {
        HashSet<Long> unRecoveryMaterialIdSet = new HashSet<Long>();
        HashSet<Long> unRecoverySubMaterialIdSet = new HashSet<Long>();
        CostRecoveryHelper.buildUnRecoveryMaterial(hrParam.getCalOrgId(), hrParam.getCostAccountId(), hrParam.getManuOrgId(), unRecoveryMaterialIdSet, unRecoverySubMaterialIdSet, null);
        QFilter eleTypeFilter = new QFilter("entryentity.subelement.type", "in", (Object)new String[]{"001"});
        eleTypeFilter.and("entryentity.isunabsorb", "=", (Object)"A");
        QFilter baseFilter = new QFilter("costaccount", "=", (Object)hrParam.getCostAccountId());
        baseFilter.and("period", "=", (Object)hrParam.getPeriodId());
        baseFilter.and("prdorg", "=", (Object)hrParam.getManuOrgId());
        baseFilter.and("billstatus", "=", (Object)"C");
        QFilter stOrgFilter = new QFilter("storageorgunit", "=", (Object)0L);
        if (hrParam.getStOrgId() != 0L) {
            stOrgFilter = hrParam.getManuOrgId() == 0L ? new QFilter("storageorgunit", "=", (Object)hrParam.getStOrgId()) : new QFilter("storageorgunit", "in", (Object)new Long[]{hrParam.getStOrgId(), 0L});
            baseFilter.and(stOrgFilter);
        } else {
            baseFilter.and(stOrgFilter);
        }
        Set<HalfprdStructureInfo> hightMatInfos = this.getTopMatIds(hrParam, baseFilter);
        Set<Long> matIds = new HashSet<Long>(5);
        Set nextLevelMatIds = new HashSet();
        for (HalfprdStructureInfo hightMatInfo : hightMatInfos) {
            matIds.add(hightMatInfo.getMaterialId());
        }
        Set<Long> reCalcMatIds = this.getRecalcMatIds(hrParam, baseFilter);
        QFilter matFilter = new QFilter("material", "in", reCalcMatIds);
        DeleteServiceHelper.delete((String)"sca_halfprdhide", (QFilter[])new QFilter[]{baseFilter, matFilter});
        DataSet changedProducts = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_halfprdhide", (String)"material as materialId", (QFilter[])new QFilter[]{baseFilter, new QFilter("entryentity.submaterial", "in", reCalcMatIds)}, null);
        for (Row row : changedProducts) {
            reCalcMatIds.add(row.getLong("materialId"));
        }
        CostRecoveryHelper.logInfoIdSet(logger, "reCalcMatIds", reCalcMatIds);
        this.createHalfprdstructureInfos(hrParam, baseFilter, eleTypeFilter, Sets.newHashSet(reCalcMatIds), unRecoveryMaterialIdSet);
        HashSet needExpendMatSet = Sets.newHashSet();
        DataSet changedProductsForMuilt = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_halfprdstructure", (String)"entryentity.submaterial as submaterialId", (QFilter[])new QFilter[]{baseFilter, new QFilter("material", "in", reCalcMatIds)}, null);
        for (Row row : changedProductsForMuilt) {
            needExpendMatSet.add(row.getLong("submaterialId"));
        }
        needExpendMatSet.removeAll(reCalcMatIds);
        CostRecoveryHelper.logInfoIdSet(logger, "needExpendMatSet", needExpendMatSet);
        HashSet allRecalMatIds = Sets.newHashSet();
        allRecalMatIds.addAll(reCalcMatIds);
        allRecalMatIds.addAll(needExpendMatSet);
        HashSet existsTreepath = Sets.newHashSet();
        HashSet notDeleted = Sets.newHashSet();
        for (int index = 0; index < 30 && matIds.size() != 0; ++index) {
            matIds.retainAll(allRecalMatIds);
            nextLevelMatIds = new HashSet();
            Tuple<HashSet<Long>, HashMap<String, Set<HalfprdStructureInfo>>> result = this.getHalfprdstructureInfos(hrParam, baseFilter, matIds);
            nextLevelMatIds = (Set)result.item1;
            Map parentAndSubInfosMap = (Map)result.item2;
            this.updateHalfprdStrctHideNew(hrParam, baseFilter, eleTypeFilter, matIds, unRecoverySubMaterialIdSet, unRecoveryMaterialIdSet, parentAndSubInfosMap, reCalcMatIds, needExpendMatSet, allRecalMatIds, existsTreepath, notDeleted);
            matIds = nextLevelMatIds;
        }
    }

    private Set<HalfprdStructureInfo> getTopMatIds(HalfprdStructureParams hrParam, QFilter baseFilter) {
        QFilter eleTypeFilter = new QFilter("entryentity.subelement.type", "in", (Object)new String[]{"001"});
        eleTypeFilter.and("entryentity.isunabsorb", "=", (Object)"A");
        DataSet halfprdStructureData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_halfprdstructure", (String)this.getHalfprdstructurefields(), (QFilter[])new QFilter[]{baseFilter, eleTypeFilter}, null);
        HashSet<HalfprdStructureInfo> hightMatInfos = new HashSet<HalfprdStructureInfo>();
        HashSet<HalfprdStructureInfo> subMatInfos = new HashSet<HalfprdStructureInfo>();
        for (Row row : halfprdStructureData) {
            HalfprdStructureInfo parentMatInfo = new HalfprdStructureInfo();
            parentMatInfo.setMaterialId(row.getLong("materialId"));
            parentMatInfo.setMatverId(row.getLong("matverId"));
            parentMatInfo.setAuxpropId(row.getLong("auxpropId"));
            hightMatInfos.add(parentMatInfo);
            HalfprdStructureInfo subMatInfo = new HalfprdStructureInfo();
            subMatInfo.setMaterialId(row.getLong("submaterialId"));
            subMatInfo.setMatverId(row.getLong("submatverId"));
            subMatInfo.setAuxpropId(row.getLong("subauxpropId"));
            subMatInfos.add(subMatInfo);
        }
        for (HalfprdStructureInfo subMatInfo : subMatInfos) {
            hightMatInfos.remove(subMatInfo);
        }
        return hightMatInfos;
    }

    private Tuple<HashSet<Long>, HashMap<String, Set<HalfprdStructureInfo>>> getHalfprdstructureInfos(HalfprdStructureParams hrParam, QFilter baseFilter, Set<Long> matIds) {
        Tuple result = new Tuple(new HashSet(16), new HashMap(16));
        HashMap<String, Set<HalfprdStructureInfo>> parentAndSubInfosMap = new HashMap<String, Set<HalfprdStructureInfo>>();
        HashSet<Long> nextLevelMats = new HashSet<Long>(16);
        QFilter parentMatFilter = new QFilter("material", "in", matIds);
        DataSet parentHalfprdStructureData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_halfprdstructure", (String)this.getHalfprdstructurefields(), (QFilter[])new QFilter[]{baseFilter, parentMatFilter}, null);
        if (parentHalfprdStructureData.isEmpty()) {
            return result;
        }
        for (Row row : parentHalfprdStructureData) {
            Set<HalfprdStructureInfo> submatInfos;
            String key = row.getString("materialId") + "@" + row.getString("matverId") + "@" + row.getString("auxpropId");
            HalfprdStructureInfo subMatInfo = this.buildHalfprdStructureInfo(row);
            if ("001".equals(row.getString("subelementType"))) {
                nextLevelMats.add(row.getLong("submaterialId"));
            }
            if (parentAndSubInfosMap.containsKey(key)) {
                submatInfos = (Set)parentAndSubInfosMap.get(key);
                if (submatInfos.contains(subMatInfo)) {
                    for (HalfprdStructureInfo oldSubMatInfo : submatInfos) {
                        if (!oldSubMatInfo.equals(subMatInfo)) continue;
                        BigDecimal newSubmatAmt = this.getBigDecimalZero(subMatInfo.getSubmatAmt());
                        BigDecimal oldeSubmatAmt = this.getBigDecimalZero(oldSubMatInfo.getSubmatAmt());
                        BigDecimal newSubmatQty = this.getBigDecimalZero(subMatInfo.getSubmatQty());
                        BigDecimal oldSubmatQty = this.getBigDecimalZero(oldSubMatInfo.getSubmatQty());
                        BigDecimal newSubmatAmtCoef = this.getBigDecimalZero(subMatInfo.getSubmatAmtCoef());
                        BigDecimal oldSubmatAmtCoef = this.getBigDecimalZero(oldSubMatInfo.getSubmatAmtCoef());
                        oldSubMatInfo.setSubmatAmt(newSubmatAmt.add(oldeSubmatAmt));
                        oldSubMatInfo.setSubmatQty(newSubmatQty.add(oldSubmatQty));
                        oldSubMatInfo.setSubmatAmtCoef(newSubmatAmtCoef.add(oldSubmatAmtCoef));
                        break;
                    }
                }
                submatInfos.add(subMatInfo);
                continue;
            }
            submatInfos = new HashSet();
            submatInfos.add(subMatInfo);
            parentAndSubInfosMap.put(key, submatInfos);
        }
        return new Tuple(nextLevelMats, parentAndSubInfosMap);
    }

    private HalfprdStructureInfo buildHalfprdStructureInfo(Row row) {
        HalfprdStructureInfo subMatInfo = new HalfprdStructureInfo();
        subMatInfo.setElementId(row.getLong("elementId"));
        subMatInfo.setSubelementId(row.getLong("subelementId"));
        subMatInfo.setElementtype(row.getString("subelementType"));
        subMatInfo.setSubmaterialId(row.getLong("submaterialId"));
        subMatInfo.setSubmatverId(row.getLong("submatverId"));
        subMatInfo.setSubauxpropId(row.getLong("subauxpropId"));
        subMatInfo.setSubmatQty(row.getBigDecimal("subQty"));
        subMatInfo.setSubmatAmtCoef(row.getBigDecimal("subAmtCoef"));
        subMatInfo.setIsunabsorb(row.getString("isunabsorb"));
        subMatInfo.setLevel(row.getInteger("level"));
        subMatInfo.setTreepath(row.getString("treepath"));
        return subMatInfo;
    }

    private void updateHalfprdStrctHideNew(HalfprdStructureParams hrParam, QFilter baseFilter, QFilter eleTypeFilter, Set<Long> matIds, Set<Long> unRecoverySubMaterialIdSet, Set<Long> unRecoveryMaterialIdSet, Map<String, Set<HalfprdStructureInfo>> parentAndSubInfosMap, Set<Long> reCalcMatIds, Set<Long> needExpendMatSet, Set<Long> allRecalMatIds, Set<String> existsTreepath, Set<String> notDeletedSet) {
        String userId = RequestContext.get().getUserId();
        Date date = TimeServiceHelper.now();
        QFilter subMatFilter = new QFilter("entryentity.submaterial", "in", matIds);
        subMatFilter = subMatFilter.and("material", "in", allRecalMatIds);
        DynamicObject[] subHalfprdStructures = BusinessDataServiceHelper.load((String)"sca_halfprdhide", (String)(this.getHalfprdStcHideFiledsByObj() + ",level"), (QFilter[])new QFilter[]{baseFilter, subMatFilter, eleTypeFilter});
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(16);
        if (subHalfprdStructures != null && subHalfprdStructures.length > 0) {
            for (DynamicObject subHalfprdStructure : subHalfprdStructures) {
                BigDecimal totalAmt = subHalfprdStructure.getBigDecimal("totalamount");
                DynamicObjectCollection entrys = subHalfprdStructure.getDynamicObjectCollection("entryentity");
                logger.info("BopHalfprdStructureEngine\u2014\u2014>materialid:" + subHalfprdStructure.getString("material.id") + ",entrys:" + entrys.size() + "\u6761");
                Long materialId = subHalfprdStructure.getLong("material.id");
                ArrayList<DynamicObject> removeEntrys = new ArrayList<DynamicObject>();
                HashSet deletedMatSet = Sets.newHashSet();
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    String treepath = entry.getString("treepath");
                    for (Long matId : matIds) {
                        if (!reCalcMatIds.contains(matId) && (!needExpendMatSet.contains(matId) || !reCalcMatIds.contains(materialId))) continue;
                        if (treepath.indexOf(matId + "@") > 0 && !notDeletedSet.contains(treepath)) {
                            removeEntrys.add(entry);
                        }
                        deletedMatSet.add(matId);
                    }
                }
                for (DynamicObject removeEntry : removeEntrys) {
                    entrys.remove((Object)removeEntry);
                }
                int entryLenght = entrys.size();
                BigDecimal oneTotalAmt = BigDecimal.ZERO;
                for (int i = 0; i < entryLenght; ++i) {
                    if (((DynamicObject)entrys.get(i)).getInt("level") != 1) continue;
                    oneTotalAmt = oneTotalAmt.add(((DynamicObject)entrys.get(i)).getBigDecimal("amount"));
                }
                if (totalAmt.compareTo(oneTotalAmt) != 0) {
                    totalAmt = oneTotalAmt;
                }
                boolean needSave = false;
                for (int i = 0; i < entryLenght; ++i) {
                    String parentTreePath;
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    if (subHalfprdStructure.getLong("material.id") == entry.getLong("submaterial.id") || unRecoverySubMaterialIdSet.contains(entry.getLong("submaterial.id")) || unRecoveryMaterialIdSet.contains(entry.getLong("submaterial.id")) || !deletedMatSet.contains(entry.getLong("submaterial.id")) || !"001".equals(entry.getString("subelement.type")) || entry.getString("isunabsorb").equals("B") || existsTreepath.contains(parentTreePath = entry.getString("treepath"))) continue;
                    Long tmpSubMaterialId = entry.getLong("submaterial.id");
                    boolean isMuilt = !reCalcMatIds.contains(tmpSubMaterialId);
                    ArrayList subMatList = Lists.newArrayList();
                    if (isMuilt) {
                        DataSet prdHideDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sca_halfprdhide", (String)this.getHalfprdStructureFileds(), (QFilter[])new QFilter[]{baseFilter, new QFilter("material", "=", (Object)tmpSubMaterialId)}, (String)"entryentity.level");
                        for (Row row : prdHideDataSet) {
                            int level = row.getInteger("level");
                            if (subMatList.size() < level) {
                                subMatList.add(Sets.newHashSet());
                            }
                            Set tmpSet = (Set)subMatList.get(level - 1);
                            HalfprdStructureInfo subMatInfo = this.buildHalfprdStructureInfo(row);
                            tmpSet.add(subMatInfo);
                        }
                    } else {
                        String matver = entry.getString("submaterialversion.id") == null ? "0" : entry.getString("submaterialversion.id");
                        String auxprop = entry.getString("submaterialauxprop.id") == null ? "0" : entry.getString("submaterialauxprop.id");
                        String key = entry.getString("submaterial.id") + "@" + matver + "@" + auxprop;
                        Set<HalfprdStructureInfo> submatInfos = parentAndSubInfosMap.get(key);
                        if (submatInfos != null) {
                            subMatList.add(submatInfos);
                        }
                    }
                    Long level = entry.getLong("level");
                    BigDecimal unitQty = entry.getBigDecimal("qty");
                    BigDecimal unitAmt = entry.getBigDecimal("amount");
                    if (subMatList == null || subMatList.isEmpty()) continue;
                    needSave = true;
                    existsTreepath.add(parentTreePath);
                    HashMap currDifAmtMap = Maps.newHashMapWithExpectedSize((int)16);
                    currDifAmtMap.put(parentTreePath, unitAmt);
                    for (Set tmpSubmatInfos : subMatList) {
                        HashMap tmpRowMap = Maps.newHashMapWithExpectedSize((int)64);
                        HashMap difAmtMap = Maps.newHashMapWithExpectedSize((int)64);
                        ArrayList newEntrys = Lists.newArrayListWithExpectedSize((int)64);
                        for (HalfprdStructureInfo halfprdStructureInfo : tmpSubmatInfos) {
                            BigDecimal compareAmt;
                            BigDecimal currAllocedAmt = halfprdStructureInfo.getSubmatAmtCoef().multiply(unitAmt).setScale(hrParam.getPriceScale(), RoundingMode.HALF_UP);
                            if (BigDecimal.ZERO.compareTo(currAllocedAmt) == 0) continue;
                            DynamicObject newSubmatInfso = entrys.addNew();
                            newEntrys.add(newSubmatInfso);
                            newSubmatInfso.set("level", (Object)(level + (long)halfprdStructureInfo.getLevel().intValue()));
                            newSubmatInfso.set("element", (Object)halfprdStructureInfo.getElementId());
                            newSubmatInfso.set("subelement", (Object)halfprdStructureInfo.getSubelementId());
                            if (isMuilt) {
                                newSubmatInfso.set("submaterial", (Object)halfprdStructureInfo.getSubmaterialId());
                                newSubmatInfso.set("treepath", (Object)(parentTreePath.substring(0, parentTreePath.lastIndexOf("@")) + "@" + halfprdStructureInfo.getTreepath()));
                            } else {
                                if (!"001".equals(halfprdStructureInfo.getElementtype()) && !"002".equals(halfprdStructureInfo.getElementtype())) {
                                    newSubmatInfso.set("submaterial", (Object)entry.getString("submaterial.id"));
                                } else {
                                    newSubmatInfso.set("submaterial", (Object)halfprdStructureInfo.getSubmaterialId());
                                }
                                if ("001".equals(halfprdStructureInfo.getElementtype())) {
                                    newSubmatInfso.set("treepath", (Object)(parentTreePath + "@" + halfprdStructureInfo.getSubmaterialId()));
                                } else {
                                    newSubmatInfso.set("treepath", (Object)(parentTreePath + "@0"));
                                }
                            }
                            notDeletedSet.add(newSubmatInfso.getString("treepath"));
                            String treepath = newSubmatInfso.getString("treepath");
                            String tmpTree = treepath.substring(0, treepath.lastIndexOf("@"));
                            newSubmatInfso.set("submaterialversion", (Object)halfprdStructureInfo.getSubmatverId());
                            newSubmatInfso.set("submaterialauxprop", (Object)halfprdStructureInfo.getSubauxpropId());
                            newSubmatInfso.set("isunabsorb", (Object)halfprdStructureInfo.getIsunabsorb());
                            newSubmatInfso.set("qty", (Object)halfprdStructureInfo.getSubmatQty().multiply(unitQty));
                            newSubmatInfso.set("amount", (Object)currAllocedAmt);
                            if (totalAmt != null && totalAmt.compareTo(BigDecimal.ZERO) != 0) {
                                BigDecimal amountcoeff = currAllocedAmt.divide(totalAmt, 10, RoundingMode.HALF_UP);
                                newSubmatInfso.set("amountcoeff", (Object)amountcoeff);
                            }
                            if ((compareAmt = difAmtMap.computeIfAbsent(tmpTree, p -> BigDecimal.ZERO)) == null || currAllocedAmt.compareTo(compareAmt) > 0) {
                                compareAmt = currAllocedAmt;
                                difAmtMap.put(tmpTree, currAllocedAmt);
                                tmpRowMap.put(tmpTree, newSubmatInfso);
                            }
                            BigDecimal tmp = (BigDecimal)currDifAmtMap.get(tmpTree);
                            currDifAmtMap.put(tmpTree, tmp.subtract(currAllocedAmt));
                        }
                        for (Map.Entry entry2 : currDifAmtMap.entrySet()) {
                            DynamicObject row;
                            String tmpParentTreePath = (String)entry2.getKey();
                            BigDecimal difAmt = (BigDecimal)entry2.getValue();
                            if (BigDecimal.ZERO.compareTo(difAmt) == 0 || (row = (DynamicObject)tmpRowMap.get(tmpParentTreePath)) == null) continue;
                            BigDecimal bigde = row.getBigDecimal("amount");
                            bigde = bigde.add(difAmt);
                            row.set("amount", (Object)bigde);
                            if (totalAmt == null || totalAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                            row.set("amountcoeff", (Object)bigde.divide(totalAmt, 10, RoundingMode.HALF_UP));
                        }
                        currDifAmtMap.clear();
                        for (DynamicObject dynamicObject : newEntrys) {
                            currDifAmtMap.put(dynamicObject.getString("treepath"), dynamicObject.getBigDecimal("amount"));
                        }
                    }
                    logger.info("BopHalfprdStructureEngine\u2014\u2014>materialid:" + subHalfprdStructure.getString("material.id") + ",added new entrys:" + entrys.size() + "\u6761");
                    if (entrys.size() - entryLenght <= 0) continue;
                    HashSet<String> parentTreepathSet = new HashSet<String>();
                    for (DynamicObject newSubmatInfso : entrys) {
                        String treepath = newSubmatInfso.getString("treepath");
                        parentTreepathSet.add(treepath.substring(0, treepath.lastIndexOf("@")));
                    }
                    for (DynamicObject newSubmatInfso : entrys) {
                        String isleaf = newSubmatInfso.getString("isleaf");
                        if (parentTreepathSet.contains(newSubmatInfso.getString("treepath"))) {
                            if (!StringUtils.isEmpty((CharSequence)isleaf) && !"true".equals(isleaf)) continue;
                            newSubmatInfso.set("isleaf", (Object)"0");
                            continue;
                        }
                        if (!StringUtils.isEmpty((CharSequence)isleaf) && !"false".equals(isleaf)) continue;
                        newSubmatInfso.set("isleaf", (Object)"1");
                    }
                }
                if (needSave) {
                    if (totalAmt != null && totalAmt.compareTo(BigDecimal.ZERO) != 0) {
                        for (DynamicObject entry : entrys) {
                            BigDecimal amountcoeffCr;
                            BigDecimal amountcoeff = entry.getBigDecimal("amountcoeff");
                            if (amountcoeff.compareTo(amountcoeffCr = entry.getBigDecimal("amount").divide(totalAmt, 10, RoundingMode.HALF_UP)) == 0) continue;
                            entry.set("amountcoeff", (Object)amountcoeffCr);
                        }
                    }
                    subHalfprdStructure.set("modifier", (Object)userId);
                    subHalfprdStructure.set("modifytime", (Object)date);
                    subHalfprdStructure.set("auditor", (Object)userId);
                    subHalfprdStructure.set("auditdate", (Object)date);
                    saveList.add(subHalfprdStructure);
                }
                if (saveList.size() < 1) continue;
                Long starttime = System.currentTimeMillis();
                logger.info("BopHalfprdStructureEngine\u2014\u2014>saveList.size:" + saveList.size());
                SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                Long endtime = System.currentTimeMillis();
                logger.info("BopHalfprdStructureEngine\u2014\u2014>228\u884c\u4fdd\u5b58\u8017\u65f6\uff1a" + (endtime - starttime) / 1000L + "\u79d2");
                saveList.clear();
            }
            if (saveList.size() > 0) {
                Long starttime = System.currentTimeMillis();
                SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                saveList.clear();
                Long endtime = System.currentTimeMillis();
                logger.info("BopHalfprdStructureEngine\u2014\u2014>228\u884c\u4fdd\u5b58\u8017\u65f6\uff1a" + (endtime - starttime) / 1000L + "\u79d2");
            }
        }
    }

    private void createHalfprdstructureInfos(HalfprdStructureParams hrParam, QFilter baseFilter, QFilter eleTypeFilter, Set<Long> matIds, Set<Long> unRecoveryMaterialIdSet) {
        String userId = RequestContext.get().getUserId();
        Date date = TimeServiceHelper.now();
        QFilter parentMatFilter = new QFilter("material", "in", matIds);
        DataSet parHalfprdStructuresDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_halfprdhide", (String)this.getHalfprdStructureFileds(), (QFilter[])new QFilter[]{baseFilter, parentMatFilter}, null);
        for (Row row : parHalfprdStructuresDataSet) {
            matIds.remove(row.getLong("materialId"));
        }
        QFilter noRecoveryMatFilter = new QFilter("material", "not in", unRecoveryMaterialIdSet);
        DynamicObject[] halfprdStructures = BusinessDataServiceHelper.load((String)"sca_halfprdstructure", (String)this.getHalfprdStcFiledsByObj(), (QFilter[])new QFilter[]{baseFilter, parentMatFilter, noRecoveryMatFilter});
        ArrayList<DynamicObject> halfprdhideInfos = new ArrayList<DynamicObject>(halfprdStructures.length);
        for (DynamicObject halfprdStructure : halfprdStructures) {
            DynamicObject halfprdhideInfo = BusinessDataServiceHelper.newDynamicObject((String)"sca_halfprdhide");
            halfprdhideInfo.set("org", halfprdStructure.get("org"));
            halfprdhideInfo.set("costaccount", halfprdStructure.get("costaccount"));
            halfprdhideInfo.set("prdorg", halfprdStructure.get("prdorg"));
            halfprdhideInfo.set("storageorgunit", (Object)hrParam.getStOrgId());
            halfprdhideInfo.set("currency", halfprdStructure.get("currency"));
            halfprdhideInfo.set("period", halfprdStructure.get("period"));
            halfprdhideInfo.set("material", halfprdStructure.get("material"));
            halfprdhideInfo.set("materialversion", halfprdStructure.get("materialversion"));
            halfprdhideInfo.set("auxprop", halfprdStructure.get("auxprop"));
            halfprdhideInfo.set("totalamount", halfprdStructure.get("totalamount"));
            halfprdhideInfo.set("billstatus", (Object)"C");
            halfprdhideInfo.set("creator", (Object)userId);
            halfprdhideInfo.set("createtime", (Object)date);
            halfprdhideInfo.set("modifier", (Object)userId);
            halfprdhideInfo.set("modifytime", (Object)date);
            halfprdhideInfo.set("auditor", (Object)userId);
            halfprdhideInfo.set("auditdate", (Object)date);
            DynamicObjectCollection entrys = halfprdStructure.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection entrys_hides = halfprdhideInfo.getDynamicObjectCollection("entryentity");
            HashMap<String, Integer> matAndIndexMap = new HashMap<String, Integer>();
            for (DynamicObject entry : entrys) {
                String auxprop;
                BigDecimal qty = this.getBigDecimalZero(entry.getBigDecimal("qty"));
                BigDecimal amt = this.getBigDecimalZero(entry.getBigDecimal("amount"));
                String matver = entry.getString("submaterialversion.id") == null ? "0" : entry.getString("submaterialversion.id");
                String string = auxprop = entry.getString("submaterialauxprop.id") == null ? "0" : entry.getString("submaterialauxprop.id");
                if (BigDecimal.ZERO.compareTo(qty) == 0 && BigDecimal.ZERO.compareTo(amt) == 0) continue;
                String entryKey = entry.getString("submaterial.id") + "@" + matver + "@" + auxprop + "@" + entry.getString("element.id") + "@" + entry.getString("subelement.id");
                if (matAndIndexMap.containsKey(entryKey)) {
                    DynamicObject oldEntry = (DynamicObject)entrys_hides.get(((Integer)matAndIndexMap.get(entryKey)).intValue());
                    oldEntry.set("qty", (Object)oldEntry.getBigDecimal("qty").add(entry.getBigDecimal("qty")));
                    oldEntry.set("amount", (Object)oldEntry.getBigDecimal("amount").add(entry.getBigDecimal("amount")));
                    if (halfprdStructure.getBigDecimal("totalamount") == null || BigDecimal.ZERO.compareTo(halfprdStructure.getBigDecimal("totalamount")) == 0) continue;
                    oldEntry.set("amountcoeff", (Object)oldEntry.getBigDecimal("amount").divide(halfprdStructure.getBigDecimal("totalamount"), 10, RoundingMode.HALF_UP));
                    continue;
                }
                DynamicObject entrys_hide = entrys_hides.addNew();
                matAndIndexMap.put(entryKey, entrys_hides.size() - 1);
                entrys_hide.set("element", entry.get("element"));
                entrys_hide.set("subelement", entry.get("subelement"));
                entrys_hide.set("level", (Object)1);
                if (!"001".equals(entry.getString("subelement.type")) && !"002".equals(entry.getString("subelement.type"))) {
                    entrys_hide.set("submaterial", halfprdStructure.get("material.id"));
                    entrys_hide.set("isleaf", (Object)1);
                } else {
                    entrys_hide.set("submaterial", entry.get("submaterial"));
                    entrys_hide.set("isleaf", (Object)1);
                }
                if ("001".equals(entry.getString("subelement.type"))) {
                    entrys_hide.set("treepath", (Object)(halfprdhideInfo.get("material.id") + "@" + entry.get("submaterial.id")));
                } else {
                    entrys_hide.set("treepath", (Object)(halfprdhideInfo.get("material.id") + "@0"));
                }
                entrys_hide.set("isunabsorb", (Object)entry.getString("isunabsorb"));
                entrys_hide.set("submaterialversion", entry.get("submaterialversion"));
                entrys_hide.set("submaterialauxprop", entry.get("submaterialauxprop"));
                entrys_hide.set("qty", entry.get("qty"));
                entrys_hide.set("amount", entry.get("amount"));
                entrys_hide.set("vrtdionno", entry.get("vrtdionno"));
                if (halfprdStructure.getBigDecimal("totalamount") == null || BigDecimal.ZERO.compareTo(halfprdStructure.getBigDecimal("totalamount")) == 0) continue;
                entrys_hide.set("amountcoeff", (Object)entry.getBigDecimal("amount").divide(halfprdStructure.getBigDecimal("totalamount"), 10, RoundingMode.HALF_UP));
            }
            BigDecimal sumcoeff = BigDecimal.ZERO;
            int maxAmountIndex = 0;
            for (int i = 0; i < entrys_hides.size(); ++i) {
                ((DynamicObject)entrys_hides.get(i)).set("issprit", (Object)1);
                sumcoeff = sumcoeff.add(((DynamicObject)entrys_hides.get(i)).getBigDecimal("amountcoeff"));
                if (((DynamicObject)entrys_hides.get(maxAmountIndex)).getBigDecimal("amount").compareTo(((DynamicObject)entrys_hides.get(i)).getBigDecimal("amount")) >= 0) continue;
                maxAmountIndex = i;
            }
            if (sumcoeff.compareTo(new BigDecimal(1)) != 0) {
                sumcoeff = new BigDecimal(1).subtract(sumcoeff);
                ((DynamicObject)entrys_hides.get(maxAmountIndex)).set("amountcoeff", (Object)sumcoeff.add(((DynamicObject)entrys_hides.get(maxAmountIndex)).getBigDecimal("amountcoeff")));
            }
            halfprdhideInfos.add(halfprdhideInfo);
        }
        SaveServiceHelper.save((DynamicObject[])halfprdhideInfos.toArray(new DynamicObject[0]));
    }

    private Set<Long> getRecalcMatIds(HalfprdStructureParams hrParam, QFilter baseFilter) {
        HashSet<Long> reqRecalcMatIds = new HashSet<Long>();
        HashSet<Long> prdMatIds = new HashSet<Long>();
        HashSet<Long> prdHideMatIds = new HashSet<Long>();
        DataSet halfprdStructureData = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_halfprdstructure", (String)"material as materialId,ismodify", (QFilter[])new QFilter[]{baseFilter}, null);
        for (Row row : halfprdStructureData) {
            Long materialId = row.getLong("materialId");
            if (row.getBoolean("ismodify").booleanValue()) {
                reqRecalcMatIds.add(materialId);
            }
            prdMatIds.add(materialId);
        }
        DataSet halfHidePrd = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_halfprdhide", (String)"material as materialId", (QFilter[])new QFilter[]{baseFilter}, null);
        for (Row row : halfHidePrd) {
            prdHideMatIds.add(row.getLong("materialId"));
        }
        prdHideMatIds.removeAll(prdMatIds);
        reqRecalcMatIds.addAll(prdHideMatIds);
        return reqRecalcMatIds;
    }

    private String getHalfprdstructurefields() {
        String selectFields = "material as materialId,materialversion matverId,auxprop.id as auxpropId,totalamount,entryentity.submaterial as submaterialId,entryentity.submaterialversion as submatverId,entryentity.submaterialauxprop as subauxpropId,entryentity.element as elementId,entryentity.subelement.id as subelementId,entryentity.qty as subQty,entryentity.subelement.type as subelementType,entryentity.amount as subAmt,entryentity.amount/totalamount as subAmtCoef,entryentity.vrtdionno as vrtdionno,entryentity.isunabsorb as isunabsorb,1 as level,entryentity.submaterial as treepath";
        return selectFields;
    }

    private String getHalfprdStructureFileds() {
        String selectFieldsHide = "material as materialId,materialversion matverId,auxprop.id as auxpropId,totalamount,entryentity.submaterial as submaterialId,entryentity.submaterialversion as submatverId,entryentity.submaterialauxprop as subauxpropId,entryentity.element as elementId,entryentity.subelement.id as subelementId,entryentity.qty as subQty,entryentity.subelement.type as subelementType,entryentity.amount as subAmt,entryentity.amountcoeff as subAmtCoef,entryentity.treepath as treepath,entryentity.vrtdionno as vrtdionno,entryentity.isunabsorb as isunabsorb,entryentity.level as level";
        return selectFieldsHide;
    }

    private String getHalfprdStcHideFiledsByObj() {
        String selectFieldshide = "org,costaccount,prdorg,currency,period,material,materialversion,auxprop.id,totalamount,creator,createtime,modifier,modifytime,auditor,auditdate,entryentity.submaterial,entryentity.submaterialversion,entryentity.submaterialauxprop,entryentity.element ,entryentity.subelement,entryentity.subelement.type as subelementType,entryentity.qty,entryentity.amount,entryentity.amountcoeff,entryentity.treepath,entryentity.vrtdionno,entryentity.isunabsorb,entryentity.isleaf,entryentity.issprit,entryentity.isunabsorb";
        return selectFieldshide;
    }

    private String getHalfprdStcFiledsByObj() {
        String selectFields = "org,costaccount,prdorg,currency,period,material,materialversion,auxprop.id,totalamount,creator,createtime,modifier,modifytime,auditor,auditdate,entryentity.submaterial,entryentity.submaterialversion,entryentity.submaterialauxprop,entryentity.element ,entryentity.subelement,entryentity.qty,entryentity.amount,entryentity.amountcoeff,entryentity.treepath,entryentity.vrtdionno,entryentity.isunabsorb,entryentity.isleaf";
        return selectFields;
    }

    private BigDecimal getBigDecimalZero(BigDecimal value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return value;
    }
}

