/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.FlexProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.CalcKeycolHelper;
import kd.macc.sca.algox.costrec.CostRecoveryParams;
import kd.macc.sca.algox.restore.common.DiffCalcHelper;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import org.apache.commons.lang3.StringUtils;

public class CostRecCalcHelper {
    private static final Log logger = LogFactory.getLog(CostRecCalcHelper.class);

    public static Set<Long> getMaterialIdFromKey(Set<String> allMaterialIdSet) {
        HashSet<Long> materialIds = new HashSet<Long>(10);
        CostRecCalcHelper.getMaterialIdFromKey(allMaterialIdSet, materialIds, null);
        return materialIds;
    }

    public static void getMaterialIdFromKey(Set<String> allMaterialIdSet, Set<Long> materialIds, Set<Long> calckeyIds) {
        for (String matKey : allMaterialIdSet) {
            String[] keyCols = matKey.split("-");
            if (materialIds != null) {
                materialIds.add(Long.parseLong(keyCols[0]));
            }
            if (calckeyIds == null || keyCols.length <= 1) continue;
            calckeyIds.add(Long.parseLong(keyCols[1]));
        }
    }

    public static QFilter getMatKeyQFilter(Set<String> reCalcMatIds, String matField, String keyField) {
        HashSet<Long> materialIds = new HashSet<Long>(10);
        HashSet<Long> calckeyIds = new HashSet<Long>(10);
        for (String keycol : reCalcMatIds) {
            String[] cols = keycol.split("-");
            materialIds.add(Long.parseLong(cols[0]));
            calckeyIds.add(Long.parseLong(cols[1]));
        }
        QFilter filter = new QFilter(matField, "in", materialIds);
        filter.and(keyField, "in", calckeyIds);
        return filter;
    }

    public static QFilter getMatKeyQFilter(String reCalcMatId, String matField, String keyField) {
        String[] cols = reCalcMatId.split("-");
        QFilter filter = new QFilter(matField, "in", (Object)Long.parseLong(cols[0]));
        filter.and(keyField, "in", (Object)Long.parseLong(cols[1]));
        return filter;
    }

    public static QFilter getMatQFilter(Set<String> reCalcMatIds, String matField) {
        HashSet<Long> materialIds = new HashSet<Long>(10);
        for (String keycol : reCalcMatIds) {
            String[] cols = keycol.split("-");
            materialIds.add(Long.parseLong(cols[0]));
        }
        return new QFilter(matField, "in", materialIds);
    }

    public static Tuple2<Long, Long> getMaterialKeyId(String materialKey) {
        String[] keyCols = materialKey.split("-");
        return new Tuple2((Object)Long.parseLong(keyCols[0]), (Object)Long.parseLong(keyCols[1]));
    }

    public static String getKeyIdStr(Long matId, Long calcKeyId) {
        return String.format("%s-%s", matId, calcKeyId);
    }

    public static Long getMatIdByKey(String materialKey) {
        return Long.parseLong(materialKey.split(",")[0]);
    }

    public static Map<Long, String> getKeyColNameMap(Set<Long> keycolIds, Set<String> calcKeys) {
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("id");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cad_keycol");
        HashSet<String> flexFields = new HashSet<String>(10);
        Iterator<String> iterator = calcKeys.iterator();
        while (iterator.hasNext()) {
            String calcKey;
            String recField = calcKey = iterator.next();
            if ("auxpty".equals(calcKey)) {
                recField = "auxproperty";
            }
            selectFields.append(",").append(recField);
            if (!(entityType.findProperty(recField) instanceof FlexProp)) continue;
            flexFields.add(calcKey);
        }
        List lists = Lists.partition(new ArrayList<Long>(keycolIds), (int)2000);
        HashMap<Long, String> keycolNameMap = new HashMap<Long, String>();
        for (List list : lists) {
            Object recField;
            QFilter idFilters = new QFilter("id", "in", (Object)list);
            DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"cad_keycol", (String)selectFields.toString(), (QFilter[])idFilters.toArray());
            Map<Long, String> auxptyMap = null;
            if (!flexFields.isEmpty()) {
                HashSet<Long> auxIds = new HashSet<Long>();
                DynamicObject[] dynamicObjectArray = dyns;
                int n = dynamicObjectArray.length;
                for (int i = 0; i < n; ++i) {
                    DynamicObject dyn = dynamicObjectArray[i];
                    for (String key : flexFields) {
                        Long auxid;
                        recField = key;
                        if ("auxpty".equals(key)) {
                            recField = "auxproperty";
                        }
                        if (CadEmptyUtils.isEmpty(auxid = Long.valueOf(dyn.getLong((String)recField + ".id")))) continue;
                        auxIds.add(auxid);
                    }
                }
                if (!auxIds.isEmpty()) {
                    try {
                        auxptyMap = DiffCalcHelper.getAuxValueNameMap(auxIds);
                    }
                    catch (Exception ex) {
                        logger.error("\u83b7\u53d6\u8f85\u52a9\u5c5e\u6027\u7f16\u7801\u5931\u8d25", (Throwable)ex);
                    }
                }
            }
            for (DynamicObject dyn : dyns) {
                StringBuilder sb = new StringBuilder();
                for (String calcKey : calcKeys) {
                    sb.append("@");
                    if (flexFields.contains(calcKey)) {
                        recField = flexFields.iterator();
                        while (recField.hasNext()) {
                            Long auxid;
                            String key;
                            String recField2 = key = (String)recField.next();
                            if ("auxpty".equals(key)) {
                                recField2 = "auxproperty";
                            }
                            if (!CadEmptyUtils.isEmpty(auxid = Long.valueOf(dyn.getLong(recField2 + ".id")))) {
                                if (auxptyMap != null && auxptyMap.containsKey(auxid)) {
                                    sb.append(auxptyMap.get(auxid));
                                    continue;
                                }
                                sb.append(auxid);
                                continue;
                            }
                            sb.append("");
                        }
                        continue;
                    }
                    Object obj = dyn.get(calcKey);
                    if (obj == null) {
                        sb.append("");
                        continue;
                    }
                    if (obj instanceof DynamicObject) {
                        DynamicObject propDyn = (DynamicObject)obj;
                        if (propDyn.containsProperty("number")) {
                            sb.append(propDyn.getString("number"));
                            continue;
                        }
                        if (propDyn.containsProperty("billno")) {
                            sb.append(propDyn.getString("billno"));
                            continue;
                        }
                        if (propDyn.containsProperty("name")) {
                            sb.append(propDyn.getString("name"));
                            continue;
                        }
                        sb.append(propDyn.getString("id"));
                        continue;
                    }
                    sb.append(obj.toString());
                }
                keycolNameMap.put(dyn.getLong("id"), sb.toString());
            }
        }
        return keycolNameMap;
    }

    public static void updatePrdStructCalcKeycolInfo(CostRecoveryParams crParams, Set<String> materialIdSet, Set<String> calcKeys) {
        if (calcKeys.contains("auxpty") && calcKeys.size() == 1) {
            return;
        }
        QFilter filter = new QFilter("org.id", "in", crParams.getRelationCalOrgIds());
        filter.and("costaccount.id", "in", crParams.getRelationCostAccountIds());
        if (crParams.getManuOrgId() != 0L) {
            filter.and("prdorg.id", "=", (Object)crParams.getManuOrgId());
        }
        filter.and("period.id", "=", (Object)crParams.getNextPeriodId());
        filter.and(CostRecCalcHelper.getMatKeyQFilter(materialIdSet, "material", "calckeycol"));
        DataSet halfPrdStructDs = QueryServiceHelper.queryDataSet((String)"halfPrdStruct", (String)"sca_halfprdstructure", (String)"id,calckeycol,entryentity.id subid,entryentity.subcalckeycol subcalckeycol", (QFilter[])filter.toArray(), null);
        HashSet<Long> calckeycolIds = new HashSet<Long>(10);
        DataSet halfPrdStructCopyDs = halfPrdStructDs.copy();
        for (Row row : halfPrdStructCopyDs) {
            Long calckeycolId = row.getLong("calckeycol");
            Long subcalckeycolId = row.getLong("subcalckeycol");
            if (!CadEmptyUtils.isEmpty(calckeycolId)) {
                calckeycolIds.add(calckeycolId);
            }
            if (CadEmptyUtils.isEmpty(subcalckeycolId)) continue;
            calckeycolIds.add(subcalckeycolId);
        }
        if (calckeycolIds.isEmpty()) {
            return;
        }
        logger.info("\u671f\u521d\u534a\u6210\u54c1\u7ed3\u6784\u5355\uff1a\u7ef4\u5ea6\u6570\u91cf\uff1a{}", (Object)calckeycolIds.size());
        StringBuilder selectFields = new StringBuilder();
        StringBuilder headFields = new StringBuilder();
        StringBuilder subFields = new StringBuilder();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"sca_halfprdstructure");
        selectFields.append("id as keycolid");
        ArrayList<String> headAddKeys = new ArrayList<String>(10);
        ArrayList<String> subAddKeys = new ArrayList<String>(10);
        for (String calcKey : calcKeys) {
            String subField;
            if ("auxpty".equals(calcKey)) continue;
            selectFields.append(",").append(calcKey);
            String headField = CalcKeycolHelper.getEntityUseDbFields((MainEntityType)entityType, (String)calcKey, (String)"");
            if (headField != null) {
                if (headFields.length() > 0) {
                    headFields.append(",");
                }
                headFields.append(headField).append("=?");
                headAddKeys.add(calcKey);
            }
            if ((subField = CalcKeycolHelper.getEntityUseDbFields((MainEntityType)entityType, (String)calcKey, (String)"sub")) == null) continue;
            if (subFields.length() > 0) {
                subFields.append(",");
            }
            subFields.append(subField).append("=?");
            subAddKeys.add(calcKey);
        }
        QFilter idFilters = new QFilter("id", "in", calckeycolIds);
        DataSet keycolDs = QueryServiceHelper.queryDataSet((String)"keycol", (String)"cad_keycol", (String)selectFields.toString(), (QFilter[])idFilters.toArray(), null);
        String formatHeadSql = String.format("update t_sca_halfprdstructure set %s where fid=?", headFields.toString());
        String formatSubSql = String.format("update t_sca_halfprdstructentry set %s where fentryid=?", subFields.toString());
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        DataSet headPrdStructDs = halfPrdStructDs.copy().select("id,calckeycol").distinct().join(keycolDs.copy()).on("calckeycol", "keycolid").select(new String[]{"id"}, keycolDs.getRowMeta().getFieldNames()).finish();
        for (Object row : headPrdStructDs) {
            boolean isAdd = false;
            Object[] param = new Object[headAddKeys.size() + 1];
            int i = 0;
            Long id = row.getLong("id");
            for (String calcKey : headAddKeys) {
                Object obj = row.get(calcKey);
                param[i++] = obj;
                if (CalcKeyHelper.isDbDefaultValue((Object)obj)) continue;
                isAdd = true;
            }
            if (!isAdd) continue;
            param[i] = id;
            params.add(param);
        }
        if (!params.isEmpty()) {
            CostRecCalcHelper.executeBatch(DBRoute.of((String)"cal"), formatHeadSql, params);
            logger.info("\u671f\u521d\u534a\u6210\u54c1\u7ed3\u6784\u5355\uff1a\u5355\u636e\u5934\u66f4\u65b0\u6570\u91cf\uff1a{}", (Object)params.size());
            params.clear();
        }
        DataSet subPrdStructDs = halfPrdStructDs.select("subid,subcalckeycol").join(keycolDs).on("subcalckeycol", "keycolid").select(new String[]{"subid"}, keycolDs.getRowMeta().getFieldNames()).finish();
        for (Row row : subPrdStructDs) {
            boolean isAdd = false;
            Object[] param = new Object[subAddKeys.size() + 1];
            int i = 0;
            Long id = row.getLong("subid");
            for (String calcKey : subAddKeys) {
                Object obj = row.get(calcKey);
                param[i++] = obj;
                if (CalcKeyHelper.isDbDefaultValue((Object)obj)) continue;
                isAdd = true;
            }
            if (!isAdd) continue;
            param[i] = id;
            params.add(param);
        }
        if (!params.isEmpty()) {
            logger.info("\u671f\u521d\u534a\u6210\u54c1\u7ed3\u6784\u5355\uff1a\u5355\u636e\u4f53\u66f4\u65b0\u6570\u91cf\uff1a{}", (Object)params.size());
            List lists = Lists.partition(params, (int)1000);
            for (List list : lists) {
                CostRecCalcHelper.executeBatch(DBRoute.of((String)"cal"), formatSubSql, list);
            }
        }
    }

    private static void executeBatch(DBRoute route, String sql, List<Object[]> entrys) {
        DB.executeBatch((DBRoute)route, (String)sql, entrys);
    }

    public static String[] stringArrUnion(String[] ... arrs) {
        HashSet fields = Sets.newHashSetWithExpectedSize((int)10);
        for (String[] arr : arrs) {
            fields.addAll(Arrays.asList(arr));
        }
        return fields.toArray(new String[0]);
    }

    public static String getKeytreepath(String treepath) {
        String[] arrPath = treepath.split("@");
        StringBuilder sb = new StringBuilder();
        for (String mat : arrPath) {
            if (sb.length() > 0) {
                sb.append("@");
            }
            sb.append(mat).append("-0");
        }
        return sb.toString();
    }

    public static Map<RowX, BigDecimal> getAlgoxRowRadio(List<RowX> listRows, int radioIndex) {
        BigDecimal curqty;
        HashMap rowRadioMap = Maps.newHashMapWithExpectedSize((int)16);
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal maxValue = null;
        for (RowX row : listRows) {
            curqty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(radioIndex));
            totalAmt = totalAmt.add(BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(radioIndex)));
            if (maxValue != null && maxValue.compareTo(curqty.abs()) >= 0) continue;
            maxValue = curqty.abs();
        }
        if (totalAmt.compareTo(BigDecimal.ZERO) == 0) {
            totalAmt = maxValue;
        }
        for (RowX row : listRows) {
            if (totalAmt == null || totalAmt.compareTo(BigDecimal.ZERO) == 0) {
                rowRadioMap.put(row, BigDecimal.ONE.divide(new BigDecimal(listRows.size()), 10, RoundingMode.HALF_UP));
                continue;
            }
            curqty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(radioIndex));
            rowRadioMap.put(row, curqty.divide(totalAmt, 10, RoundingMode.HALF_UP));
        }
        return rowRadioMap;
    }

    public static Set<String> getNotUpdateFields(String noupdatecalfields) {
        if (StringUtils.isEmpty((CharSequence)noupdatecalfields)) {
            return new HashSet<String>(10);
        }
        JSONObject jsonObj = JSON.parseObject((String)noupdatecalfields);
        JSONArray arr = jsonObj.getJSONArray("setnull");
        if (arr == null || arr.isEmpty()) {
            return new HashSet<String>(10);
        }
        HashSet nullFields = Sets.newHashSetWithExpectedSize((int)10);
        for (int i = 0; i < arr.size(); ++i) {
            nullFields.add(arr.getString(i));
        }
        return nullFields;
    }

    public static boolean isNestMat(List<Set<String>> cnGroup, String material, String submaterial) {
        for (Set<String> group : cnGroup) {
            if (!group.contains(material) || !group.contains(submaterial)) continue;
            return true;
        }
        return false;
    }
}

