/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.sca.algox.costrec.CostRecoveryParams;
import kd.macc.sca.algox.utils.DataSetHelper;
import kd.macc.sca.algox.utils.PeriodHelper;

public class CostRecoveryDataInputFactory {
    private static final Log logger = LogFactory.getLog(CostRecoveryDataInputFactory.class);
    private static final String ALGOKEY = "kd.macc.sca.algox.CostRecoveryDataInputFactory";
    private CostRecoveryParams costRecoveryParams;
    private Long calOrgId;
    private Long costAccountId;
    private Set<Long> costObjectIdSet = new HashSet<Long>();

    public CostRecoveryDataInputFactory(CostRecoveryParams crParams, Long costAccountId, Long calOrgId) {
        this.costRecoveryParams = crParams;
        this.calOrgId = calOrgId;
        this.costAccountId = costAccountId;
    }

    public DataSet buildFactnedInputDataSet(Set<Long> materialIdSet) {
        QFilter filter = new QFilter("org.id", "=", (Object)this.calOrgId);
        filter.and("bizdate", ">=", (Object)this.costRecoveryParams.getStartDate());
        filter.and("bizdate", "<=", (Object)this.costRecoveryParams.getEndDate());
        filter.and("appnum", "=", (Object)"sca");
        filter.and("billstatus", "=", (Object)"C");
        if (this.costRecoveryParams.getManuOrgId() != 0L) {
            filter.and("entryentity.costobject.manuorg.id", "=", (Object)this.costRecoveryParams.getManuOrgId());
        }
        if (materialIdSet != null) {
            filter.and("material.id", "in", materialIdSet);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_factnedoutputbill", (String)"org.id as calOrgId,material.id as materialId,version.id as materialVerId,auxpty.id as materialAuxPropId,entryentity.costobject.id as costObjectId,entryentity.qty as qty,sourcebill as sourceBillId,sourcebillentry as sourceBillEntryId", (QFilter[])filter.toArray(), null);
        HashSet sourceBillEntryId = Sets.newHashSet();
        for (Row row : dataSet.copy()) {
            sourceBillEntryId.add(row.getLong("sourceBillEntryId"));
        }
        QFilter invQfilter = new QFilter("billentry.id", "in", (Object)sourceBillEntryId);
        DataSet invDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"im_mdc_mftmanuinbill", (String)"org.id as invOrgId,billentry.id as sourceBillEntryId", (QFilter[])invQfilter.toArray(), null);
        dataSet = dataSet.join(invDataSet).on("sourceBillEntryId", "sourceBillEntryId").select(dataSet.getRowMeta().getFieldNames(), new String[]{"invOrgId"}).finish();
        DataSet forDataSet = dataSet.copy();
        for (Row row : forDataSet) {
            Long tmpCostObjectId = row.getLong("costObjectId");
            if (tmpCostObjectId == 0L) continue;
            this.costObjectIdSet.add(tmpCostObjectId);
        }
        DataSet factnedDataSet = dataSet.groupBy(new String[]{"calOrgId", "invOrgId", "materialId", "materialVerId", "materialAuxPropId"}).sum("qty").finish();
        return factnedDataSet;
    }

    public DataSet buildCalcresultDataSet(Set<Long> materialIdSet) {
        QFilter filter = new QFilter("org.id", "=", (Object)this.calOrgId);
        filter.and("period.id", "=", (Object)this.costRecoveryParams.getPeriodId());
        filter.and("costaccount.id", "=", (Object)this.costAccountId);
        filter.and("costobject.id", "in", this.costObjectIdSet);
        filter.and("entryentity.datatype", "=", (Object)"1");
        filter.and("costobject.material.id", "in", materialIdSet);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_calcresult", (String)this.getCalcresultBizField(), (QFilter[])filter.toArray(), null);
        DataSet materialPropArrDataSet = dataSet.filter("subElementType in ( '001','002')");
        DataSet otherPropArrDataSet = dataSet.filter("subElementType in ('003','004','005')");
        otherPropArrDataSet = otherPropArrDataSet.select("calOrgId,manuOrgId,materialId,materialVerId,materialAuxPropId,materialId as subMaterialId,materialVerId as subMertialVerId,materialAuxPropId as subMerialAuxPropId,costObjectId,elementId,subElementId,subElementType,qty,amount,diffAmount,sourceInfo");
        dataSet = materialPropArrDataSet.union(otherPropArrDataSet);
        dataSet = dataSet.select("calOrgId,manuOrgId,materialId,materialVerId,materialAuxPropId,case when subMaterialId=0 then materialId else subMaterialId end as subMaterialId,case when subMaterialId=0 then materialVerId else subMertialVerId end  as subMertialVerId,case when subMaterialId=0 then materialAuxPropId else subMerialAuxPropId end as subMerialAuxPropId,costObjectId,elementId,subElementId,subElementType,qty,amount,diffAmount,sourceInfo");
        DataSet calcresultDataSet = dataSet.groupBy(new String[]{"calOrgId", "manuOrgId", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "subElementType"}).sum("qty").sum("amount").sum("diffAmount").finish();
        return calcresultDataSet;
    }

    private String getCalcresultBizField() {
        return "org.id as calOrgId,costobject.manuorg.id as manuOrgId,costobject.material.id as materialId,costobject.bomversion.id as materialVerId,costobject.auxpty.id as materialAuxPropId, entryentity.material.id  as subMaterialId, entryentity.matversion.id as subMertialVerId, entryentity.auxpty.id as subMerialAuxPropId,costobject.id as costObjectId,entryentity.element.id as elementId,entryentity.subelement.id as subElementId,entryentity.subelement.type as subElementType,entryentity.pdstartqty+entryentity.pdcurrqty as qty,entryentity.pdcompanount as amount,entryentity.diff as diffAmount,concat('sca_calcresult.',id) as sourceInfo";
    }

    public DataSet buildPurchdiffallocDataSet() {
        QFilter filter = new QFilter("org.id", "=", (Object)this.calOrgId);
        filter.and("period.id", "=", (Object)this.costRecoveryParams.getPeriodId());
        filter.and("billstatus", "=", (Object)"C");
        filter.and("costaccount.id", "=", (Object)this.costAccountId);
        filter.and("becostobject.id", "in", this.costObjectIdSet);
        filter.and("biztype", "=", (Object)"00");
        DataSet purchdiffallocDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_purchdiffalloc", (String)("org.id as calOrgId,becostobject.manuorg.id as manuOrgId,period.id as periodId,becostobject.material as materialId,becostobject.bomversion as materialVerId,becostobject.auxpty as materialAuxPropId,material.id  as subMaterialId,version.id as subMertialVerId,auxpty as subMerialAuxPropId,becostobject.id as costObjectId," + this.costRecoveryParams.getDefaultElementId() + " as elementId," + this.costRecoveryParams.getDefaultSubElementId() + " as subElementId,'001' as subElementType,entryentity.amount as amount,concat('sca_purchdiffalloc.',id) as sourceInfo"), (QFilter[])filter.toArray(), null);
        purchdiffallocDataSet = purchdiffallocDataSet.groupBy(new String[]{"calOrgId", "manuOrgId", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "subElementType"}).sum("amount").maxP("amount", "sourceInfo").finish();
        return purchdiffallocDataSet;
    }

    public DataSet buildPreConstrDataSet(Set materialIdSet, Long periodId) {
        QFilter filter = new QFilter("org.id", "=", (Object)this.calOrgId);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("costaccount.id", "=", (Object)this.costAccountId);
        if (this.costRecoveryParams.getManuOrgId() != 0L) {
            filter.and("prdorg.id", "=", (Object)this.costRecoveryParams.getManuOrgId());
        }
        filter.and("period.id", "=", (Object)periodId);
        filter.and("material.id", "in", (Object)materialIdSet);
        DataSet preConstrDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_halfprdhide", (String)"storageorgunit.id as invOrgId,entryentity.level as level,entryentity.treepath as treepath,material.id as materialId,materialversion.id as materialVerId,auxprop.id as materialAuxPropId,entryentity.submaterial.id  as subMaterialId,entryentity.submaterialversion.id as subMertialVerId,entryentity.submaterialauxprop.id as subMerialAuxPropId,entryentity.element.id as elementId,entryentity.subelement.id as subElementId,entryentity.subelement.type as subElementType,entryentity.qty as qty,entryentity.amountCoeff as amountCoeff,entryentity.isunabsorb as isUnAbsorbd", (QFilter[])filter.toArray(), null);
        return preConstrDataSet;
    }

    public DataSet buildBalanceDataSet(Set<Long> materialIdSet) {
        boolean isNewPeriodBal = (Boolean)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBalanceService", (String)"isNewPeriodBal", (Object[])new Object[0]);
        if (isNewPeriodBal) {
            return this.getNewBalanceDataSet(materialIdSet);
        }
        QFilter balfilter = new QFilter("calorg.id", "=", (Object)this.calOrgId);
        balfilter.and("costaccount.id", "=", (Object)this.costAccountId);
        if (this.costRecoveryParams.getManuOrgId() != 0L) {
            List invLists = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)this.costRecoveryParams.getManuOrgId());
            balfilter.and("storageorgunit.id", "in", (Object)invLists);
        }
        DynamicObject periodInfo = BusinessDataServiceHelper.loadSingle((Object)this.costRecoveryParams.getPeriodId(), (String)"bd_period");
        int periodNum = periodInfo.getInt("periodyear") * 100 + periodInfo.getInt("periodnumber");
        balfilter.and("period", "<=", (Object)periodNum);
        balfilter.and("endperiod", ">", (Object)periodNum);
        balfilter.and("material.id", "in", materialIdSet);
        DataSet balDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_balance", (String)("calorg.id as calOrgId,storageorgunit.id as invOrgId,material.id as materialId,mversion.id as materialVerId,assist.id as materialAuxPropId,period,case when period = " + periodNum + " then periodbeginqty else periodendqty end as qty,case when period = " + periodNum + " then periodbeginactualcost else periodendactualcost end as amount,'A' as isUnAbsorbd"), (QFilter[])balfilter.toArray(), null);
        balDataSet = balDataSet.groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId", "isUnAbsorbd"}).sum("qty").sum("amount").finish().filter("qty<>0");
        return balDataSet;
    }

    private DataSet getNewBalanceDataSet(Set<Long> materialIdSet) {
        QFilter balfilter = new QFilter("calorg.id", "=", (Object)this.calOrgId);
        balfilter.and("costaccount.id", "=", (Object)this.costAccountId);
        if (this.costRecoveryParams.getManuOrgId() != 0L) {
            List invLists = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)this.costRecoveryParams.getManuOrgId());
            balfilter.and("storageorgunit.id", "in", (Object)invLists);
        }
        DynamicObject periodInfo = BusinessDataServiceHelper.loadSingle((Object)this.costRecoveryParams.getPeriodId(), (String)"bd_period");
        int periodNum = periodInfo.getInt("periodyear") * 100 + periodInfo.getInt("periodnumber");
        balfilter.and("period", "<=", (Object)periodNum);
        balfilter.and("endperiod", ">", (Object)periodNum);
        balfilter.and("material.id", "in", materialIdSet);
        DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_bal", (String)("calorg.id as calOrgId,storageorgunit.id as invOrgId,material.id as materialId,mversion.id as materialVerId,assist.id as materialAuxPropId,period,costsubelement,case when period = " + periodNum + " then baseqty else baseqty_bal end as qty,case when period = " + periodNum + " then actualcost else actualcost_bal end as amount,'A' as isUnAbsorbd"), (QFilter[])balfilter.toArray(), null);
        DataSet qtyDs = ds.copy().filter("costsubelement=" + this.costRecoveryParams.getDefaultSubElementId()).select("invOrgId,materialId,materialVerId,materialAuxPropId,isUnAbsorbd,qty,0 as amount");
        return ds.select("invOrgId,materialId,materialVerId,materialAuxPropId,isUnAbsorbd,0 as qty,amount").union(qtyDs).groupBy(new String[]{"invOrgId", "materialId", "materialVerId", "materialAuxPropId", "isUnAbsorbd"}).sum("qty").sum("amount").finish();
    }

    public DataSet buildUnabsorbdiffDataSet() {
        QFilter filter = new QFilter("org.id", "=", (Object)this.calOrgId);
        filter.and("period.id", "=", (Object)this.costRecoveryParams.getPeriodId());
        filter.and("costaccount.id", "=", (Object)this.costAccountId);
        filter.and("costobject.id", "in", this.costObjectIdSet);
        DataSet unabsorbdiffDataSet = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"sca_unabsorbdiff", (String)"org.id as calOrgId,manuorg.id as manuOrgId,period.id as periodId,costobject.material as materialId,costobject.bomversion as materialVerId,costobject.auxpty as materialAuxPropId,costobject.material  as subMaterialId,costobject.bomversion as subMertialVerId,costobject.auxpty as subMerialAuxPropId,costobject.id as costObjectId,entryentity.element.id as elementId,entryentity.subelement.id as subElementId,entryentity.subelement.type as subElementType,entryentity.amount as amount,case when entryentity.subelement.type='001' then 'B' else 'A' end as isUnAbsorbd,concat('sca_unabsorbdiff.',id) as sourceInfo", (QFilter[])filter.toArray(), null);
        unabsorbdiffDataSet = unabsorbdiffDataSet.groupBy(new String[]{"calOrgId", "manuOrgId", "materialId", "materialVerId", "materialAuxPropId", "subMaterialId", "subMertialVerId", "subMerialAuxPropId", "elementId", "subElementId", "subElementType", "isUnAbsorbd"}).sum("amount").maxP("amount", "sourceInfo").finish();
        return unabsorbdiffDataSet;
    }

    public DataSet buildTransInDataSet(CostRecoveryParams crParams, Long costaccountId, Long calOrgId, Set<Long> materialIdSet) {
        QFilter calFilter = new QFilter("calorg", "=", (Object)calOrgId);
        calFilter.and("costaccount", "=", (Object)costaccountId);
        calFilter.and("period", "=", (Object)crParams.getPeriodId());
        calFilter.and("billstatus", "=", (Object)Character.valueOf('C'));
        calFilter.and("entry.material", "in", materialIdSet);
        QFilter coadjFilter = new QFilter("calorg", "=", (Object)calOrgId);
        coadjFilter.and("costaccount", "=", (Object)costaccountId);
        coadjFilter.and("period", "=", (Object)crParams.getPeriodId());
        coadjFilter.and("billstatus", "=", (Object)Character.valueOf('C'));
        coadjFilter.and("entryentity.material", "in", materialIdSet);
        QFilter transFilter = new QFilter("bizentityobject", "=", (Object)"im_transdirbill");
        transFilter.and("transtype", "=", (Object)Character.valueOf('B'));
        QFilter transInFilter = new QFilter("calBillType", "=", (Object)"IN");
        DataSet transInBillIdDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_subentity", (String)"entry.id as costRecordEntryId,bizbillid", (QFilter[])new QFilter[]{calFilter, transFilter, transInFilter}, null);
        HashSet costRecordEntryIdSet = Sets.newHashSetWithExpectedSize((int)160);
        HashSet transDirBillIdSet = Sets.newHashSetWithExpectedSize((int)160);
        for (Row row : transInBillIdDs) {
            costRecordEntryIdSet.add(row.getLong("costRecordEntryId"));
            transDirBillIdSet.add(row.getLong("bizbillid"));
        }
        String commonFilter = "costaccount.id as costaccountId,calorg.id as calOrgId,period.id as periodId,period.id as outPeriodId,0 as getHalfHidePeriodId,entry.id as entryId,entry.material.id as materialId,0L as materialVerId,0L as materialAuxPropId";
        String commonSelect = "costaccountId,calOrgId,periodId,outPeriodId,getHalfHidePeriodId,materialId,materialVerId,materialAuxPropId,transInOrgId,transInQty,bizBillId,standardCost+adjustamt transInAmt";
        DataSet transInCostRecordDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_subentity", (String)(commonFilter + ",storageorgunit.id as transInOrgId,entry.baseqty as transInQty,case when entry.accounttype=='D' then entry.standardcost else entry.actualcost end as standardCost,bizbillid as bizBillId"), (QFilter[])new QFilter[]{new QFilter("bizbillid", "in", (Object)transDirBillIdSet), transInFilter}, null);
        QFilter caFilter = new QFilter("entryentity.invbillentryid", "in", (Object)costRecordEntryIdSet);
        caFilter.and("createtype", "in", (Object)Sets.newHashSet((Object[])new String[]{"W", "Y", "Z"}));
        DataSet caDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_stdcostdiffbill", (String)"entryentity.invbillentryid as invbillentryid,entryentity.adjustamt as adjustamt", (QFilter[])new QFilter[]{caFilter, coadjFilter}, null);
        caDs = caDs.groupBy(new String[]{"invbillentryid"}).sum("adjustamt").finish();
        transInCostRecordDs = transInCostRecordDs.leftJoin(caDs).on("entryId", "invbillentryid").select(transInCostRecordDs.getRowMeta().getFieldNames(), new String[]{"adjustamt"}).finish();
        transInCostRecordDs = transInCostRecordDs.select(commonSelect);
        DataSet invTransOutOrgDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"im_transdirbill", (String)"outorg.id as transOutOrgId,id as bizBillId", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)transDirBillIdSet)}, null);
        invTransOutOrgDs = invTransOutOrgDs.groupBy(new String[]{"transOutOrgId", "bizBillId"}).finish();
        DataSet transInDataSet = transInCostRecordDs.join(invTransOutOrgDs).on("bizBillId", "bizBillId").select(transInCostRecordDs.getRowMeta().getFieldNames(), new String[]{"transOutOrgId"}).finish();
        transFilter = new QFilter("bizentityobject", "=", (Object)"im_transinbill");
        transFilter.and("transtype", "=", (Object)Character.valueOf('B'));
        transInBillIdDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_subentity", (String)"entry.id as costRecordEntryId,bizbillid", (QFilter[])new QFilter[]{calFilter, transFilter, transInFilter}, null);
        HashSet transInBillIdSet = Sets.newHashSetWithExpectedSize((int)160);
        costRecordEntryIdSet.clear();
        for (Row row : transInBillIdDs) {
            costRecordEntryIdSet.add(row.getLong("costRecordEntryId"));
            transInBillIdSet.add(row.getLong("bizbillid"));
        }
        if (transInBillIdSet.size() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
            transInCostRecordDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_costrecord_subentity", (String)(commonFilter + ",storageorgunit.id as transInOrgId,entry.baseqty as transInQty,case when entry.accounttype=='D' then entry.standardcost else entry.actualcost end as standardCost,bizbillid as bizBillId"), (QFilter[])new QFilter[]{new QFilter("bizbillid", "in", (Object)transInBillIdSet), transInFilter}, null);
            caFilter = new QFilter("entryentity.invbillentryid", "in", (Object)costRecordEntryIdSet);
            caFilter.and("createtype", "in", (Object)Sets.newHashSet((Object[])new String[]{"W", "Y", "Z"}));
            caDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cal_stdcostdiffbill", (String)"entryentity.invbillentryid as invbillentryid,entryentity.adjustamt as adjustamt", (QFilter[])new QFilter[]{caFilter, coadjFilter}, null);
            caDs = caDs.groupBy(new String[]{"invbillentryid"}).sum("adjustamt").finish();
            transInCostRecordDs = transInCostRecordDs.leftJoin(caDs).on("entryId", "invbillentryid").select(transInCostRecordDs.getRowMeta().getFieldNames(), new String[]{"adjustamt"}).finish();
            transInCostRecordDs = transInCostRecordDs.select(commonSelect);
            invTransOutOrgDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"im_transinbill", (String)"id as bizBillId,outorg.id as transOutOrgId,billentry.srcbillId as srcbillId,billentry.srcbillentity as srcbillentity", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)transInBillIdSet)}, null);
            DataSet relTransOutDs = invTransOutOrgDs.copy().filter("srcbillentity='im_transoutbill'");
            DataSet relTransInDs = invTransOutOrgDs.copy().filter("srcbillentity='im_transinbill'");
            LinkedHashSet srcbillidSet = Sets.newLinkedHashSetWithExpectedSize((int)16);
            for (Object row : relTransInDs.copy()) {
                srcbillidSet.add(Long.parseLong(row.getString("srcbillId")));
            }
            DataSet tmpTransInBillDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"im_transinbill", (String)"id as bizBillId,billentry.srcbillId as srcbillId", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)srcbillidSet)}, null);
            relTransInDs = relTransInDs.join(tmpTransInBillDs).on("srcbillId", "bizBillId").select(new String[]{"bizBillId", "transOutOrgId"}, new String[]{"srcbillId"}).finish();
            relTransOutDs = relTransOutDs.removeFields(new String[]{"srcbillentity"});
            invTransOutOrgDs = DataSetHelper.union(relTransOutDs, relTransInDs);
            srcbillidSet.clear();
            for (Row row : invTransOutOrgDs.copy()) {
                srcbillidSet.add(Long.parseLong(row.getString("srcbillId")));
            }
            DataSet transOutBillDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"im_transoutbill", (String)"id as bizBillId,biztime as bizDate", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)srcbillidSet)}, null);
            ArrayList newValues = Lists.newArrayList();
            for (Row row : transOutBillDs.copy()) {
                Object[] values = new Object[2];
                values[0] = row.getLong("bizBillId");
                Date bizDate = row.getDate("bizDate");
                values[1] = sdf.format(bizDate);
                newValues.add(values);
            }
            RowMeta rm = new RowMeta(new String[]{"bizBillId", "periodNumber"}, new DataType[]{DataType.LongType, DataType.StringType});
            DataSet periodIdDs = Algo.create((String)"kd.macc.sca.algox.costrec.CostRecoveryDataInputFactory.buildTransInDataSet").createDataSet(newValues.iterator(), rm);
            DataSet periodDs = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"bd_period", (String)"id as periodId,number as periodNumber", null, null);
            periodIdDs = periodIdDs.join(periodDs).on("periodNumber", "periodNumber").select(new String[]{"bizBillId", "periodId"}).finish();
            newValues = Lists.newArrayList();
            for (Row row : periodIdDs) {
                Object[] values = new Object[3];
                values[0] = row.getLong("bizBillId");
                Long periodId = row.getLong("periodId");
                values[1] = periodId;
                if (periodId.longValue() != crParams.getPeriodId()) {
                    logger.info("\u5b58\u5728\u8de8\u671f\u7684\u5206\u5e03\u8c03\u5165\u5355\uff1a" + row.getLong("bizBillId"));
                    values[2] = PeriodHelper.getNextPeriodId(periodId);
                } else {
                    values[2] = 0L;
                }
                newValues.add(values);
            }
            rm = new RowMeta(new String[]{"bizBillId", "periodId", "getHalfHidePeriodId"}, new DataType[]{DataType.LongType, DataType.LongType, DataType.LongType});
            periodIdDs = Algo.create((String)"kd.macc.sca.algox.costrec.CostRe9coveryDataInputFactory.buildTransInDataSet").createDataSet(newValues.iterator(), rm);
            invTransOutOrgDs = invTransOutOrgDs.leftJoin(periodIdDs).on("srcbillId", "bizBillId").select(invTransOutOrgDs.getRowMeta().getFieldNames(), new String[]{"periodId", "getHalfHidePeriodId"}).finish();
            invTransOutOrgDs = invTransOutOrgDs.select(new String[]{"bizBillId", "transOutOrgId", "srcbillId", "case when periodId is null then " + crParams.getPeriodId() + "L else periodId end as periodId", "case when getHalfHidePeriodId is null then 0L else getHalfHidePeriodId end as getHalfHidePeriodId"});
            invTransOutOrgDs = invTransOutOrgDs.groupBy(new String[]{"bizBillId", "transOutOrgId", "srcbillId", "periodId", "getHalfHidePeriodId"}).finish();
            transInCostRecordDs = transInCostRecordDs.join(invTransOutOrgDs).on("bizBillId", "bizBillId").select(new String[]{"costaccountId", "calOrgId", "periodId", "bizBillId", "materialId", "materialVerId", "materialAuxPropId", "transInOrgId", "transInQty", "transInAmt"}, new String[]{"transOutOrgId", "periodId outPeriodId", "getHalfHidePeriodId"}).finish();
            transInDataSet = DataSetHelper.union(transInDataSet, transInCostRecordDs);
        }
        transInDataSet = transInDataSet.groupBy(new String[]{"calOrgId", "periodId", "outPeriodId", "getHalfHidePeriodId", "materialId", "materialVerId", "materialAuxPropId", "transInOrgId", "transOutOrgId"}).sum("transInQty").sum("transInAmt").finish();
        return transInDataSet;
    }
}

