/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.checker;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class AcaCalResultCheck
extends AbstractSingleCalcCheckAction {
    public void doCheck() {
        CalcCheckContext context = this.getContext();
        List<String> costaccountNames = this.getNotHasCalcResultAccountName(context);
        if (CadEmptyUtils.isEmpty(costaccountNames)) {
            return;
        }
        String checkDesc = ResManager.loadKDString((String)"\u672c\u671f\u672a\u5b8c\u6210\u671f\u672b\u6210\u672c\u8ba1\u7b97", (String)"AcaCalResultCheck_0", (String)"macc-sca-algox", (Object[])new Object[0]);
        String detailDesc = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\uff0c\u671f\u95f4\u201c%2$s\u201d\u672a\u8fdb\u884c\u5b9e\u9645\u6210\u672c\u8ba1\u7b97\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u3002", (String)"AcaCalResultCheck_1", (String)"macc-sca-algox", (Object[])new Object[0]);
        String periodName = this.getPeriodName(context.getPeriodId());
        for (String costaccountName : costaccountNames) {
            CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
            info.setCheckDetailResult(String.format(detailDesc, costaccountName, periodName));
            this.getSingleCheckContext().getCheckDetailResult().add(info);
        }
        this.getSingleCheckContext().setCheckResult(checkDesc);
        this.getSingleCheckContext().setPass(false);
    }

    private String getPeriodName(Long periodId) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period");
        if (obj != null) {
            return obj.getString("name");
        }
        return "";
    }

    private List<String> getNotHasCalcResultAccountName(CalcCheckContext context) {
        ArrayList<String> accountNames = new ArrayList<String>();
        Set relationCostAccountIds = new HashSet(10);
        if (context.getParams().get("relationCostAccountIds") != null) {
            relationCostAccountIds = (Set)context.getParams().get("relationCostAccountIds");
        }
        Map bdaccountMap = BusinessDataServiceHelper.loadFromCache((Object[])relationCostAccountIds.toArray(), (String)"cal_bd_costaccount");
        for (DynamicObject costaccount : bdaccountMap.values()) {
            Long orgId = costaccount.getLong("calorg.id");
            Long accountId = costaccount.getLong("id");
            QFilter filter = new QFilter("org", "=", (Object)orgId);
            filter.and("costaccount", "=", (Object)accountId);
            filter.and("period", "=", (Object)context.getPeriodId());
            boolean result = QueryServiceHelper.exists((String)"aca_calcresult", (QFilter[])new QFilter[]{filter});
            if (result) continue;
            accountNames.add(costaccount.getString("name"));
        }
        return accountNames;
    }
}

