/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.checker;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class DiffAllocCompleteCheck
extends AbstractSingleCalcCheckAction {
    public void doCheck() {
        CalcCheckContext context = this.getContext();
        List<String> costaccountNames = this.getNotHasDiffCalcAccountName(context);
        if (CadEmptyUtils.isEmpty(costaccountNames)) {
            return;
        }
        String checkDesc = ResManager.loadKDString((String)"\u672c\u671f\u672a\u8fdb\u884c\u5dee\u5f02\u5206\u644a\u8ba1\u7b97", (String)"DiffAllocCompleteCheck_0", (String)"macc-sca-algox", (Object[])new Object[0]);
        String detailDesc = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%s\u201d\u672c\u671f\u672a\u8fdb\u884c\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\u3002", (String)"DiffAllocCompleteCheck_1", (String)"macc-sca-algox", (Object[])new Object[0]);
        for (String costaccountName : costaccountNames) {
            CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
            info.setCheckDetailResult(String.format(detailDesc, costaccountName));
            this.getSingleCheckContext().getCheckDetailResult().add(info);
        }
        this.getSingleCheckContext().setCheckResult(checkDesc);
        this.getSingleCheckContext().setPass(false);
    }

    private List<String> getNotHasDiffCalcAccountName(CalcCheckContext context) {
        ArrayList<String> accountNames = new ArrayList<String>();
        Set relationCostAccountIds = new HashSet(10);
        if (context.getParams().get("relationCostAccountIds") != null) {
            relationCostAccountIds = (Set)context.getParams().get("relationCostAccountIds");
        }
        Map bdaccountMap = BusinessDataServiceHelper.loadFromCache((Object[])relationCostAccountIds.toArray(), (String)"cal_bd_costaccount");
        for (DynamicObject costaccount : bdaccountMap.values()) {
            Long orgId = costaccount.getLong("calorg.id");
            Long accountId = costaccount.getLong("id");
            QFilter filter = new QFilter("org", "=", (Object)orgId);
            filter.and("costaccount", "=", (Object)accountId);
            filter.and("period", "=", (Object)context.getPeriodId());
            boolean result = QueryServiceHelper.exists((String)"sca_diffcalcresult", (QFilter[])new QFilter[]{filter});
            if (result) continue;
            accountNames.add(costaccount.getString("name"));
        }
        return accountNames;
    }
}

