/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.checker;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class InitMterialWriteInCheck
extends AbstractSingleCalcCheckAction {
    public void doCheck() {
        CalcCheckContext checkParamJs = this.getContext();
        List<String> errorMsgs = this.getNotSetMaterial(checkParamJs);
        if (CadEmptyUtils.isEmpty(errorMsgs)) {
            return;
        }
        String checkDesc = ResManager.loadKDString((String)"\u5b58\u5728\u8fd8\u539f\u7269\u6599\u672a\u7ef4\u62a4\u671f\u521d\u534a\u6210\u54c1\u7ed3\u6784\u3002", (String)"InitMterialWriteInCheck_0", (String)"macc-sca-algox", (Object[])new Object[0]);
        for (String errorMsg : errorMsgs) {
            CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
            info.setCheckDetailResult(errorMsg);
            this.getSingleCheckContext().getCheckDetailResult().add(info);
        }
        this.getSingleCheckContext().setCheckResult(checkDesc);
        this.getSingleCheckContext().setPass(false);
    }

    private List<String> getNotSetMaterial(CalcCheckContext context) {
        ArrayList<String> errorMsgs = new ArrayList<String>();
        List accountIds = new ArrayList(10);
        if (context.getParams().get("relationCostAccountIds") != null) {
            accountIds = (List)context.getParams().get("relationCostAccountIds");
        }
        String calDimension = (String)context.getParams().get("calDimension");
        Map bdaccountMap = BusinessDataServiceHelper.loadFromCache((Object[])accountIds.toArray(), (String)"cal_bd_costaccount");
        for (DynamicObject costaccount : bdaccountMap.values()) {
            Long orgId = costaccount.getLong("calorg.id");
            Long accountId = costaccount.getLong("id");
            Set<Long> mats = null;
            String costaccountName = costaccount.getString("name");
            if (SysParamEnum.RESTOREDIMENSION_ORG.getValue().equals(calDimension) || context.getManuOrgId() > 0L) {
                Set<Long> reductMats = this.getReductMat(orgId, accountId, context.getManuOrgId());
                Set<Long> halfPrdDatas = this.getHalfProdData(orgId, accountId, context.getManuOrgId(), context.getPeriodId());
                reductMats.removeAll(halfPrdDatas);
                mats = reductMats;
                if (mats.size() <= 0) continue;
                DynamicObjectCollection matinfos = QueryServiceHelper.query((String)"bd_material", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", mats)});
                for (DynamicObject obj : matinfos) {
                    errorMsgs.add(String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u3010%1$s\u3011\uff0c\u7269\u6599\u3010\u7f16\u53f7\uff1a%2$s\uff0c\u540d\u79f0\uff1a%3$s\u3011\u6ca1\u6709\u7ef4\u62a4\u671f\u521d\u534a\u6210\u54c1\u7ed3\u6784", (String)"InitMterialWriteInCheck_5", (String)"macc-sca-algox", (Object[])new Object[0]), costaccountName, obj.getString("number"), obj.getString("name")));
                }
                continue;
            }
            List manuOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)orgId, (boolean)true);
            for (Long manuOrg : manuOrgs) {
                Set<Long> reductMats = this.getReductMat(orgId, accountId, manuOrg);
                Set<Long> halfPrdDatas = this.getHalfProdData(orgId, accountId, manuOrg, context.getPeriodId());
                reductMats.removeAll(halfPrdDatas);
                mats = reductMats;
                if (mats.size() <= 0) continue;
                DynamicObject manuOrgDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)manuOrg, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
                DynamicObjectCollection matinfos = QueryServiceHelper.query((String)"bd_material", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", mats)});
                String manuOrgName = manuOrgDyn != null ? manuOrgDyn.getString("name") : "";
                for (DynamicObject obj : matinfos) {
                    errorMsgs.add(String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u3010%1$s\u3011\u4e0b\u7684\u751f\u4ea7\u7ec4\u7ec7\u3010%2$s\u3011\uff0c\u7269\u6599\u3010\u7f16\u53f7\uff1a%3$s\uff0c\u540d\u79f0\uff1a%4$s\u3011\u6ca1\u6709\u7ef4\u62a4\u671f\u521d\u534a\u6210\u54c1\u7ed3\u6784", (String)"InitMterialWriteInCheck_6", (String)"macc-sca-algox", (Object[])new Object[0]), costaccountName, manuOrgName, obj.getString("number"), obj.getString("name")));
                }
            }
        }
        return errorMsgs;
    }

    private Set<Long> getReductMat(Long org, Long costaccount, Long prdorg) {
        QFilter qforg = new QFilter("org", "=", (Object)org);
        QFilter qfacct = new QFilter("costaccount", "=", (Object)costaccount);
        qforg.and("prdorg", "=", (Object)prdorg);
        QFilter qfreductBase = new QFilter("entryentity.reductparaset", "=", (Object)"1");
        DynamicObjectCollection matParamSets = QueryServiceHelper.query((String)"CostReductCheck.queryReductParam", (String)"sca_matreductset", (String)"org,costaccount,prdorg,entryentity.material.masterid material,entryentity.materialsort materialgroup", (QFilter[])new QFilter[]{qfacct, qforg, qfreductBase}, null);
        HashSet<Long> matgroup = new HashSet<Long>(16);
        HashSet<Long> extMaterial = new HashSet<Long>(16);
        for (DynamicObject matParamSet : matParamSets) {
            if (CadEmptyUtils.isEmpty((Long)matParamSet.getLong("material"))) {
                matgroup.add(matParamSet.getLong("materialgroup"));
            }
            extMaterial.add(matParamSet.getLong("material"));
        }
        HashSet<Long> proMatIdSet = new HashSet<Long>(16);
        QFilter qfmatgroup = new QFilter("group", "not in", matgroup);
        QFilter qfenablePro = new QFilter("enableproduct", "=", (Object)true);
        QFilter qfmatBase = new QFilter("status", "=", (Object)"C");
        qfmatBase.and(new QFilter("enable", "=", (Object)"1"));
        List proMatIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_material", (QFilter[])new QFilter[]{qfmatgroup, qfenablePro, qfmatBase}, null, (int)-1);
        for (Object proMatId : proMatIds) {
            proMatIdSet.add((Long)proMatId);
        }
        proMatIdSet.removeAll(extMaterial);
        return proMatIdSet;
    }

    private Set<Long> getHalfProdData(Long org, Long costaccount, Long prdorg, Long period) {
        QFilter filter = new QFilter("org", "=", (Object)org);
        filter.and("costaccount", "=", (Object)costaccount);
        filter.and("prdorg", "=", (Object)prdorg);
        filter.and("period", "=", (Object)period);
        DynamicObjectCollection halfprods = QueryServiceHelper.query((String)"sca_halfprdstructure", (String)"material.masterid material", (QFilter[])new QFilter[]{filter});
        return halfprods.stream().map(s -> s.getLong("material")).collect(Collectors.toSet());
    }
}

