/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.costrec.CostRecoveryParams;
import kd.macc.sca.algox.costrec.function.CostRecoveryDiffCalculateHelper;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.CurrencyHelper;
import kd.macc.sca.algox.utils.DataSetXHelper;

public class CostRecoveryCalculateForPursFunction
extends GroupReduceFunction {
    private RowMeta srcMeta;
    private CostRecoveryParams crParams;
    private static final long serialVersionUID = 1L;

    public CostRecoveryCalculateForPursFunction(RowMeta rowMeta, CostRecoveryParams crParams) {
        this.srcMeta = rowMeta;
        this.crParams = crParams;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        DataSet dataset = DataSetXHelper.getDsFromAlgoxRows(iterable, new String[]{"materialId", "level", "treepath", "keytreepath", "subMaterialId"}, this.srcMeta);
        ArrayList<RowX> rowxs = new ArrayList<RowX>(64);
        while (dataset.hasNext()) {
            Row row = dataset.next();
            RowX rowx = new RowX(this.srcMeta.getFieldCount());
            for (int i = 0; i < this.srcMeta.getFieldCount(); ++i) {
                rowx.set(i, row.get(i));
            }
            rowxs.add(rowx);
        }
        Iterator it = rowxs.iterator();
        Long currencyId = CurrencyHelper.getCurrencyByCostAccountId(this.crParams.getCostAccountId());
        BigDecimal totalAmount = BigDecimal.ZERO;
        int amtScale = CurrencyHelper.getAmtSacleByCurrencyId(currencyId);
        BigDecimal preProQty = BigDecimal.ZERO;
        BigDecimal proQty = BigDecimal.ZERO;
        BigDecimal proTransInQty = BigDecimal.ZERO;
        BigDecimal proPursInQty = BigDecimal.ZERO;
        ArrayList allRowX = Lists.newArrayList();
        ArrayList totalRowX = Lists.newArrayList();
        while (it.hasNext()) {
            RowX row = (RowX)it.next();
            int subEntryType = row.getInteger(this.srcMeta.getFieldIndex("subEntryType"));
            if (subEntryType == 0) {
                BigDecimal actAmountForTrans = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("actAmountForTrans"))).setScale(amtScale, 4);
                BigDecimal pursInAmt = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pursInAmt"))).setScale(amtScale, 4);
                BigDecimal actAmountForPurs = actAmountForTrans.add(pursInAmt).setScale(amtScale, 4);
                row.set(this.srcMeta.getFieldIndex("actAmountForPurs"), (Object)actAmountForPurs);
                BigDecimal actQtyForTrans = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("actQtyForTrans")));
                BigDecimal pursInQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pursInQty")));
                BigDecimal actQty = actQtyForTrans.add(pursInQty);
                row.set(this.srcMeta.getFieldIndex("actQtyForPurs"), (Object)actQty);
                int level = row.getInteger(this.srcMeta.getFieldIndex("level"));
                if (level == 1) {
                    totalAmount = totalAmount.add(actAmountForPurs);
                }
                allRowX.add(row);
                continue;
            }
            totalRowX.add(row);
        }
        CostRecoveryDiffCalculateHelper.diffCalculate(allRowX, amtScale, this.srcMeta, 3);
        ArrayList saveRowX = Lists.newArrayListWithExpectedSize((int)64);
        int index = 0;
        for (RowX row : allRowX) {
            if (index == 0) {
                preProQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("preProQty")));
                proQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("proQty")));
                proTransInQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("proTransInQty")));
                proPursInQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("proPursInQty")));
            }
            BigDecimal actQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("actQtyForPurs")));
            BigDecimal actAmount = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("actAmountForPurs"))).setScale(amtScale, 4);
            if (BigDecimal.ZERO.compareTo(actQty) == 0 && BigDecimal.ZERO.compareTo(actAmount) == 0) continue;
            BigDecimal preTotalQty = preProQty.add(proQty).add(proTransInQty).add(proPursInQty);
            BigDecimal unitQty = BigDecimal.ZERO;
            BigDecimal unitAmt = BigDecimal.ZERO;
            if (preTotalQty.compareTo(BigDecimal.ZERO) != 0) {
                unitQty = actQty.divide(preTotalQty, 10, RoundingMode.HALF_UP);
                unitAmt = actAmount.divide(preTotalQty, 10, RoundingMode.HALF_UP).setScale(this.crParams.getPriceScale(), RoundingMode.HALF_UP);
            }
            row.set(this.srcMeta.getFieldIndex("proActQty"), (Object)preTotalQty);
            row.set(this.srcMeta.getFieldIndex("proActAmt"), (Object)totalAmount);
            row.set(this.srcMeta.getFieldIndex("unitQty"), (Object)unitQty);
            BigDecimal amountCoeff = BigDecimal.ZERO;
            if (totalAmount.compareTo(BigDecimal.ZERO) != 0) {
                amountCoeff = actAmount.divide(totalAmount, 10, RoundingMode.HALF_UP);
            }
            row.set(this.srcMeta.getFieldIndex("amountCoeff"), (Object)amountCoeff);
            row.set(this.srcMeta.getFieldIndex("actQtyForPurs"), (Object)actQty);
            row.set(this.srcMeta.getFieldIndex("actAmountForPurs"), (Object)actAmount);
            ++index;
            saveRowX.add(row);
        }
        for (RowX rowX : saveRowX) {
            collector.collect(rowX);
        }
        for (RowX rowX : totalRowX) {
            collector.collect(rowX);
        }
    }
}

