/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.costrec.CostRecoveryParams;
import kd.macc.sca.algox.costrec.function.CostRecoveryDiffCalculateHelper;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.CurrencyHelper;
import kd.macc.sca.algox.utils.DataSetXHelper;

public class CostRecoveryCalculateFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = -1956456673757226285L;
    private RowMeta srcMeta;
    private CostRecoveryParams crParams;

    public CostRecoveryCalculateFunction(RowMeta srcMeta, CostRecoveryParams crParams) {
        this.srcMeta = srcMeta;
        this.crParams = crParams;
    }

    public RowMeta getSrcMeta() {
        return this.srcMeta;
    }

    public void setSrcMeta(RowMeta srcMeta) {
        this.srcMeta = srcMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        DataSet dataset = DataSetXHelper.getDsFromAlgoxRows(iterable, new String[]{"materialId", "level", "treepath", "keytreepath", "subMaterialId"}, this.srcMeta);
        ArrayList<RowX> rowxs = new ArrayList<RowX>(64);
        while (dataset.hasNext()) {
            Row row = dataset.next();
            RowX rowx = new RowX(this.srcMeta.getFieldCount());
            for (int i = 0; i < this.srcMeta.getFieldCount(); ++i) {
                rowx.set(i, row.get(i));
            }
            rowxs.add(rowx);
        }
        Iterator it = rowxs.iterator();
        Long currencyId = CurrencyHelper.getCurrencyByCostAccountId(this.crParams.getCostAccountId());
        BigDecimal totalAmount = BigDecimal.ZERO;
        int amtScale = CurrencyHelper.getAmtSacleByCurrencyId(currencyId);
        BigDecimal preProQty = BigDecimal.ZERO;
        BigDecimal proQty = BigDecimal.ZERO;
        ArrayList allRowX = Lists.newArrayListWithExpectedSize((int)64);
        while (it.hasNext()) {
            RowX row = (RowX)it.next();
            BigDecimal preAmount = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("preAmount"))).setScale(amtScale, 4);
            BigDecimal finAmount = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("finAmount"))).setScale(amtScale, 4);
            BigDecimal actAmount = preAmount.add(finAmount).setScale(amtScale, 4);
            row.set(this.srcMeta.getFieldIndex("actAmountForFinish"), (Object)actAmount);
            BigDecimal preQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("preQty")));
            BigDecimal finQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("finQty")));
            BigDecimal actQty = preQty.add(finQty);
            row.set(this.srcMeta.getFieldIndex("actQtyForFinish"), (Object)actQty);
            if (BigDecimal.ZERO.compareTo(actQty) == 0 && BigDecimal.ZERO.compareTo(actAmount) == 0 && BigDecimal.ZERO.compareTo(finQty) == 0 && BigDecimal.ZERO.compareTo(finAmount) == 0) continue;
            int level = row.getInteger(this.srcMeta.getFieldIndex("level"));
            if (level == 1) {
                totalAmount = totalAmount.add(actAmount);
            }
            allRowX.add(row);
        }
        CostRecoveryDiffCalculateHelper.diffCalculate(allRowX, amtScale, this.srcMeta, 1);
        ArrayList saveRowX = Lists.newArrayListWithExpectedSize((int)64);
        int index = 0;
        for (RowX row : allRowX) {
            if (index == 0) {
                preProQty = row.getBigDecimal(this.srcMeta.getFieldIndex("preProQty")) == null ? BigDecimal.ZERO : row.getBigDecimal(this.srcMeta.getFieldIndex("preProQty"));
                proQty = row.getBigDecimal(this.srcMeta.getFieldIndex("proQty")) == null ? BigDecimal.ZERO : row.getBigDecimal(this.srcMeta.getFieldIndex("proQty"));
            }
            BigDecimal actQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("actQtyForFinish"))).setScale(10, 4);
            BigDecimal actAmount = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("actAmountForFinish"))).setScale(amtScale, 4);
            BigDecimal finAmount = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("finAmount")));
            BigDecimal finQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("finQty")));
            if (BigDecimal.ZERO.compareTo(actQty) == 0 && BigDecimal.ZERO.compareTo(actAmount) == 0 && BigDecimal.ZERO.compareTo(finQty) == 0 && BigDecimal.ZERO.compareTo(finAmount) == 0) continue;
            BigDecimal preTotalQty = preProQty.add(proQty);
            BigDecimal unitQty = BigDecimal.ZERO;
            BigDecimal unitAmt = BigDecimal.ZERO;
            if (preTotalQty.compareTo(BigDecimal.ZERO) != 0) {
                unitQty = actQty.divide(preTotalQty, 10, RoundingMode.HALF_UP);
                unitAmt = actAmount.divide(preTotalQty, 10, RoundingMode.HALF_UP).setScale(this.crParams.getPriceScale(), RoundingMode.HALF_UP);
            }
            row.set(this.srcMeta.getFieldIndex("proActQty"), (Object)preTotalQty);
            row.set(this.srcMeta.getFieldIndex("proActAmt"), (Object)totalAmount);
            row.set(this.srcMeta.getFieldIndex("unitQty"), (Object)unitQty);
            row.set(this.srcMeta.getFieldIndex("unitAmt"), (Object)unitAmt);
            BigDecimal amountCoeff = BigDecimal.ZERO;
            if (totalAmount.compareTo(BigDecimal.ZERO) != 0) {
                amountCoeff = actAmount.divide(totalAmount, 10, RoundingMode.HALF_UP);
            }
            row.set(this.srcMeta.getFieldIndex("amountCoeff"), (Object)amountCoeff);
            row.set(this.srcMeta.getFieldIndex("actQtyForFinish"), (Object)actQty);
            row.set(this.srcMeta.getFieldIndex("actAmountForFinish"), (Object)actAmount);
            ++index;
            saveRowX.add(row);
        }
        for (RowX rowX : saveRowX) {
            collector.collect(rowX);
        }
    }
}

