/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.DataSetXHelper;

public class CostRecoveryFlagEquationFunction
extends GroupReduceFunction {
    private RowMeta srcMeta;
    private boolean isPurIns;
    private static final long serialVersionUID = 1L;

    public RowMeta getSrcMeta() {
        return this.srcMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public CostRecoveryFlagEquationFunction(RowMeta srcMeta, boolean isPurIns) {
        this.srcMeta = srcMeta;
        this.isPurIns = isPurIns;
    }

    public void reduce(Iterable<RowX> iterable, Collector collect) {
        DataSet dataset = DataSetXHelper.getDsFromAlgoxRows(iterable, new String[]{"materialId", "level", "treepath", "keytreepath", "subMaterialId"}, this.srcMeta);
        ArrayList<RowX> rowxs = new ArrayList<RowX>(64);
        while (dataset.hasNext()) {
            Row row = dataset.next();
            RowX rowx = new RowX(this.srcMeta.getFieldCount());
            for (int i = 0; i < this.srcMeta.getFieldCount(); ++i) {
                rowx.set(i, row.get(i));
            }
            rowxs.add(rowx);
        }
        Iterator it = rowxs.iterator();
        ArrayList saveList = Lists.newArrayListWithExpectedSize((int)64);
        HashMap parentSetMap = Maps.newHashMapWithExpectedSize((int)16);
        while (it.hasNext()) {
            RowX row = (RowX)it.next();
            String keytreepath = row.getString(this.srcMeta.getFieldIndex("keytreepath"));
            String tmpTree = keytreepath.substring(0, keytreepath.lastIndexOf("@"));
            List list = parentSetMap.computeIfAbsent(tmpTree, p -> Lists.newArrayList());
            list.add(row);
            saveList.add(row);
        }
        String actKey = this.isPurIns ? "actAmountForTrans" : "actAmountForFinish";
        for (RowX row : saveList) {
            String keytreepath = row.getString(this.srcMeta.getFieldIndex("keytreepath"));
            row.set(this.srcMeta.getFieldIndex("isFlagEquation"), (Object)1);
            if (parentSetMap.containsKey(keytreepath)) {
                row.set(this.srcMeta.getFieldIndex("isLeaf"), (Object)0);
            } else {
                row.set(this.srcMeta.getFieldIndex("isLeaf"), (Object)1);
            }
            if (row.getBigDecimal(this.srcMeta.getFieldIndex("proActAmt")).compareTo(BigDecimal.ZERO) <= 0) continue;
            this.extractedProcess(parentSetMap, actKey, keytreepath);
        }
        for (RowX row : saveList) {
            collect.collect(row);
        }
    }

    private void extractedProcess(Map<String, List<RowX>> parentSetMap, String actKey, String treepath) {
        block5: {
            String tmpTree = treepath.substring(0, treepath.lastIndexOf("@"));
            if (parentSetMap.get(tmpTree) == null) break block5;
            List<RowX> subRowList = parentSetMap.get(tmpTree);
            boolean isAllZero = true;
            for (RowX subRow : subRowList) {
                BigDecimal tmpBig = BigDecimalUtils.getBigDecimalOrZero(subRow.getBigDecimal(this.srcMeta.getFieldIndex(actKey)));
                if (tmpBig.compareTo(BigDecimal.ZERO) == 0) continue;
                isAllZero = false;
            }
            if (isAllZero) {
                for (RowX subRow : subRowList) {
                    subRow.set(this.srcMeta.getFieldIndex("isFlagEquation"), (Object)0);
                }
            } else {
                for (RowX subRow : subRowList) {
                    subRow.set(this.srcMeta.getFieldIndex("isFlagEquation"), (Object)1);
                }
            }
        }
    }
}

