/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.costrec.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.util.Tuple2;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.ID;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.sca.algox.costrec.CostRecCalcHelper;
import kd.macc.sca.algox.costrec.CostRecoveryParams;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.CurrencyHelper;
import kd.macc.sca.algox.utils.DataSetXHelper;
import kd.macc.sca.algox.utils.EntityHelper;

public class CostRecoveryPreConstrBillSaveFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = -1956456673757226285L;
    private RowMeta srcMeta;
    private CostRecoveryParams crParams;
    private Map<Long, Set<String>> userModifyMaterialIdSetMap;
    private Map<Long, Tuple2<Long, Integer>> matToBaseUnitMap = Maps.newHashMapWithExpectedSize((int)10);
    private Map<Long, Long> keyCalOrgIdValCostAccountIdMap;

    public CostRecoveryPreConstrBillSaveFunction(RowMeta srcMeta, CostRecoveryParams crParams, Map<Long, Set<String>> userModifyMaterialIdSetMap, Map<Long, Long> keyCalOrgIdValCostAccountIdMap) {
        this.srcMeta = srcMeta;
        this.crParams = crParams;
        this.userModifyMaterialIdSetMap = userModifyMaterialIdSetMap;
        this.keyCalOrgIdValCostAccountIdMap = keyCalOrgIdValCostAccountIdMap;
    }

    public RowMeta getSrcMeta() {
        return this.srcMeta;
    }

    public void setSrcMeta(RowMeta srcMeta) {
        this.srcMeta = srcMeta;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public void setCommonFields(DynamicObject dyo) {
        Date date = TimeServiceHelper.now();
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        dyo.set("billstatus", (Object)"C");
        dyo.set("createtime", (Object)date);
        dyo.set("auditdate", (Object)date);
        dyo.set("modifytime", (Object)date);
        dyo.set("creator_id", (Object)userId);
        dyo.set("modifier_id", (Object)userId);
        dyo.set("auditor_id", (Object)userId);
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        List produceLists;
        DataSet dataset = DataSetXHelper.getDsFromAlgoxRows(iterable, new String[]{"subEntryType", "materialId", "level", "treepath", "keytreepath", "subMaterialId", "elementId", "subElementId"}, this.srcMeta);
        ArrayList<RowX> rowxs = new ArrayList<RowX>(64);
        while (dataset.hasNext()) {
            Row row = dataset.next();
            RowX rowx = new RowX(this.srcMeta.getFieldCount());
            for (int i = 0; i < this.srcMeta.getFieldCount(); ++i) {
                rowx.set(i, row.get(i));
            }
            rowxs.add(rowx);
        }
        Iterator it = rowxs.iterator();
        HashSet preHalfNotContainsPath = Sets.newHashSetWithExpectedSize((int)10);
        DynamicObject preHalfbill = BusinessDataServiceHelper.newDynamicObject((String)"sca_halfprdhide");
        DynamicObject preHalfbillFront = BusinessDataServiceHelper.newDynamicObject((String)"sca_halfprdstructure");
        DynamicObject costRecoveryBill = BusinessDataServiceHelper.newDynamicObject((String)"sca_costrecovry");
        preHalfbillFront.set("billno", (Object)EntityHelper.getBillNumber("sca_halfprdstructure"));
        this.setCommonFields(preHalfbill);
        this.setCommonFields(costRecoveryBill);
        this.setCommonFields(preHalfbillFront);
        costRecoveryBill.set("billno", (Object)ID.genStringId());
        preHalfbill.set("billno", (Object)ID.genStringId());
        costRecoveryBill.set("calcreport", (Object)this.crParams.getCalcReportId());
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalFinAmount = BigDecimal.ZERO;
        BigDecimal totalPreAmount = BigDecimal.ZERO;
        BigDecimal totalTransInAmount = BigDecimal.ZERO;
        BigDecimal totalPursInAmount = BigDecimal.ZERO;
        BigDecimal unitTotalAmount = BigDecimal.ZERO;
        Long materialId = 0L;
        Long materialVerId = 0L;
        Long materialAuxPropId = 0L;
        Long calckeycolId = 0L;
        Long calOrgId = 0L;
        Long invOrgId = 0L;
        BigDecimal preProQty = BigDecimal.ZERO;
        BigDecimal proQty = BigDecimal.ZERO;
        BigDecimal proTransInQty = BigDecimal.ZERO;
        BigDecimal proPursInQty = BigDecimal.ZERO;
        ArrayList allRowX = Lists.newArrayList();
        HashMap subEntryMap = Maps.newHashMapWithExpectedSize((int)64);
        int index = 0;
        while (it.hasNext()) {
            int subEntryType;
            RowX row = (RowX)it.next();
            if (index == 0) {
                materialId = row.getLong(this.srcMeta.getFieldIndex("materialId"));
                materialVerId = row.getLong(this.srcMeta.getFieldIndex("materialVerId"));
                materialAuxPropId = row.getLong(this.srcMeta.getFieldIndex("materialAuxPropId"));
                calckeycolId = row.getLong(this.srcMeta.getFieldIndex("calckeycolId"));
                calOrgId = row.getLong(this.srcMeta.getFieldIndex("calOrgId"));
                invOrgId = row.getLong(this.srcMeta.getFieldIndex("invOrgId"));
                preProQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("preProQty")));
                proQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("proQty")));
                proTransInQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("proTransInQty")));
                proPursInQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("proPursInQty")));
            }
            if ((subEntryType = row.getInteger(this.srcMeta.getFieldIndex("subEntryType")).intValue()) == 0) {
                BigDecimal preAmount = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("preAmount"))).setScale(this.crParams.getAmtScale(), 4);
                BigDecimal finAmount = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("finAmount"))).setScale(this.crParams.getAmtScale(), 4);
                BigDecimal transInAmt = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("transInAmt"))).setScale(this.crParams.getAmtScale(), 4);
                BigDecimal pursInAmt = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pursInAmt"))).setScale(this.crParams.getAmtScale(), 4);
                BigDecimal actAmount = this.getActAmount(row);
                row.set(this.srcMeta.getFieldIndex("actAmount"), (Object)actAmount);
                int level = row.getInteger(this.srcMeta.getFieldIndex("level"));
                if (level == 1) {
                    totalAmount = totalAmount.add(actAmount);
                    totalFinAmount = totalFinAmount.add(finAmount);
                    totalPreAmount = totalPreAmount.add(preAmount);
                    totalTransInAmount = totalTransInAmount.add(transInAmt);
                    totalPursInAmount = totalPursInAmount.add(pursInAmt);
                }
                allRowX.add(row);
            } else if (subEntryType == 11 || subEntryType == 22) {
                String key = row.getLong(this.srcMeta.getFieldIndex("materialId")) + "@" + row.getLong(this.srcMeta.getFieldIndex("materialVerId")) + "@" + row.getLong(this.srcMeta.getFieldIndex("materialAuxPropId")) + "@" + row.getLong(this.srcMeta.getFieldIndex("calckeycolId"));
                List list = subEntryMap.computeIfAbsent(key, p -> Lists.newArrayList());
                list.add(row);
            } else if (subEntryType == 1 || subEntryType == 2) {
                String keytreePath = row.getString(this.srcMeta.getFieldIndex("keytreePath"));
                String subElementId = row.getString(this.srcMeta.getFieldIndex("subElementId"));
                String isUnAbsorbd = row.getString(this.srcMeta.getFieldIndex("isUnAbsorbd"));
                String key = keytreePath + "@" + subElementId + "@" + (String)isUnAbsorbd;
                List list = subEntryMap.computeIfAbsent(key, p -> Lists.newArrayList());
                list.add(row);
            }
            ++index;
        }
        Long costAccountId = this.keyCalOrgIdValCostAccountIdMap.get(calOrgId);
        Long currencyId = CurrencyHelper.getCurrencyByCostAccountId(costAccountId);
        int amtScale = CurrencyHelper.getAmtSacleByCurrencyId(currencyId);
        preHalfbill.set("costaccount_id", (Object)costAccountId);
        preHalfbillFront.set("costaccount_id", (Object)costAccountId);
        costRecoveryBill.set("costaccount_id", (Object)costAccountId);
        preHalfbill.set("org_id", (Object)calOrgId);
        preHalfbillFront.set("org_id", (Object)calOrgId);
        costRecoveryBill.set("org_id", (Object)calOrgId);
        if (this.crParams.getManuOrgId() != 0L) {
            preHalfbill.set("prdorg_id", (Object)this.crParams.getManuOrgId());
            preHalfbillFront.set("prdorg_id", (Object)this.crParams.getManuOrgId());
            costRecoveryBill.set("manuorg_id", (Object)this.crParams.getManuOrgId());
        }
        preHalfbill.set("currency_id", (Object)currencyId);
        preHalfbillFront.set("currency_id", (Object)currencyId);
        costRecoveryBill.set("currency_id", (Object)currencyId);
        preHalfbill.set("period_id", (Object)this.crParams.getNextPeriodId());
        preHalfbillFront.set("period_id", (Object)this.crParams.getNextPeriodId());
        costRecoveryBill.set("period_id", (Object)this.crParams.getPeriodId());
        costRecoveryBill.set("caltime", (Object)TimeServiceHelper.now());
        HashMap parentSetMap = Maps.newHashMapWithExpectedSize((int)16);
        index = 0;
        for (RowX row : allRowX) {
            BigDecimal preQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("preQty")));
            BigDecimal finQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("finQty")));
            BigDecimal transInQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("transInQty")));
            BigDecimal pursInQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pursInQty")));
            BigDecimal actQty = this.getActQty(row);
            BigDecimal preAmount = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("preAmount"))).setScale(amtScale, 4);
            BigDecimal finAmount = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("finAmount"))).setScale(amtScale, 4);
            BigDecimal transInAmt = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("transInAmt"))).setScale(amtScale, 4);
            BigDecimal pursInAmt = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("pursInAmt"))).setScale(amtScale, 4);
            BigDecimal actAmount = this.getActAmount(row);
            if (BigDecimal.ZERO.compareTo(actQty) == 0 && BigDecimal.ZERO.compareTo(actAmount) == 0 && BigDecimal.ZERO.compareTo(finAmount) == 0) continue;
            Long subMaterialId = row.getLong(this.srcMeta.getFieldIndex("subMaterialId"));
            Tuple2<Long, Integer> matbaseUnit = this.getMatUnitPrecision(row, subMaterialId);
            BigDecimal preTotalQty = preProQty.add(proQty).add(proTransInQty).add(proPursInQty);
            BigDecimal unitQty = BigDecimal.ZERO;
            BigDecimal unitAmt = BigDecimal.ZERO;
            if (preTotalQty.compareTo(BigDecimal.ZERO) != 0) {
                unitQty = actQty.divide(preTotalQty, (int)((Integer)matbaseUnit.t2), RoundingMode.HALF_UP);
                unitQty = unitQty.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : unitQty;
                unitAmt = actAmount.divide(preTotalQty, 10, RoundingMode.HALF_UP).setScale(this.crParams.getPriceSaveScale(), RoundingMode.HALF_UP);
            }
            DynamicObject costRecoveryEntry = costRecoveryBill.getDynamicObjectCollection("entryentity").addNew();
            costRecoveryEntry.set("element_id", (Object)row.getLong(this.srcMeta.getFieldIndex("elementId")));
            Long subElementId = row.getLong(this.srcMeta.getFieldIndex("subElementId"));
            costRecoveryEntry.set("subelement_id", (Object)subElementId);
            int level = row.getInteger(this.srcMeta.getFieldIndex("level"));
            costRecoveryEntry.set("level", (Object)row.getInteger(this.srcMeta.getFieldIndex("level")));
            String treePath = row.getString(this.srcMeta.getFieldIndex("treepath"));
            String keytreePath = row.getString(this.srcMeta.getFieldIndex("keytreepath"));
            costRecoveryEntry.set("treePath", (Object)treePath);
            costRecoveryEntry.set("keytreepath", (Object)keytreePath);
            costRecoveryEntry.set("submaterial_id", (Object)subMaterialId);
            costRecoveryEntry.set("submaterialver_id", (Object)row.getLong(this.srcMeta.getFieldIndex("subMertialVerId")));
            costRecoveryEntry.set("submaterialauxprop_id", (Object)row.getLong(this.srcMeta.getFieldIndex("subMerialAuxPropId")));
            costRecoveryEntry.set("subcalckeycol_id", (Object)row.getLong(this.srcMeta.getFieldIndex("subCalckeycolId")));
            String isUnAbsorbd = row.getString(this.srcMeta.getFieldIndex("isUnAbsorbd"));
            costRecoveryEntry.set("isunabsorb", (Object)isUnAbsorbd);
            BigDecimal amountCoeff = BigDecimal.ZERO;
            if (totalAmount.compareTo(BigDecimal.ZERO) != 0) {
                amountCoeff = actAmount.divide(totalAmount, 10, RoundingMode.HALF_UP);
            }
            if (BigDecimal.ZERO.compareTo(unitQty) != 0 || BigDecimal.ZERO.compareTo(unitAmt) != 0) {
                boolean isNotAdd = false;
                for (String path : preHalfNotContainsPath) {
                    if (!keytreePath.startsWith(path)) continue;
                    isNotAdd = true;
                    break;
                }
                if (!isNotAdd) {
                    DynamicObject preHalfEntry = preHalfbill.getDynamicObjectCollection("entryentity").addNew();
                    preHalfEntry.set("qty", (Object)unitQty);
                    preHalfEntry.set("amount", (Object)unitAmt);
                    preHalfEntry.set("seq", (Object)(index + 1));
                    preHalfEntry.set("element_id", (Object)row.getLong(this.srcMeta.getFieldIndex("elementId")));
                    preHalfEntry.set("subelement_id", (Object)subElementId);
                    preHalfEntry.set("level", (Object)level);
                    preHalfEntry.set("treePath", (Object)treePath);
                    preHalfEntry.set("keytreePath", (Object)keytreePath);
                    preHalfEntry.set("submaterial_id", (Object)subMaterialId);
                    preHalfEntry.set("submaterialversion_id", (Object)row.getLong(this.srcMeta.getFieldIndex("subMertialVerId")));
                    preHalfEntry.set("submaterialauxprop_id", (Object)row.getLong(this.srcMeta.getFieldIndex("subMerialAuxPropId")));
                    preHalfEntry.set("subcalckeycol_id", (Object)row.getLong(this.srcMeta.getFieldIndex("subCalckeycolId")));
                    preHalfEntry.set("isunabsorb", (Object)isUnAbsorbd);
                    preHalfEntry.set("amountcoeff", (Object)amountCoeff);
                }
            } else {
                preHalfNotContainsPath.add(keytreePath + "@");
            }
            if (level == 1) {
                unitTotalAmount = unitTotalAmount.add(unitAmt);
            }
            costRecoveryEntry.set("preQty", (Object)preQty);
            costRecoveryEntry.set("preAmount", (Object)preAmount.setScale(amtScale, RoundingMode.HALF_UP));
            costRecoveryEntry.set("qty", (Object)finQty);
            costRecoveryEntry.set("amount", (Object)finAmount.setScale(amtScale, RoundingMode.HALF_UP));
            costRecoveryEntry.set("transinqty", (Object)transInQty);
            costRecoveryEntry.set("transinamount", (Object)transInAmt.setScale(amtScale, RoundingMode.HALF_UP));
            costRecoveryEntry.set("purqty", (Object)pursInQty);
            costRecoveryEntry.set("puramount", (Object)pursInAmt.setScale(amtScale, RoundingMode.HALF_UP));
            costRecoveryEntry.set("actqty", (Object)actQty);
            costRecoveryEntry.set("actamount", (Object)actAmount.setScale(amtScale, RoundingMode.HALF_UP));
            costRecoveryEntry.set("seq", (Object)(index + 1));
            if (level == 1 && (BigDecimal.ZERO.compareTo(unitQty) != 0 || BigDecimal.ZERO.compareTo(unitAmt) != 0)) {
                DynamicObject preHalfFrontEntry = preHalfbillFront.getDynamicObjectCollection("entryentity").addNew();
                preHalfFrontEntry.set("element_id", (Object)row.getLong(this.srcMeta.getFieldIndex("elementId")));
                preHalfFrontEntry.set("subelement_id", (Object)row.getLong(this.srcMeta.getFieldIndex("subElementId")));
                preHalfFrontEntry.set("materielunit_id", matbaseUnit.t1);
                String[] pathArr = treePath.split("@");
                if (!"0".equals(pathArr[pathArr.length - 1])) {
                    preHalfFrontEntry.set("submaterial_id", (Object)subMaterialId);
                    preHalfFrontEntry.set("submaterialversion_id", (Object)row.getLong(this.srcMeta.getFieldIndex("subMertialVerId")));
                    preHalfFrontEntry.set("submaterialauxprop_id", (Object)row.getLong(this.srcMeta.getFieldIndex("subMerialAuxPropId")));
                    preHalfFrontEntry.set("subcalckeycol_id", (Object)row.getLong(this.srcMeta.getFieldIndex("subCalckeycolId")));
                }
                preHalfFrontEntry.set("isunabsorb", (Object)isUnAbsorbd);
                preHalfFrontEntry.set("qty", (Object)unitQty);
                preHalfFrontEntry.set("amount", (Object)unitAmt);
                preHalfFrontEntry.set("tmptotalamt", (Object)actAmount);
                preHalfFrontEntry.set("seq", (Object)(index + 1));
            }
            if (level > 1) {
                BigDecimal[] bgs;
                String tmpTree = keytreePath.substring(0, keytreePath.lastIndexOf("@"));
                if (parentSetMap.get(tmpTree) == null) {
                    bgs = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
                    parentSetMap.put(tmpTree, bgs);
                }
                if ((bgs = (BigDecimal[])parentSetMap.get(tmpTree)) != null) {
                    bgs[0] = bgs[0].add(finAmount);
                    bgs[1] = bgs[1].add(transInAmt);
                    bgs[2] = bgs[2].add(pursInAmt);
                    parentSetMap.put(tmpTree, bgs);
                }
            }
            ++index;
            String key = keytreePath + "@" + subElementId + "@" + isUnAbsorbd;
            List subEntryList = (List)subEntryMap.get(key);
            if (subEntryList == null || subEntryList.size() <= 0) continue;
            for (int j = 0; j < subEntryList.size(); ++j) {
                RowX subRow = (RowX)subEntryList.get(j);
                int subEntryType = subRow.getInteger(this.srcMeta.getFieldIndex("subEntryType"));
                DynamicObject subEntry = costRecoveryEntry.getDynamicObjectCollection("subentryentity").addNew();
                if (subEntryType == 1) {
                    subEntry.set("subtransorg", (Object)subRow.getLong(this.srcMeta.getFieldIndex("transOutOrgId")));
                    subEntry.set("subtransqty", (Object)subRow.getBigDecimal(this.srcMeta.getFieldIndex("transInQty")));
                    subEntry.set("subtransamount", (Object)subRow.getBigDecimal(this.srcMeta.getFieldIndex("transInAmt")));
                    subEntry.set("subperiod", (Object)subRow.getBigDecimal(this.srcMeta.getFieldIndex("periodId")));
                    subEntry.set("subtranstype", (Object)"A");
                    continue;
                }
                if (subEntryType != 2) continue;
                subEntry.set("subtransorg", (Object)subRow.getLong(this.srcMeta.getFieldIndex("salesCalOrgId")));
                subEntry.set("subtransqty", (Object)subRow.getBigDecimal(this.srcMeta.getFieldIndex("pursInQty")));
                subEntry.set("subtransamount", (Object)subRow.getBigDecimal(this.srcMeta.getFieldIndex("pursInAmt")));
                subEntry.set("subperiod", (Object)subRow.getBigDecimal(this.srcMeta.getFieldIndex("periodId")));
                subEntry.set("subtranstype", (Object)"B");
            }
        }
        BigDecimal headActQty = preProQty.add(proQty).add(proTransInQty).add(proPursInQty);
        preHalfbill.set("material_id", (Object)materialId);
        preHalfbillFront.set("material_id", (Object)materialId);
        costRecoveryBill.set("material_id", (Object)materialId);
        preHalfbill.set("storageorgunit_id", (Object)invOrgId);
        preHalfbillFront.set("storageorgunit_id", (Object)invOrgId);
        costRecoveryBill.set("storageorgunit_id", (Object)invOrgId);
        if (!CadEmptyUtils.isEmpty(invOrgId) && this.crParams.getManuOrgId() == 0L && !CollectionUtils.isEmpty((Collection)(produceLists = OrgUnitServiceHelper.getFromOrgs((String)"05", (Long)invOrgId, (String)"04", (boolean)true)))) {
            preHalfbill.set("prdorg_id", produceLists.get(0));
            preHalfbillFront.set("prdorg_id", produceLists.get(0));
            costRecoveryBill.set("manuorg_id", produceLists.get(0));
        }
        preHalfbill.set("materialversion_id", (Object)materialVerId);
        preHalfbillFront.set("materialversion_id", (Object)materialVerId);
        costRecoveryBill.set("materialver_id", (Object)materialVerId);
        preHalfbill.set("auxprop_id", (Object)materialAuxPropId);
        preHalfbillFront.set("auxprop_id", (Object)materialAuxPropId);
        costRecoveryBill.set("auxprop_id", (Object)materialAuxPropId);
        preHalfbill.set("calckeycol_id", (Object)calckeycolId);
        preHalfbillFront.set("calckeycol_id", (Object)calckeycolId);
        costRecoveryBill.set("calckeycol_id", (Object)calckeycolId);
        costRecoveryBill.set("headpreqty", (Object)preProQty);
        costRecoveryBill.set("headqty", (Object)proQty);
        costRecoveryBill.set("headtotalqty", (Object)headActQty);
        costRecoveryBill.set("headtransinqty", (Object)proTransInQty);
        costRecoveryBill.set("headpurqty", (Object)proPursInQty);
        costRecoveryBill.set("headamount", (Object)totalFinAmount.setScale(amtScale, RoundingMode.HALF_UP));
        costRecoveryBill.set("headpreamt", (Object)totalPreAmount.setScale(amtScale, RoundingMode.HALF_UP));
        costRecoveryBill.set("headtotalamt", (Object)totalAmount.setScale(amtScale, RoundingMode.HALF_UP));
        costRecoveryBill.set("headtransinamt", (Object)totalTransInAmount.setScale(amtScale, RoundingMode.HALF_UP));
        costRecoveryBill.set("headpuramt", (Object)totalPursInAmount.setScale(amtScale, RoundingMode.HALF_UP));
        preHalfbill.set("totalamount", (Object)unitTotalAmount);
        preHalfbillFront.set("totalamount", (Object)unitTotalAmount);
        if (preHalfbill.getDynamicObjectCollection("entryentity").size() > 0) {
            DynamicObjectCollection doColl = preHalfbill.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : doColl) {
                String keytreePath = dynamicObject.getString("keytreePath");
                if (parentSetMap.containsKey(keytreePath)) {
                    dynamicObject.set("isleaf", (Object)Character.valueOf('0'));
                    continue;
                }
                dynamicObject.set("isleaf", (Object)Character.valueOf('1'));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{preHalfbill});
        }
        Set<String> userModifyMaterialIdSet = this.userModifyMaterialIdSetMap.get(calOrgId);
        if (preHalfbillFront.getDynamicObjectCollection("entryentity").size() > 0) {
            String matKey = CostRecCalcHelper.getKeyIdStr(preHalfbillFront.getLong("material_id"), preHalfbillFront.getLong("calckeycol_id"));
            if (userModifyMaterialIdSet == null || !userModifyMaterialIdSet.contains(matKey)) {
                preHalfbillFront.set("ismodify", (Object)Character.valueOf('0'));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{preHalfbillFront});
            }
        }
        if (costRecoveryBill.getDynamicObjectCollection("entryentity").size() > 0) {
            DynamicObject costRecoveryProductEntry = costRecoveryBill.getDynamicObjectCollection("entryentity").addNew();
            costRecoveryProductEntry.set("seq", (Object)0);
            costRecoveryProductEntry.set("level", (Object)0);
            costRecoveryProductEntry.set("treePath", (Object)materialId);
            costRecoveryProductEntry.set("keytreePath", (Object)CostRecCalcHelper.getKeyIdStr(materialId, calckeycolId));
            costRecoveryProductEntry.set("submaterial_id", (Object)materialId);
            costRecoveryProductEntry.set("submaterialver_id", (Object)materialVerId);
            costRecoveryProductEntry.set("submaterialauxprop_id", (Object)materialAuxPropId);
            costRecoveryProductEntry.set("subcalckeycol_id", (Object)calckeycolId);
            costRecoveryProductEntry.set("preQty", (Object)preProQty);
            costRecoveryProductEntry.set("preAmount", (Object)totalPreAmount);
            costRecoveryProductEntry.set("qty", (Object)proQty);
            costRecoveryProductEntry.set("amount", (Object)totalFinAmount);
            costRecoveryProductEntry.set("transinqty", (Object)proTransInQty);
            costRecoveryProductEntry.set("transinamount", (Object)totalTransInAmount);
            costRecoveryProductEntry.set("purqty", (Object)proPursInQty);
            costRecoveryProductEntry.set("puramount", (Object)totalPursInAmount);
            costRecoveryProductEntry.set("actqty", (Object)headActQty);
            costRecoveryProductEntry.set("actamount", (Object)totalAmount);
            String key = materialId + "@" + materialVerId + "@" + materialAuxPropId + "@" + calckeycolId;
            if (subEntryMap.get(key) != null && ((List)subEntryMap.get(key)).size() > 0) {
                List subEntryList = (List)subEntryMap.get(key);
                for (int j = 0; j < subEntryList.size(); ++j) {
                    RowX subRow = (RowX)subEntryList.get(j);
                    int subEntryType = subRow.getInteger(this.srcMeta.getFieldIndex("subEntryType"));
                    DynamicObject subEntry = costRecoveryProductEntry.getDynamicObjectCollection("subentryentity").addNew();
                    if (subEntryType == 11) {
                        subEntry.set("subtransorg", (Object)subRow.getLong(this.srcMeta.getFieldIndex("transOutOrgId")));
                        subEntry.set("subtransqty", (Object)subRow.getBigDecimal(this.srcMeta.getFieldIndex("proTransInQty")));
                        subEntry.set("subtransamount", (Object)subRow.getBigDecimal(this.srcMeta.getFieldIndex("proTransInAmt")));
                        subEntry.set("subperiod", (Object)subRow.getBigDecimal(this.srcMeta.getFieldIndex("periodId")));
                        subEntry.set("subtranstype", (Object)"A");
                        continue;
                    }
                    if (subEntryType != 22) continue;
                    subEntry.set("subtransorg", (Object)subRow.getLong(this.srcMeta.getFieldIndex("salesCalOrgId")));
                    subEntry.set("subtransqty", (Object)subRow.getBigDecimal(this.srcMeta.getFieldIndex("proPursInQty")));
                    subEntry.set("subtransamount", (Object)subRow.getBigDecimal(this.srcMeta.getFieldIndex("proPursInAmt")));
                    subEntry.set("subperiod", (Object)subRow.getBigDecimal(this.srcMeta.getFieldIndex("periodId")));
                    subEntry.set("subtranstype", (Object)"B");
                }
            }
            DynamicObjectCollection doColl = costRecoveryBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : doColl) {
                if (dynamicObject.getInt("level") == 0) {
                    dynamicObject.set("isleaf", (Object)Character.valueOf('0'));
                    continue;
                }
                String keytreePath = dynamicObject.getString("keytreePath");
                if (parentSetMap.containsKey(keytreePath)) {
                    BigDecimal subPursSum;
                    BigDecimal subTransSum;
                    dynamicObject.set("isleaf", (Object)Character.valueOf('0'));
                    dynamicObject.set("transleaf", (Object)Character.valueOf('0'));
                    dynamicObject.set("pursleaf", (Object)Character.valueOf('0'));
                    BigDecimal[] bgs = (BigDecimal[])parentSetMap.get(keytreePath);
                    BigDecimal subFinSum = bgs[0];
                    if (subFinSum != null && BigDecimal.ZERO.compareTo(subFinSum) == 0) {
                        dynamicObject.set("isleaf", (Object)Character.valueOf('1'));
                    }
                    if ((subTransSum = bgs[1]) != null && BigDecimal.ZERO.compareTo(subTransSum) == 0) {
                        dynamicObject.set("transleaf", (Object)Character.valueOf('1'));
                    }
                    if ((subPursSum = bgs[2]) == null || BigDecimal.ZERO.compareTo(subPursSum) != 0) continue;
                    dynamicObject.set("pursleaf", (Object)Character.valueOf('1'));
                    continue;
                }
                dynamicObject.set("isleaf", (Object)Character.valueOf('1'));
                dynamicObject.set("transleaf", (Object)Character.valueOf('1'));
                dynamicObject.set("pursleaf", (Object)Character.valueOf('1'));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{costRecoveryBill});
        }
    }

    private Tuple2<Long, Integer> getMatUnitPrecision(RowX row, Long subMaterialId) {
        Long baseUnit;
        int baseunitIndex;
        if (this.matToBaseUnitMap.containsKey(subMaterialId)) {
            return this.matToBaseUnitMap.get(subMaterialId);
        }
        int pricise = 10;
        if (this.crParams.getMatPricise() != null) {
            pricise = this.crParams.getMatPricise();
        }
        if ((baseunitIndex = this.sourceRowMeta.getFieldIndex("baseunit", false)) > 0 && !CadEmptyUtils.isEmpty(row.getLong(baseunitIndex)) && !CadEmptyUtils.isEmpty(baseUnit = row.getLong(baseunitIndex))) {
            if (this.crParams.getMatPricise() == null) {
                pricise = row.getInteger(this.sourceRowMeta.getFieldIndex("precision"));
            }
            Tuple2 matPrici = new Tuple2((Object)baseUnit, (Object)pricise);
            this.matToBaseUnitMap.put(subMaterialId, (Tuple2<Long, Integer>)matPrici);
            return matPrici;
        }
        DynamicObject subMaterialObj = BusinessDataServiceHelper.loadSingleFromCache((Object)subMaterialId, (String)"bd_material");
        if (subMaterialObj != null) {
            if (this.crParams.getMatPricise() == null) {
                pricise = subMaterialObj.getInt("baseunit.precision");
            }
            Tuple2 matPrici = new Tuple2((Object)subMaterialObj.getLong("baseunit.id"), (Object)pricise);
            this.matToBaseUnitMap.put(subMaterialId, (Tuple2<Long, Integer>)matPrici);
            return matPrici;
        }
        this.matToBaseUnitMap.put(subMaterialId, (Tuple2<Long, Integer>)new Tuple2((Object)0L, (Object)pricise));
        return this.matToBaseUnitMap.get(subMaterialId);
    }

    private BigDecimal getActAmount(RowX row) {
        BigDecimal actAmount = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("actAmountForPurs")));
        if (actAmount.compareTo(BigDecimal.ZERO) != 0) {
            return actAmount;
        }
        actAmount = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("actAmountForTrans")));
        if (actAmount.compareTo(BigDecimal.ZERO) != 0) {
            return actAmount;
        }
        actAmount = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("actAmountForFinish")));
        return actAmount;
    }

    private BigDecimal getActQty(RowX row) {
        BigDecimal actQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("actQtyForPurs")));
        if (actQty.compareTo(BigDecimal.ZERO) != 0) {
            return actQty;
        }
        actQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("actQtyForTrans")));
        if (actQty.compareTo(BigDecimal.ZERO) != 0) {
            return actQty;
        }
        actQty = BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal(this.srcMeta.getFieldIndex("actQtyForFinish")));
        return actQty;
    }
}

